/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.LocalBootable;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.TCPStreamDatabaseInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MDriver
implements Driver {
    static final int DRIVER_MAJOR_VERSION = 1;
    static final int DRIVER_MINOR_VERSION = 0;
    static final String DRIVER_NAME = "Mckoi JDBC Driver";
    static final String DRIVER_VERSION = "1.0";
    private static final String mckoi_protocol_url = "jdbc:mckoi:";
    private static boolean registered = false;
    static int QUERY_TIMEOUT = Integer.MAX_VALUE;
    private Hashtable local_session_map = new Hashtable();

    public static synchronized void register() {
        if (!registered) {
            try {
                DriverManager.registerDriver(new MDriver());
                registered = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parseEncodedVariables(String url_vars, Properties info) {
        StringTokenizer tok = new StringTokenizer(url_vars, "&");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            int split_point = token.indexOf("=");
            if (split_point > 0) {
                String key = token.substring(0, split_point).toLowerCase();
                String value = token.substring(split_point + 1);
                info.put(key, value);
                continue;
            }
            System.err.println("Ignoring url variable: '" + token + "'");
        }
    }

    private static LocalBootable createDefaultLocalBootable() throws SQLException {
        try {
            Class<?> c = Class.forName("com.mckoi.database.jdbcserver.DefaultLocalBootable");
            return (LocalBootable)c.newInstance();
        }
        catch (Throwable e) {
            throw new SQLException("I was unable to find the class that manages local database connections.  This means you may not have included the correct library in your classpath.  Make sure that either mckoidb.jar is in your classpath or your classpath references the complete Mckoi SQL database class hierarchy.");
        }
    }

    private synchronized Object[] connectToLocal(String url, String address_part, Properties info) throws SQLException {
        DatabaseInterface db_interface;
        String session_key;
        LocalBootable local_bootable;
        int schema_del_i;
        String config_path;
        String schema_name = "APP";
        int url_start = address_part.indexOf("?");
        if (url_start == -1) {
            url_start = address_part.length();
        }
        if ((config_path = address_part.substring(8, url_start)).length() == 0) {
            config_path = "./db.conf";
        }
        if (!((config_path = config_path.replace('\\', '/')).startsWith("jar:") || config_path.startsWith("file:/") || config_path.startsWith("ftp:/") || config_path.startsWith("http:/") || config_path.startsWith("https:/"))) {
            File f;
            String post_abs_path;
            String abs_path;
            int schem_del = config_path.indexOf(".conf/");
            if (schem_del == -1) {
                abs_path = config_path;
                post_abs_path = "";
            } else {
                abs_path = config_path.substring(0, schem_del + 5);
                post_abs_path = config_path.substring(schem_del + 5);
            }
            int jar_delim_i = abs_path.indexOf("!/");
            String path_part = abs_path;
            String rest_part = "";
            String pre = "file:/";
            if (jar_delim_i != -1) {
                path_part = abs_path.substring(0, jar_delim_i);
                rest_part = abs_path.substring(jar_delim_i);
                pre = "jar:file:/";
            }
            if (!((f = new File(path_part)).exists() || path_part.startsWith("/") || (f = new File("/" + path_part)).exists())) {
                throw new SQLException("Unable to find file: " + path_part);
            }
            config_path = pre + f.getAbsolutePath() + rest_part + post_abs_path;
            config_path = config_path.replace('\\', '/');
        }
        if ((schema_del_i = config_path.toLowerCase().indexOf(".conf/")) > 0 && schema_del_i + 6 < config_path.length()) {
            schema_name = config_path.substring(schema_del_i + 6);
            config_path = config_path.substring(0, schema_del_i + 5);
        }
        String url_vars = "";
        if (url_start < address_part.length()) {
            url_vars = address_part.substring(url_start + 1).trim();
        }
        if ((local_bootable = (LocalBootable)this.local_session_map.get(session_key = config_path.toLowerCase())) == null) {
            local_bootable = MDriver.createDefaultLocalBootable();
            this.local_session_map.put(session_key, local_bootable);
        }
        if (local_bootable.isBooted()) {
            db_interface = local_bootable.connectToJVM();
        } else {
            File root_path;
            InputStream config_in;
            if (!config_path.startsWith("file:/")) {
                URL config_url;
                try {
                    config_url = new URL(config_path);
                }
                catch (MalformedURLException e) {
                    throw new SQLException("Malformed URL: " + config_path);
                }
                try {
                    config_in = config_url.openConnection().getInputStream();
                }
                catch (IOException e) {
                    throw new SQLException("Unable to open configuration file.  I tried looking at '" + config_url.toString() + "'");
                }
            }
            try {
                config_in = new FileInputStream(new File(config_path.substring(6)));
            }
            catch (IOException e) {
                throw new SQLException("Unable to open configuration file: " + config_path);
            }
            if (config_path.startsWith("jar:file:/") || config_path.startsWith("file:/")) {
                int start_i = config_path.indexOf(":/");
                int file_end_i = config_path.indexOf("!");
                String config_file_part = file_end_i == -1 ? config_path.substring(start_i + 2) : config_path.substring(start_i + 2, file_end_i);
                File absolute_config_file = new File(new File(config_file_part).getAbsolutePath());
                root_path = new File(absolute_config_file.getParent());
            } else {
                root_path = new File(".");
            }
            DefaultDBConfig config = new DefaultDBConfig(root_path);
            try {
                config.loadFromStream(config_in);
                config_in.close();
            }
            catch (IOException e) {
                throw new SQLException("Error reading configuration file: " + config_path + " Reason: " + e.getMessage());
            }
            MDriver.parseEncodedVariables(url_vars, info);
            boolean create_db = false;
            boolean create_db_if_not_exist = false;
            create_db = info.getProperty("create", "").equals("true");
            create_db_if_not_exist = info.getProperty("boot_or_create", "").equals("true") || info.getProperty("create_or_boot", "").equals("true");
            Enumeration<Object> prop_keys = info.keys();
            while (prop_keys.hasMoreElements()) {
                String key = prop_keys.nextElement().toString();
                if (key.equals("user") || key.equals("password")) continue;
                config.setValue(key, (String)info.get(key));
            }
            boolean database_exists = local_bootable.checkExists(config);
            if (create_db_if_not_exist && !database_exists) {
                create_db = true;
            }
            if (create_db && database_exists) {
                throw new SQLException("Can not create database because a database already exists.");
            }
            if (!create_db && !database_exists) {
                throw new SQLException("Can not find a database to start.  Either the database needs to be created or the 'database_path' property of the configuration must be set to the location of the data files.");
            }
            if (create_db) {
                String username = info.getProperty("user", "");
                String password = info.getProperty("password", "");
                db_interface = local_bootable.create(username, password, config);
            } else {
                db_interface = local_bootable.boot(config);
            }
        }
        Object[] ret = new Object[]{db_interface, schema_name};
        return ret;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        int max_row_cache_size;
        int row_cache_size;
        DatabaseInterface db_interface;
        if (!this.acceptsURL(url)) {
            return null;
        }
        String default_schema = "APP";
        String address_part = url.substring(url.indexOf(mckoi_protocol_url) + mckoi_protocol_url.length());
        if (address_part.startsWith("local://")) {
            Object[] ret_list = this.connectToLocal(url, address_part, info);
            db_interface = (DatabaseInterface)ret_list[0];
            default_schema = (String)ret_list[1];
            row_cache_size = 43;
            max_row_cache_size = 4092000;
        } else {
            int port = 9157;
            String host = "127.0.0.1";
            if (address_part.startsWith("//")) {
                String remote_address;
                int delim;
                int end_address;
                String args_string = "";
                int arg_part = address_part.indexOf(63, 2);
                if (arg_part != -1) {
                    args_string = address_part.substring(arg_part + 1);
                    address_part = address_part.substring(0, arg_part);
                }
                if ((end_address = address_part.indexOf("/", 2)) == -1) {
                    end_address = address_part.length();
                }
                if ((delim = (remote_address = address_part.substring(2, end_address)).indexOf(58)) == -1) {
                    delim = remote_address.length();
                }
                host = remote_address.substring(0, delim);
                if (delim < remote_address.length() - 1) {
                    port = Integer.parseInt(remote_address.substring(delim + 1));
                }
                String schema_part = "";
                if (end_address < address_part.length()) {
                    schema_part = address_part.substring(end_address + 1);
                }
                String schema_string = schema_part;
                int schema_end = schema_part.indexOf(47);
                if (schema_end != -1) {
                    schema_string = schema_part.substring(0, schema_end);
                } else {
                    schema_end = schema_part.indexOf(63);
                    if (schema_end != -1) {
                        schema_string = schema_part.substring(0, schema_end);
                    }
                }
                if (!args_string.equals("")) {
                    MDriver.parseEncodedVariables(args_string, info);
                }
                if (schema_string.length() > 0) {
                    default_schema = schema_string;
                }
            } else if (address_part.trim().length() > 0) {
                throw new SQLException("Malformed URL: " + address_part);
            }
            try {
                Thread.sleep(85L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TCPStreamDatabaseInterface tcp_db_interface = new TCPStreamDatabaseInterface(host, port);
            tcp_db_interface.connectToDatabase();
            db_interface = tcp_db_interface;
            row_cache_size = 4111;
            max_row_cache_size = 0x7D0000;
        }
        MConnection connection = new MConnection(url, db_interface, row_cache_size, max_row_cache_size);
        connection.login(info, default_schema);
        return connection;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(mckoi_protocol_url) || url.startsWith(":jdbc:mckoi:");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

