/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class MBlob
implements Blob {
    private ByteLongObject blob;

    MBlob(ByteLongObject blob) {
        this.blob = blob;
    }

    public long length() throws SQLException {
        return this.blob.length();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (--pos < 0L || pos + (long)length > this.length()) {
            throw new SQLException("Out of bounds.");
        }
        byte[] buf = new byte[length];
        System.arraycopy(this.blob.getByteArray(), (int)pos, buf, 0, length);
        return buf;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.blob.getByteArray(), 0, (int)this.length());
    }

    public long position(byte[] pattern, long start) throws SQLException {
        byte[] buf = this.blob.getByteArray();
        int len = (int)this.length();
        int max = (int)this.length() - pattern.length;
        int i = (int)(start - 1L);
        while (true) {
            int found_index;
            if (i <= max && buf[i] != pattern[0]) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1L;
            }
            int search_from = i;
            for (found_index = 1; found_index < pattern.length && buf[search_from] == pattern[found_index]; ++found_index) {
                ++search_from;
            }
            ++i;
            if (found_index >= pattern.length) break;
        }
        return i;
    }

    public long position(Blob pattern, long start) throws SQLException {
        byte[] buf = pattern instanceof MBlob ? ((MBlob)pattern).blob.getByteArray() : pattern.getBytes(0L, (int)pattern.length());
        return this.position(buf, start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        long s = pos;
        long e = pos + length;
        if (s > Integer.MAX_VALUE || s < 0L || e > Integer.MAX_VALUE || e < 0L || s > e) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteArrayInputStream(this.blob.getByteArray(), (int)pos, (int)length);
    }
}

