/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

class AsciiInputStream
extends InputStream {
    private Reader reader;

    public AsciiInputStream(Reader reader) {
        this.reader = reader;
    }

    public AsciiInputStream(String s) {
        this(new StringReader(s));
    }

    public int read() throws IOException {
        int i = this.reader.read();
        if (i == -1) {
            return i;
        }
        return i & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int end = off + len;
        int read_count = 0;
        for (int i = off; i < end; ++i) {
            int val = this.read();
            if (val == -1) {
                if (read_count == 0) {
                    return -1;
                }
                return read_count;
            }
            b[i] = (byte)val;
            ++read_count;
        }
        return read_count;
    }

    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    public int available() throws IOException {
        return 0;
    }

    public void reset() throws IOException {
        this.reader.reset();
    }
}

