/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.interpret.Statement;

public class UserManager
extends Statement {
    private void internalSetUserGroupsAndLock(DatabaseQueryContext context, String username, Expression[] groups_list, String lock_status) throws DatabaseException {
        Database db = context.getDatabase();
        if (groups_list != null) {
            db.deleteAllUserGroups(context, username);
            for (int i = 0; i < groups_list.length; ++i) {
                TObject group_tob = groups_list[i].evaluate(null, null, context);
                String group_str = group_tob.getObject().toString();
                db.addUserToGroup(context, username, group_str);
            }
        }
        if (lock_status != null) {
            if (lock_status.equals("LOCK")) {
                db.setUserLock(context, this.user, true);
            } else {
                db.setUserLock(context, this.user, false);
            }
        }
    }

    private void internalCreateUser(DatabaseQueryContext context, String username, String password_str, Expression[] groups_list, String lock_status) throws DatabaseException {
        Database db = context.getDatabase();
        db.createUser(context, username, password_str);
        this.internalSetUserGroupsAndLock(context, username, groups_list, lock_status);
        db.grantHostAccessToUser(context, username, "TCP", "%");
        db.grantHostAccessToUser(context, username, "Local", "%");
    }

    public void prepare() throws DatabaseException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String command_type = (String)this.cmd.getObject("type");
        String username = (String)this.cmd.getObject("username");
        boolean modify_own_record = command_type.equals("ALTER USER") && this.user.getUserName().equals(username);
        boolean secure_access_privs = context.getDatabase().canUserCreateAndDropUsers(context, this.user);
        if (!modify_own_record && !secure_access_privs) {
            throw new DatabaseException("User is not permitted to create, alter or drop user.");
        }
        if (username.equalsIgnoreCase("public")) {
            throw new DatabaseException("Username 'public' is reserved.");
        }
        if (command_type.equals("CREATE USER") || command_type.equals("ALTER USER")) {
            Database db;
            Expression password = (Expression)this.cmd.getObject("password_expression");
            Expression[] groups_list = (Expression[])this.cmd.getObject("groups_list");
            String lock_status = (String)this.cmd.getObject("lock_status");
            String password_str = null;
            if (password != null) {
                TObject passwd_tob = password.evaluate(null, null, context);
                password_str = passwd_tob.getObject().toString();
            }
            if (command_type.equals("CREATE USER")) {
                db = context.getDatabase();
                if (db.userExists(context, username)) throw new DatabaseException("User '" + username + "' already exists.");
                this.internalCreateUser(context, username, password_str, groups_list, lock_status);
                return FunctionTable.resultTable(context, 0);
            } else {
                if (!command_type.equals("ALTER USER")) return FunctionTable.resultTable(context, 0);
                if (!secure_access_privs) {
                    if (groups_list != null) {
                        throw new DatabaseException("User is not permitted to alter user groups.");
                    }
                    if (lock_status != null) {
                        throw new DatabaseException("User is not permitted to alter user lock status.");
                    }
                }
                if (!(db = context.getDatabase()).userExists(context, username)) throw new DatabaseException("User '" + username + "' doesn't exist.");
                if (password_str != null) {
                    db.alterUserPassword(context, username, password_str);
                }
                this.internalSetUserGroupsAndLock(context, username, groups_list, lock_status);
            }
            return FunctionTable.resultTable(context, 0);
        } else {
            if (!command_type.equals("DROP USER")) throw new DatabaseException("Unknown user manager command: " + command_type);
            Database db = context.getDatabase();
            if (!db.userExists(context, username)) throw new DatabaseException("User '" + username + "' doesn't exist.");
            db.deleteUser(context, username);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

