/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.User;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.Planner;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;
import java.util.ArrayList;

public class Select
extends Statement {
    private TableSelectExpression select_expression;
    private ArrayList order_by;
    private Variable[] order_cols;
    private QueryPlanNode plan;

    static final void checkUserSelectPermissions(DatabaseQueryContext context, User user, QueryPlanNode plan) throws UserAccessException, DatabaseException {
        ArrayList touched_tables = plan.discoverTableNames(new ArrayList());
        Database dbase = context.getDatabase();
        for (int i = 0; i < touched_tables.size(); ++i) {
            TableName t = (TableName)touched_tables.get(i);
            if (dbase.canUserSelectFromTableObject(context, user, t, null)) continue;
            throw new UserAccessException("User not permitted to select from table: " + t);
        }
    }

    public void prepare() throws DatabaseException {
        DatabaseConnection db = this.database;
        this.select_expression = (TableSelectExpression)this.cmd.getObject("table_expression");
        this.order_by = (ArrayList)this.cmd.getObject("order_by");
        TableExpressionFromSet from_set = Planner.generateFromSet(this.select_expression, db);
        this.plan = Planner.formQueryPlan(db, this.select_expression, from_set, this.order_by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        Select.checkUserSelectPermissions(context, this.user, this.plan);
        boolean error = true;
        try {
            Table t = this.plan.evaluate(context);
            error = false;
            Table table = t;
            Object var6_5 = null;
            if (this.Debug().isInterestedIn(10) || error && this.Debug().isInterestedIn(20)) {
                StringBuffer buf = new StringBuffer();
                this.plan.debugString(0, buf);
                this.Debug().write(20, this, "Query Plan debug:\n" + buf.toString());
            }
            return table;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (!this.Debug().isInterestedIn(10) && (!error || !this.Debug().isInterestedIn(20))) break block3;
                StringBuffer buf = new StringBuffer();
                this.plan.debugString(0, buf);
                this.Debug().write(20, this, "Query Plan debug:\n" + buf.toString());
            }
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ SELECT: expression=");
        buf.append(this.select_expression.toString());
        buf.append(" ORDER_BY=");
        buf.append(this.order_by);
        buf.append(" ]");
        return new String(buf);
    }
}

