/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.interpret.TableSelectExpression;
import java.io.Serializable;

public final class FromTableDef
implements Serializable,
Cloneable {
    static final long serialVersionUID = -606852454508224625L;
    private boolean subquery_table;
    private String unique_key;
    private String table_name;
    private String table_alias;
    private TableSelectExpression subselect_table;

    public FromTableDef(String table_name, String table_alias) {
        this.table_name = table_name;
        this.table_alias = table_alias;
        this.subselect_table = null;
        this.subquery_table = false;
    }

    public FromTableDef(String table_name) {
        this(table_name, null);
    }

    public FromTableDef(TableSelectExpression select, String table_alias) {
        this.subselect_table = select;
        this.table_name = table_alias;
        this.table_alias = table_alias;
        this.subquery_table = true;
    }

    public FromTableDef(TableSelectExpression select) {
        this.subselect_table = select;
        this.table_name = null;
        this.table_alias = null;
        this.subquery_table = true;
    }

    public void setUniqueKey(String unique_key) {
        this.unique_key = unique_key;
    }

    public String getName() {
        return this.table_name;
    }

    public String getAlias() {
        return this.table_alias;
    }

    public String getUniqueKey() {
        return this.unique_key;
    }

    public boolean isSubQueryTable() {
        return this.subquery_table;
    }

    public TableSelectExpression getTableSelectExpression() {
        return this.subselect_table;
    }

    public void prepareExpressions(ExpressionPreparer preparer) throws DatabaseException {
        if (this.subselect_table != null) {
            this.subselect_table.prepareExpressions(preparer);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FromTableDef v = (FromTableDef)super.clone();
        if (this.subselect_table != null) {
            v.subselect_table = (TableSelectExpression)this.subselect_table.clone();
        }
        return v;
    }
}

