/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.JoiningSet;
import com.mckoi.database.StatementTreeObject;
import com.mckoi.database.TableName;
import com.mckoi.database.interpret.FromTableDef;
import com.mckoi.database.interpret.TableSelectExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public final class FromClause
implements Serializable,
StatementTreeObject,
Cloneable {
    static final long serialVersionUID = 565726601314503609L;
    private JoiningSet join_set = new JoiningSet();
    private ArrayList def_list = new ArrayList();
    private ArrayList all_table_names = new ArrayList();
    private int table_key = 0;

    private String createNewKey() {
        ++this.table_key;
        return Integer.toString(this.table_key);
    }

    private void addTableDef(String table_name, FromTableDef def) {
        if (table_name != null) {
            if (this.all_table_names.contains(table_name)) {
                throw new Error("Duplicate table name in FROM clause: " + table_name);
            }
            this.all_table_names.add(table_name);
        }
        String key = this.createNewKey();
        def.setUniqueKey(key);
        this.join_set.addTable(new TableName(key));
        this.def_list.add(def);
    }

    public void addTable(String table_name) {
        this.addTableDef(table_name, new FromTableDef(table_name));
    }

    public void addTable(String table_name, String table_alias) {
        this.addTableDef(table_alias, new FromTableDef(table_name, table_alias));
    }

    public void addTableDeclaration(String table_name, TableSelectExpression select, String table_alias) {
        if (table_name == null && select != null) {
            if (table_alias == null) {
                this.addTableDef(null, new FromTableDef(select));
            } else {
                this.addTableDef(table_alias, new FromTableDef(select, table_alias));
            }
        } else if (table_name != null && select == null) {
            if (table_alias == null) {
                this.addTable(table_name);
            } else {
                this.addTable(table_name, table_alias);
            }
        } else {
            throw new Error("Unvalid declaration parameters.");
        }
    }

    public void addJoin(int type) {
        this.join_set.addJoin(type);
    }

    public void addPreviousJoin(int type, Expression on_expression) {
        this.join_set.addPreviousJoin(type, on_expression);
    }

    public void addJoin(int type, Expression on_expression) {
        this.join_set.addJoin(type, on_expression);
    }

    public JoiningSet getJoinSet() {
        return this.join_set;
    }

    public int getJoinType(int n) {
        return this.getJoinSet().getJoinType(n);
    }

    public Expression getOnExpression(int n) {
        return this.getJoinSet().getOnExpression(n);
    }

    public Collection allTables() {
        return this.def_list;
    }

    public void prepareExpressions(ExpressionPreparer preparer) throws DatabaseException {
        int i;
        int size = this.join_set.getTableCount() - 1;
        for (i = 0; i < size; ++i) {
            Expression exp = this.join_set.getOnExpression(i);
            if (exp == null) continue;
            exp.prepare(preparer);
        }
        for (i = 0; i < this.def_list.size(); ++i) {
            FromTableDef table_def = (FromTableDef)this.def_list.get(i);
            table_def.prepareExpressions(preparer);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList<Object> cloned_def_list;
        FromClause v = (FromClause)super.clone();
        v.join_set = (JoiningSet)this.join_set.clone();
        v.def_list = cloned_def_list = new ArrayList<Object>(this.def_list.size());
        v.all_table_names = (ArrayList)this.all_table_names.clone();
        for (int i = 0; i < this.def_list.size(); ++i) {
            FromTableDef table_def = (FromTableDef)this.def_list.get(i);
            cloned_def_list.add(table_def.clone());
        }
        return v;
    }
}

