/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseConstraintViolationException;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.GrantManager;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;
import java.util.ArrayList;

public class DropTable
extends Statement {
    boolean only_if_exists = false;
    ArrayList drop_tables = new ArrayList();

    public void prepare() throws DatabaseException {
        this.only_if_exists = this.cmd.getBoolean("only_if_exists");
        this.drop_tables = (ArrayList)this.cmd.getObject("table_list");
        for (int i = 0; i < this.drop_tables.size(); ++i) {
            Object check = this.drop_tables.get(i);
            for (int n = i + 1; n < this.drop_tables.size(); ++n) {
                if (!this.drop_tables.get(n).equals(check)) continue;
                throw new DatabaseException("Duplicate table in drop: " + check);
            }
        }
    }

    public Table evaluate() throws DatabaseException {
        TableName tname;
        int i;
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        int list_size = this.drop_tables.size();
        ArrayList<TableName> resolved_tables = new ArrayList<TableName>(list_size);
        for (i = 0; i < list_size; ++i) {
            String table_name = this.drop_tables.get(i).toString();
            TableName tname2 = this.resolveTableName(table_name, this.database);
            if (!this.only_if_exists && !this.database.tableExists(tname2)) {
                throw new DatabaseException("Table '" + tname2 + "' does not exist.");
            }
            resolved_tables.add(tname2);
            if (this.database.getDatabase().canUserDropTableObject(context, this.user, tname2)) continue;
            throw new UserAccessException("User not permitted to drop table: " + tname2);
        }
        for (i = 0; i < list_size; ++i) {
            tname = (TableName)resolved_tables.get(i);
            Transaction.ColumnGroupReference[] refs = this.database.queryTableImportedForeignKeyReferences(tname);
            for (int n = 0; n < refs.length; ++n) {
                if (resolved_tables.contains(refs[n].key_table_name)) continue;
                throw new DatabaseConstraintViolationException(26, "Constraint violation (" + refs[n].name + ") dropping table " + tname + " because of referential link from " + refs[n].key_table_name);
            }
        }
        if (!this.only_if_exists) {
            for (i = 0; i < list_size; ++i) {
                tname = (TableName)resolved_tables.get(i);
                if (this.database.tableExists(tname)) continue;
                throw new DatabaseException("Can not drop table '" + tname + "'.  It does not exist.");
            }
        }
        int dropped_table_count = 0;
        GrantManager grant_manager = this.database.getGrantManager();
        for (int i2 = 0; i2 < list_size; ++i2) {
            TableName tname3 = (TableName)resolved_tables.get(i2);
            if (!this.database.tableExists(tname3)) continue;
            this.database.dropTable(tname3);
            grant_manager.revokeAllGrantsOnObject(1, tname3.toString());
            this.database.dropAllConstraintsForTable(tname3);
            ++dropped_table_count;
        }
        return FunctionTable.resultTable(context, 0);
    }
}

