/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.ConnectionTriggerManager;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.ProcedureManager;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.interpret.Statement;
import java.util.List;

public class CreateTrigger
extends Statement {
    public void prepare() throws DatabaseException {
    }

    public Table evaluate() throws DatabaseException {
        String trigger_name = (String)this.cmd.getObject("trigger_name");
        String type = (String)this.cmd.getObject("type");
        String table_name = (String)this.cmd.getObject("table_name");
        List types = (List)this.cmd.getObject("trigger_types");
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        TableName tname = TableName.resolve(this.database.getCurrentSchema(), table_name);
        if (type.equals("callback_trigger")) {
            int int_type;
            if (types.size() > 1) {
                throw new DatabaseException("Multiple triggered types not allowed for callback triggers.");
            }
            String trig_type = ((String)types.get(0)).toUpperCase();
            if (trig_type.equals("INSERT")) {
                int_type = 1;
            } else if (trig_type.equals("DELETE")) {
                int_type = 2;
            } else if (trig_type.equals("UPDATE")) {
                int_type = 3;
            } else {
                throw new DatabaseException("Unknown trigger type: " + trig_type);
            }
            this.database.createTrigger(trigger_name, tname.toString(), int_type);
        } else if (type.equals("procedure_trigger")) {
            ProcedureManager proc_manager = this.database.getProcedureManager();
            String before_after = (String)this.cmd.getObject("before_after");
            String procedure_name = (String)this.cmd.getObject("procedure_name");
            Expression[] procedure_args = (Expression[])this.cmd.getObject("procedure_args");
            String schema_name = this.database.getCurrentSchema();
            TableName t_name = TableName.resolve(schema_name, trigger_name);
            t_name = this.database.tryResolveCase(t_name);
            TableName t_p_name = TableName.resolve(schema_name, procedure_name);
            t_p_name = this.database.tryResolveCase(t_p_name);
            ProcedureName p_name = new ProcedureName(t_p_name);
            if (this.database.tableExists(t_name)) {
                throw new DatabaseException("A database object with name '" + t_name + "' already exists.");
            }
            if (!proc_manager.procedureExists(p_name)) {
                throw new DatabaseException("Procedure '" + p_name + "' could not be found.");
            }
            int listen_type = 0;
            if (before_after.equals("before")) {
                listen_type |= 0x10;
            } else if (before_after.equals("after")) {
                listen_type |= 0x20;
            } else {
                throw new RuntimeException("Unknown before/after type.");
            }
            for (int i = 0; i < types.size(); ++i) {
                String trig_type = (String)types.get(i);
                if (trig_type.equals("insert")) {
                    listen_type |= 1;
                    continue;
                }
                if (trig_type.equals("delete")) {
                    listen_type |= 4;
                    continue;
                }
                if (!trig_type.equals("update")) continue;
                listen_type |= 2;
            }
            TObject[] vals = new TObject[procedure_args.length];
            for (int i = 0; i < procedure_args.length; ++i) {
                vals[i] = procedure_args[i].evaluate(null, null, context);
            }
            ConnectionTriggerManager manager = this.database.getConnectionTriggerManager();
            manager.createTableTrigger(t_name.getSchema(), t_name.getName(), listen_type, tname, p_name.toString(), vals);
            this.database.getGrantManager().addGrant(Privileges.PROCEDURE_ALL_PRIVS, 1, t_name.toString(), this.user.getUserName(), true, "@SYSTEM");
        } else {
            throw new RuntimeException("Unknown trigger type.");
        }
        return FunctionTable.resultTable(context, 0);
    }
}

