/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementTreeObject;
import com.mckoi.database.TType;
import com.mckoi.database.sql.ParseException;
import com.mckoi.database.sql.Token;
import java.io.Serializable;

public final class ColumnDef
implements Serializable,
StatementTreeObject,
Cloneable {
    static final long serialVersionUID = 8347617136528650961L;
    String name;
    TType type;
    String index_str;
    Expression default_expression;
    Expression original_default_expression;
    private boolean not_null = false;
    private boolean primary_key = false;
    private boolean unique = false;

    public boolean isPrimaryKey() {
        return this.primary_key;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isNotNull() {
        return this.not_null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addConstraint(String constraint) {
        if (constraint.equals("NOT NULL")) {
            this.not_null = true;
        } else if (constraint.equals("NULL")) {
            this.not_null = false;
        } else if (constraint.equals("PRIMARY")) {
            this.primary_key = true;
        } else if (constraint.equals("UNIQUE")) {
            this.unique = true;
        } else {
            throw new RuntimeException("Unknown constraint: " + constraint);
        }
    }

    public void setDataType(TType type) {
        this.type = type;
    }

    public void setIndex(Token t) throws ParseException {
        if (t.kind == 141) {
            this.index_str = "BlindSearch";
        } else if (t.kind == 142) {
            this.index_str = "InsertSearch";
        } else {
            throw new ParseException("Unrecognized indexing scheme.");
        }
    }

    public void setDefaultExpression(Expression exp) {
        this.default_expression = exp;
        try {
            this.original_default_expression = (Expression)exp.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.getMessage());
        }
    }

    public void prepareExpressions(ExpressionPreparer preparer) throws DatabaseException {
        if (this.default_expression != null) {
            this.default_expression.prepare(preparer);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnDef v = (ColumnDef)super.clone();
        if (this.default_expression != null) {
            v.default_expression = (Expression)this.default_expression.clone();
        }
        return v;
    }
}

