/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.ProcedureManager;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;

public class Call
extends Statement {
    public void prepare() throws DatabaseException {
    }

    public Table evaluate() throws DatabaseException {
        TableName tp_name;
        String schema_name;
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String proc_name = (String)this.cmd.getObject("proc_name");
        Expression[] args = (Expression[])this.cmd.getObject("args");
        ProcedureManager manager = this.database.getProcedureManager();
        TableName p_name = null;
        if (proc_name.indexOf(".") == -1) {
            schema_name = this.database.getCurrentSchema();
            tp_name = TableName.resolve("SYS_INFO", proc_name);
            if (manager.procedureExists(tp_name = this.database.tryResolveCase(tp_name))) {
                p_name = tp_name;
            }
        }
        if (p_name == null) {
            schema_name = this.database.getCurrentSchema();
            tp_name = TableName.resolve(schema_name, proc_name);
            tp_name = this.database.tryResolveCase(tp_name);
            boolean ignore_case = this.database.isInCaseInsensitiveMode();
            SchemaDef schema = this.database.resolveSchemaCase(tp_name.getSchema(), ignore_case);
            if (schema == null) {
                throw new DatabaseException("Schema '" + tp_name.getSchema() + "' doesn't exist.");
            }
            tp_name = new TableName(schema.getName(), tp_name.getName());
            if (!manager.procedureExists(tp_name)) {
                throw new DatabaseException("Stored procedure '" + proc_name + "' was not found.");
            }
            p_name = tp_name;
        }
        ProcedureName name = new ProcedureName(p_name);
        if (!this.database.getDatabase().canUserExecuteStoredProcedure(context, this.user, name.toString())) {
            throw new UserAccessException("User not permitted to call: " + proc_name);
        }
        TObject[] vals = new TObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isConstant()) {
                throw new StatementException("CALL argument is not a constant: " + args[i].text());
            }
            vals[i] = args[i].evaluate(null, null, context);
        }
        TObject result = manager.invokeProcedure(name, vals);
        return FunctionTable.resultTable(context, result);
    }
}

