/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class ObjectTranslator {
    public static Object translate(Object ob) {
        if (ob == null) {
            return null;
        }
        if (ob instanceof String) {
            return StringObject.fromString((String)ob);
        }
        if (ob instanceof StringObject || ob instanceof BigNumber || ob instanceof Date || ob instanceof ByteLongObject || ob instanceof Boolean || ob instanceof StreamableObject) {
            return ob;
        }
        if (ob instanceof byte[]) {
            return new ByteLongObject((byte[])ob);
        }
        if (ob instanceof Serializable) {
            return ObjectTranslator.serialize(ob);
        }
        throw new Error("Unable to translate object.  It is not a primitive type or serializable.");
    }

    public static ByteLongObject serialize(Object ob) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream ob_out = new ObjectOutputStream(bout);
            ob_out.writeObject(ob);
            ob_out.close();
            return new ByteLongObject(bout.toByteArray());
        }
        catch (IOException e) {
            throw new Error("Serialization error: " + e.getMessage());
        }
    }

    public static Object deserialize(ByteLongObject blob) {
        if (blob == null) {
            return null;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(blob.getByteArray());
            ObjectInputStream ob_in = new ObjectInputStream(bin);
            Object ob = ob_in.readObject();
            ob_in.close();
            return ob;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Class not found: " + e.getMessage());
        }
        catch (IOException e) {
            throw new Error("De-serialization error: " + e.getMessage());
        }
    }
}

