/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.control;

import com.mckoi.database.control.DBConfig;
import com.mckoi.database.control.DBSystem;
import com.mckoi.database.jdbcserver.TCPServer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TCPJDBCServer {
    private static final int DEFAULT_TCP_PORT = 9157;
    private DBSystem system;
    private InetAddress bind_address;
    private int tcp_port;
    private TCPServer server;

    public TCPJDBCServer(DBSystem system, InetAddress bind_address, int tcp_port) {
        this.system = system;
        this.bind_address = bind_address;
        this.tcp_port = tcp_port;
        this.registerShutdownDelegate();
    }

    public TCPJDBCServer(DBSystem system, int tcp_port) {
        this(system, null, tcp_port);
    }

    public TCPJDBCServer(DBSystem system) {
        this.system = system;
        DBConfig config = system.getConfig();
        int jdbc_port = 9157;
        InetAddress interface_address = null;
        String jdbc_port_str = config.getValue("jdbc_server_port");
        String interface_addr_str = config.getValue("jdbc_server_address");
        if (jdbc_port_str != null) {
            try {
                jdbc_port = Integer.parseInt(jdbc_port_str);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to parse 'jdbc_server_port'");
            }
        }
        if (interface_addr_str != null) {
            try {
                interface_address = InetAddress.getByName(interface_addr_str);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Unknown host: " + e.getMessage());
            }
        }
        this.tcp_port = jdbc_port;
        this.bind_address = interface_address;
        this.registerShutdownDelegate();
    }

    private void registerShutdownDelegate() {
        this.system.getDatabase().registerShutDownDelegate(new Runnable(){

            public void run() {
                if (TCPJDBCServer.this.server != null) {
                    TCPJDBCServer.this.stop();
                }
            }
        });
    }

    public synchronized void start() {
        if (this.server != null) {
            throw new RuntimeException("'start' method called when a server was already started.");
        }
        this.server = new TCPServer(this.system.getDatabase());
        this.server.start(this.bind_address, this.tcp_port, "multi_threaded");
    }

    public synchronized void stop() {
        if (this.server == null) {
            throw new RuntimeException("'stop' method called when no server was started.");
        }
        this.server.close();
        this.server = null;
    }

    public String toString() {
        return this.server.toString();
    }
}

