/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractInternalTableInfo2;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.Operator;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableBackedCache;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.User;
import com.mckoi.database.Variable;
import com.mckoi.database.ViewDef;
import com.mckoi.database.global.BlobAccessor;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.util.IntegerVector;
import java.util.HashMap;

public class ViewManager {
    private DatabaseConnection connection;
    private DatabaseQueryContext context;
    private boolean view_table_changed;
    private HashMap local_cache;

    ViewManager(DatabaseConnection connection) {
        this.connection = connection;
        this.context = new DatabaseQueryContext(connection);
        this.local_cache = new HashMap();
        this.view_table_changed = false;
        connection.attachTableBackedCache(new TableBackedCache(Database.SYS_VIEW){

            public void purgeCacheOfInvalidatedEntries(IntegerVector added_rows, IntegerVector removed_rows) {
                if (ViewManager.this.view_table_changed) {
                    ViewManager.this.invalidateViewCache();
                    ViewManager.this.view_table_changed = false;
                } else if (added_rows != null && added_rows.size() > 0 || removed_rows != null && removed_rows.size() > 0) {
                    ViewManager.this.invalidateViewCache();
                }
            }
        });
    }

    private HashMap getViewCache() {
        return this.local_cache;
    }

    private void invalidateViewCache() {
        this.local_cache.clear();
    }

    private Table findViewEntry(DataTable table, TableName view_name) {
        Operator EQUALS = Operator.get("=");
        Variable schemav = table.getResolvedVariable(0);
        Variable namev = table.getResolvedVariable(1);
        Table t = table.simpleSelect(this.context, namev, EQUALS, new Expression(TObject.stringVal(view_name.getName())));
        if ((t = t.exhaustiveSelect(this.context, Expression.simple(schemav, EQUALS, TObject.stringVal(view_name.getSchema())))).getRowCount() > 1) {
            throw new RuntimeException("Assert failed: multiple view entries for " + view_name);
        }
        return t;
    }

    public boolean viewExists(TableName view_name) {
        DataTable table = this.connection.getTable(Database.SYS_VIEW);
        return this.findViewEntry(table, view_name).getRowCount() == 1;
    }

    public void defineView(ViewDef view, SQLQuery query, User user) throws DatabaseException {
        DataTableDef data_table_def = view.getDataTableDef();
        DataTable view_table = this.connection.getTable(Database.SYS_VIEW);
        TableName view_name = data_table_def.getTableName();
        RowData rdat = new RowData(view_table);
        rdat.setColumnDataFromObject(0, data_table_def.getSchema());
        rdat.setColumnDataFromObject(1, data_table_def.getName());
        rdat.setColumnDataFromObject(2, query.serializeToBlob());
        rdat.setColumnDataFromObject(3, view.serializeToBlob());
        rdat.setColumnDataFromObject(4, user.getUserName());
        Table t = this.findViewEntry(view_table, view_name);
        if (t.getRowCount() == 1) {
            view_table.delete(t);
        }
        view_table.add(rdat);
        this.connection.databaseObjectCreated(view_name);
        this.view_table_changed = true;
    }

    public boolean deleteView(TableName view_name) throws DatabaseException {
        DataTable table = this.connection.getTable(Database.SYS_VIEW);
        Table t = this.findViewEntry(table, view_name);
        if (t.getRowCount() == 0) {
            return false;
        }
        table.delete(t);
        this.connection.databaseObjectDropped(view_name);
        this.view_table_changed = true;
        return true;
    }

    private static ViewDef getViewDef(HashMap cache, TableDataSource view_table, TableName view_name) {
        RowEnumeration e = view_table.rowEnumeration();
        while (e.hasMoreRows()) {
            int row = e.nextRowIndex();
            String c_schema = view_table.getCellContents(0, row).getObject().toString();
            String c_name = view_table.getCellContents(1, row).getObject().toString();
            if (!view_name.getSchema().equals(c_schema) || !view_name.getName().equals(c_name)) continue;
            Long cache_key = new Long(row);
            ViewDef view_def = (ViewDef)cache.get(cache_key);
            if (view_def == null) {
                BlobAccessor blob = (BlobAccessor)view_table.getCellContents(3, row).getObject();
                view_def = ViewDef.deserializeFromBlob(blob);
                cache.put(cache_key, view_def);
            }
            return view_def;
        }
        throw new StatementException("View '" + view_name + "' not found.");
    }

    private static ViewDef getViewDef(HashMap cache, TableDataSource view_table, int index) {
        RowEnumeration e = view_table.rowEnumeration();
        int i = 0;
        while (e.hasMoreRows()) {
            int row = e.nextRowIndex();
            if (i == index) {
                Long cache_key = new Long(row);
                ViewDef view_def = (ViewDef)cache.get(cache_key);
                if (view_def == null) {
                    BlobAccessor blob = (BlobAccessor)view_table.getCellContents(3, row).getObject();
                    view_def = ViewDef.deserializeFromBlob(blob);
                    cache.put(cache_key, view_def);
                }
                return view_def;
            }
            ++i;
        }
        throw new Error("Index out of range.");
    }

    public QueryPlanNode createViewQueryPlanNode(TableName view_name) {
        DataTable table = this.connection.getTable(Database.SYS_VIEW);
        return ViewManager.getViewDef(this.local_cache, (TableDataSource)table, view_name).getQueryPlanNode();
    }

    static InternalTableInfo createInternalTableInfo(ViewManager manager, Transaction transaction) {
        return new ViewInternalTableInfo(manager, transaction);
    }

    private static class ViewInternalTableInfo
    extends AbstractInternalTableInfo2 {
        ViewManager view_manager;
        HashMap view_cache;

        ViewInternalTableInfo(ViewManager manager, Transaction transaction) {
            super(transaction, Database.SYS_VIEW);
            this.view_manager = manager;
            this.view_cache = this.view_manager == null ? new HashMap() : this.view_manager.getViewCache();
        }

        public String getTableType(int i) {
            return "VIEW";
        }

        public DataTableDef getDataTableDef(int i) {
            return ViewManager.getViewDef(this.view_cache, this.transaction.getTable(Database.SYS_VIEW), i).getDataTableDef();
        }

        public MutableTableDataSource createInternalTable(int i) {
            throw new RuntimeException("Not supported for views.");
        }
    }
}

