/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.TriggerEvent;
import com.mckoi.database.TriggerListener;
import com.mckoi.util.HashMapList;
import java.util.ArrayList;
import java.util.List;

final class TriggerManager {
    private TransactionSystem system;
    private HashMapList listener_map;
    private HashMapList table_map;

    TriggerManager(TransactionSystem system) {
        this.system = system;
        this.listener_map = new HashMapList();
        this.table_map = new HashMapList();
    }

    void flushTriggerEvents(ArrayList event_list) {
        for (int i = 0; i < event_list.size(); ++i) {
            TriggerEvent evt = (TriggerEvent)event_list.get(i);
            this.fireTrigger(evt);
        }
    }

    synchronized void addTriggerListener(DatabaseConnection database, String trigger_name, int event_id, String trigger_source, TriggerListener listener) {
        List list = this.listener_map.get(database);
        for (int i = 0; i < list.size(); ++i) {
            TriggerAction action = (TriggerAction)list.get(i);
            if (!action.getName().equals(trigger_name)) continue;
            throw new Error("Duplicate trigger name '" + trigger_name + "'");
        }
        TriggerAction action = new TriggerAction(database, trigger_name, event_id, trigger_source, listener);
        this.listener_map.put(database, action);
        this.table_map.put(trigger_source, action);
    }

    synchronized void removeTriggerListener(DatabaseConnection database, String trigger_name) {
        List list = this.listener_map.get(database);
        for (int i = 0; i < list.size(); ++i) {
            TriggerAction action = (TriggerAction)list.get(i);
            if (!action.getName().equals(trigger_name)) continue;
            this.listener_map.remove(database, action);
            this.table_map.remove(action.trigger_source, action);
            return;
        }
        throw new Error("Trigger name '" + trigger_name + "' not found.");
    }

    synchronized void clearAllDatabaseConnectionTriggers(DatabaseConnection database) {
        List list = this.listener_map.clear(database);
        for (int i = 0; i < list.size(); ++i) {
            TriggerAction action = (TriggerAction)list.get(i);
            this.table_map.remove(action.trigger_source, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTrigger(final TriggerEvent evt) {
        ArrayList trig_list;
        TriggerManager triggerManager = this;
        synchronized (triggerManager) {
            List list = this.table_map.get(evt.getSource());
            if (list.size() == 0) {
                return;
            }
            trig_list = new ArrayList(list);
        }
        Runnable runner = new Runnable(){

            public void run() {
                for (int i = 0; i < trig_list.size(); ++i) {
                    TriggerAction action = (TriggerAction)trig_list.get(i);
                    if (evt.getType() != action.trigger_event) continue;
                    action.listener.fireTrigger(action.database, action.trigger_name, evt);
                }
            }
        };
        this.system.postEvent(3, this.system.createEvent(runner));
    }

    private static class TriggerAction {
        private DatabaseConnection database;
        private String trigger_name;
        private TriggerListener listener;
        private String trigger_source;
        private int trigger_event;

        TriggerAction(DatabaseConnection database, String name, int type, String trigger_source, TriggerListener listener) {
            this.database = database;
            this.trigger_name = name;
            this.trigger_event = type;
            this.listener = listener;
            this.trigger_source = trigger_source;
        }

        public String getName() {
            return this.trigger_name;
        }
    }
}

