/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.MasterTableJournal;
import com.mckoi.util.IntegerVector;
import java.util.ArrayList;

final class TransactionJournal {
    static byte TABLE_ADD = 1;
    static byte TABLE_REMOVE = (byte)2;
    static byte TABLE_CREATE = (byte)3;
    static byte TABLE_DROP = (byte)4;
    static byte TABLE_CONSTRAINT_ALTER = (byte)5;
    private int journal_entries = 0;
    private IntegerVector touched_tables;
    private byte[] command_journal = new byte[16];
    private IntegerVector command_parameters = new IntegerVector(32);
    private boolean has_added_table_rows = false;
    private boolean has_removed_table_rows = false;
    private boolean has_created_tables = false;
    private boolean has_dropped_tables = false;
    private boolean has_constraint_alterations = false;

    TransactionJournal() {
        this.touched_tables = new IntegerVector(8);
    }

    private void addCommand(byte command) {
        if (this.journal_entries >= this.command_journal.length) {
            int grow_size = Math.min(4000, this.journal_entries);
            byte[] new_command_journal = new byte[this.journal_entries + grow_size];
            System.arraycopy(this.command_journal, 0, new_command_journal, 0, this.journal_entries);
            this.command_journal = new_command_journal;
        }
        this.command_journal[this.journal_entries] = command;
        ++this.journal_entries;
    }

    private void addParameter(int param) {
        this.command_parameters.addInt(param);
    }

    synchronized void entryAddTouchedTable(int table_id) {
        int pos = this.touched_tables.sortedIndexOf(table_id);
        if (pos < this.touched_tables.size() && this.touched_tables.intAt(pos) == table_id) {
            return;
        }
        if (pos >= this.touched_tables.size()) {
            this.touched_tables.addInt(table_id);
        } else {
            this.touched_tables.insertIntAt(table_id, pos);
        }
    }

    synchronized void entryAddTableRow(int table_id, int row_index) {
        this.addCommand(TABLE_ADD);
        this.addParameter(table_id);
        this.addParameter(row_index);
    }

    synchronized void entryRemoveTableRow(int table_id, int row_index) {
        this.addCommand(TABLE_REMOVE);
        this.addParameter(table_id);
        this.addParameter(row_index);
    }

    synchronized void entryTableCreate(int table_id) {
        this.has_created_tables = true;
        this.addCommand(TABLE_CREATE);
        this.addParameter(table_id);
    }

    synchronized void entryTableDrop(int table_id) {
        this.has_dropped_tables = true;
        this.addCommand(TABLE_DROP);
        this.addParameter(table_id);
    }

    synchronized void entryTableConstraintAlter(int table_id) {
        this.has_constraint_alterations = true;
        this.addCommand(TABLE_CONSTRAINT_ALTER);
        this.addParameter(table_id);
    }

    MasterTableJournal[] makeMasterTableJournals() {
        ArrayList<MasterTableJournal> table_journals = new ArrayList<MasterTableJournal>();
        int param_index = 0;
        MasterTableJournal master_journal = null;
        for (int i = 0; i < this.journal_entries; ++i) {
            byte c = this.command_journal[i];
            if (c == TABLE_ADD || c == TABLE_REMOVE) {
                int table_id = this.command_parameters.intAt(param_index);
                int row_index = this.command_parameters.intAt(param_index + 1);
                param_index += 2;
                if (master_journal == null || master_journal.getTableID() != table_id) {
                    int size = table_journals.size();
                    master_journal = null;
                    for (int n = 0; n < size && master_journal == null; ++n) {
                        MasterTableJournal test_journal = (MasterTableJournal)table_journals.get(n);
                        if (test_journal.getTableID() != table_id) continue;
                        master_journal = test_journal;
                    }
                    if (master_journal == null) {
                        master_journal = new MasterTableJournal(table_id);
                        table_journals.add(master_journal);
                    }
                }
                master_journal.addEntry(c, row_index);
                continue;
            }
            if (c == TABLE_CREATE || c == TABLE_DROP || c == TABLE_CONSTRAINT_ALTER) {
                ++param_index;
                continue;
            }
            throw new Error("Unknown journal command.");
        }
        return table_journals.toArray(new MasterTableJournal[table_journals.size()]);
    }

    IntegerVector getTablesDropped() {
        IntegerVector dropped_tables = new IntegerVector();
        if (!this.has_dropped_tables) {
            return dropped_tables;
        }
        int param_index = 0;
        for (int i = 0; i < this.journal_entries; ++i) {
            byte c = this.command_journal[i];
            if (c == TABLE_ADD || c == TABLE_REMOVE) {
                param_index += 2;
                continue;
            }
            if (c == TABLE_CREATE || c == TABLE_CONSTRAINT_ALTER) {
                ++param_index;
                continue;
            }
            if (c == TABLE_DROP) {
                dropped_tables.addInt(this.command_parameters.intAt(param_index));
                ++param_index;
                continue;
            }
            throw new Error("Unknown journal command.");
        }
        return dropped_tables;
    }

    IntegerVector getTablesCreated() {
        IntegerVector created_tables = new IntegerVector();
        if (!this.has_created_tables) {
            return created_tables;
        }
        int param_index = 0;
        for (int i = 0; i < this.journal_entries; ++i) {
            byte c = this.command_journal[i];
            if (c == TABLE_ADD || c == TABLE_REMOVE) {
                param_index += 2;
                continue;
            }
            if (c == TABLE_DROP || c == TABLE_CONSTRAINT_ALTER) {
                ++param_index;
                continue;
            }
            if (c == TABLE_CREATE) {
                created_tables.addInt(this.command_parameters.intAt(param_index));
                ++param_index;
                continue;
            }
            throw new Error("Unknown journal command.");
        }
        return created_tables;
    }

    IntegerVector getTablesConstraintAltered() {
        IntegerVector caltered_tables = new IntegerVector();
        if (!this.has_constraint_alterations) {
            return caltered_tables;
        }
        int param_index = 0;
        for (int i = 0; i < this.journal_entries; ++i) {
            byte c = this.command_journal[i];
            if (c == TABLE_ADD || c == TABLE_REMOVE) {
                param_index += 2;
                continue;
            }
            if (c == TABLE_DROP || c == TABLE_CREATE) {
                ++param_index;
                continue;
            }
            if (c == TABLE_CONSTRAINT_ALTER) {
                caltered_tables.addInt(this.command_parameters.intAt(param_index));
                ++param_index;
                continue;
            }
            throw new Error("Unknown journal command.");
        }
        return caltered_tables;
    }
}

