/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractInternalTableInfo;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConstraintViolationException;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.GTProductDataSource;
import com.mckoi.database.GTTableColumnsDataSource;
import com.mckoi.database.GTTableInfoDataSource;
import com.mckoi.database.IndexSet;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.SequenceManager;
import com.mckoi.database.SimpleTableQuery;
import com.mckoi.database.SimpleTransaction;
import com.mckoi.database.StatementException;
import com.mckoi.database.SystemQueryContext;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionException;
import com.mckoi.database.TransactionJournal;
import com.mckoi.database.V1MasterTableDataSource;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.util.BigNumber;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.util.ArrayList;

public class Transaction
extends SimpleTransaction {
    public static final short INITIALLY_DEFERRED = 5;
    public static final short INITIALLY_IMMEDIATE = 6;
    public static final short NOT_DEFERRABLE = 7;
    public static final String NO_ACTION = "NO ACTION";
    public static final String CASCADE = "CASCADE";
    public static final String SET_NULL = "SET NULL";
    public static final String SET_DEFAULT = "SET DEFAULT";
    private TableDataConglomerate conglomerate;
    private long commit_id;
    private ArrayList touched_tables;
    private ArrayList selected_from_tables;
    private ArrayList created_database_objects;
    private ArrayList dropped_database_objects;
    private TransactionJournal journal;
    private InternalTableInfo[] internal_tables;
    private int internal_tables_i;
    private boolean transaction_error_on_dirty_select;
    private boolean closed;
    private static final DataTableDef[] INTERNAL_DEF_LIST = new DataTableDef[3];
    static /* synthetic */ Class class$com$mckoi$database$Transaction;

    Transaction(TableDataConglomerate conglomerate, long commit_id, ArrayList visible_tables, ArrayList table_indices) {
        super(conglomerate.getSystem(), conglomerate.getSequenceManager());
        this.conglomerate = conglomerate;
        this.commit_id = commit_id;
        this.closed = false;
        this.created_database_objects = new ArrayList();
        this.dropped_database_objects = new ArrayList();
        this.touched_tables = new ArrayList();
        this.selected_from_tables = new ArrayList();
        this.journal = new TransactionJournal();
        int sz = visible_tables.size();
        for (int i = 0; i < sz; ++i) {
            this.addVisibleTable((MasterTableDataSource)visible_tables.get(i), (IndexSet)table_indices.get(i));
        }
        this.internal_tables = new InternalTableInfo[8];
        this.internal_tables_i = 0;
        this.addInternalTableInfo(new TransactionInternalTables());
        this.getSystem().stats().increment("Transaction.count");
        this.transaction_error_on_dirty_select = true;
    }

    final TableDataConglomerate getConglomerate() {
        return this.conglomerate;
    }

    void addInternalTableInfo(InternalTableInfo info) {
        if (this.internal_tables_i >= this.internal_tables.length) {
            throw new RuntimeException("Internal table list bounds reached.");
        }
        this.internal_tables[this.internal_tables_i] = info;
        ++this.internal_tables_i;
    }

    long getCommitID() {
        return this.commit_id;
    }

    public MutableTableDataSource createMutableTableDataSourceAtCommit(MasterTableDataSource master) {
        MutableTableDataSource table = master.createTableDataSourceAtCommit(this);
        this.journal.entryAddTouchedTable(master.getTableID());
        this.touched_tables.add(table);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedFromTable(TableName table_name) {
        if (this.isDynamicTable(table_name)) {
            return;
        }
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table with name not available: " + table_name);
        }
        ArrayList arrayList = this.selected_from_tables;
        synchronized (arrayList) {
            if (!this.selected_from_tables.contains(master)) {
                this.selected_from_tables.add(master);
            }
        }
    }

    void liveCopyAllDataTo(TableDataConglomerate dest_conglomerate) {
        TableName table_name;
        MasterTableDataSource master_table;
        int i;
        int sz = this.getVisibleTableCount();
        ArrayList<MasterTableDataSource> copy_list = new ArrayList<MasterTableDataSource>(sz);
        MasterTableDataSource sequence_info_table = null;
        for (i = 0; i < sz; ++i) {
            master_table = this.getVisibleTable(i);
            table_name = master_table.getDataTableDef().getTableName();
            if (table_name.equals(TableDataConglomerate.SYS_SEQUENCE_INFO)) {
                sequence_info_table = master_table;
                continue;
            }
            copy_list.add(master_table);
        }
        copy_list.add(sequence_info_table);
        try {
            for (i = 0; i < sz; ++i) {
                master_table = (MasterTableDataSource)copy_list.get(i);
                table_name = master_table.getDataTableDef().getTableName();
                Transaction dest_transaction = dest_conglomerate.createTransaction();
                IndexSet index_set = this.getIndexSetForTable(master_table);
                if (dest_transaction.tableExists(table_name)) {
                    dest_transaction.dropTable(table_name);
                }
                dest_transaction.copyTable(master_table, index_set);
                dest_transaction.closeAndCommit();
                index_set.dispose();
            }
        }
        catch (TransactionException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("Transaction Error when copying table: " + e.getMessage());
        }
    }

    protected boolean isDynamicTable(TableName table_name) {
        for (int i = 0; i < this.internal_tables.length; ++i) {
            InternalTableInfo info = this.internal_tables[i];
            if (info == null || !info.containsTableName(table_name)) continue;
            return true;
        }
        return false;
    }

    protected TableName[] getDynamicTableList() {
        int sz = 0;
        for (int i = 0; i < this.internal_tables.length; ++i) {
            InternalTableInfo info = this.internal_tables[i];
            if (info == null) continue;
            sz += info.getTableCount();
        }
        TableName[] list = new TableName[sz];
        int index = 0;
        for (int i = 0; i < this.internal_tables.length; ++i) {
            InternalTableInfo info = this.internal_tables[i];
            if (info == null) continue;
            sz = info.getTableCount();
            for (int n = 0; n < sz; ++n) {
                list[index] = info.getTableName(n);
                ++index;
            }
        }
        return list;
    }

    protected DataTableDef getDynamicDataTableDef(TableName table_name) {
        for (int i = 0; i < this.internal_tables.length; ++i) {
            int index;
            InternalTableInfo info = this.internal_tables[i];
            if (info == null || (index = info.findTableName(table_name)) == -1) continue;
            return info.getDataTableDef(index);
        }
        throw new RuntimeException("Not an internal table: " + table_name);
    }

    protected MutableTableDataSource getDynamicTable(TableName table_name) {
        for (int i = 0; i < this.internal_tables.length; ++i) {
            int index;
            InternalTableInfo info = this.internal_tables[i];
            if (info == null || (index = info.findTableName(table_name)) == -1) continue;
            return info.createInternalTable(index);
        }
        throw new RuntimeException("Not an internal table: " + table_name);
    }

    public String getDynamicTableType(TableName table_name) {
        for (int i = 0; i < this.internal_tables.length; ++i) {
            int index;
            InternalTableInfo info = this.internal_tables[i];
            if (info == null || (index = info.findTableName(table_name)) == -1) continue;
            return info.getTableType(index);
        }
        throw new RuntimeException("No table '" + table_name + "' to report type for.");
    }

    public void createTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        TableName table_name = table_def.getTableName();
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master != null) {
            throw new StatementException("Table '" + table_name + "' already exists.");
        }
        table_def.setImmutable();
        if (data_sector_size < 27) {
            data_sector_size = 27;
        } else if (data_sector_size > 4096) {
            data_sector_size = 4096;
        }
        master = this.conglomerate.createMasterTable(table_def, data_sector_size, index_sector_size);
        this.addVisibleTable(master, master.createIndexSet());
        int table_id = master.getTableID();
        this.journal.entryAddTouchedTable(table_id);
        this.journal.entryTableCreate(table_id);
        SequenceManager.addNativeTableGenerator(this, table_name);
        this.databaseObjectCreated(table_name);
    }

    public void createTable(DataTableDef table_def) {
        this.createTable(table_def, 251, 1024);
    }

    public void alterCreateTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        if (!this.tableExists(table_def.getTableName())) {
            this.createTable(table_def, data_sector_size, index_sector_size);
        } else {
            this.alterTable(table_def.getTableName(), table_def, data_sector_size, index_sector_size);
        }
    }

    public void dropTable(TableName table_name) {
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table '" + table_name + "' doesn't exist.");
        }
        this.removeVisibleTable(master);
        int table_id = master.getTableID();
        this.journal.entryAddTouchedTable(table_id);
        this.journal.entryTableDrop(table_id);
        SequenceManager.removeNativeTableGenerator(this, table_name);
        this.databaseObjectDropped(table_name);
    }

    public void copyTable(MasterTableDataSource src_master_table, IndexSet index_set) {
        DataTableDef table_def = src_master_table.getDataTableDef();
        TableName table_name = table_def.getTableName();
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master != null) {
            throw new StatementException("Unable to copy.  Table '" + table_name + "' already exists.");
        }
        master = this.conglomerate.copyMasterTable(src_master_table, index_set);
        this.addVisibleTable(master, master.createIndexSet());
        int table_id = master.getTableID();
        this.journal.entryAddTouchedTable(table_id);
        this.journal.entryTableCreate(table_id);
        SequenceManager.addNativeTableGenerator(this, table_name);
        this.databaseObjectCreated(table_name);
    }

    public void alterTable(TableName table_name, DataTableDef table_def, int data_sector_size, int index_sector_size) {
        table_def.setImmutable();
        String current_schema = table_name.getSchema();
        SystemQueryContext context = new SystemQueryContext(this, current_schema);
        long next_id = this.nextUniqueID(table_name);
        MutableTableDataSource c_table = this.getTable(table_name);
        this.dropTable(table_name);
        this.createTable(table_def);
        MutableTableDataSource altered_table = this.getTable(table_name);
        MasterTableDataSource new_master_table = this.findVisibleTable(table_name, false);
        new_master_table.setUniqueID(next_id);
        int[] col_map = new int[table_def.columnCount()];
        DataTableDef orig_td = c_table.getDataTableDef();
        for (int i = 0; i < col_map.length; ++i) {
            String col_name = table_def.columnAt(i).getName();
            col_map[i] = orig_td.findColumnName(col_name);
        }
        try {
            try {
                RowEnumeration e = c_table.rowEnumeration();
                while (e.hasMoreRows()) {
                    int row_index = e.nextRowIndex();
                    RowData row_data = new RowData(altered_table);
                    for (int i = 0; i < col_map.length; ++i) {
                        int col = col_map[i];
                        if (col == -1) continue;
                        row_data.setColumnData(i, c_table.getCellContents(col, row_index));
                    }
                    row_data.setDefaultForRest(context);
                    int new_row_number = new_master_table.addRow(row_data);
                    new_master_table.writeRecordType(new_row_number, 16);
                }
            }
            catch (DatabaseException e) {
                this.Debug().writeException(e);
                throw new RuntimeException(e.getMessage());
            }
            new_master_table.buildIndexes();
            this.setIndexSetForTable(new_master_table, new_master_table.createIndexSet());
            this.flushTableCache(table_name);
            SequenceManager.removeNativeTableGenerator(this, table_name);
            SequenceManager.addNativeTableGenerator(this, table_name);
            this.databaseObjectDropped(table_name);
            this.databaseObjectCreated(table_name);
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void alterTable(TableName table_name, DataTableDef table_def) {
        try {
            MasterTableDataSource master = this.findVisibleTable(table_name, false);
            int current_data_sector_size = master instanceof V1MasterTableDataSource ? ((V1MasterTableDataSource)master).rawDataSectorSize() : -1;
            this.alterTable(table_name, table_def, current_data_sector_size, 2043);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    public void checkAllConstraints(TableName table_name) {
        MutableTableDataSource table = this.getTable(table_name);
        int[] rows = new int[table.getRowCount()];
        RowEnumeration row_enum = table.rowEnumeration();
        int i = 0;
        while (row_enum.hasMoreRows()) {
            rows[i] = row_enum.nextRowIndex();
            ++i;
        }
        TableDataConglomerate.checkAddConstraintViolations((SimpleTransaction)this, (TableDataSource)table, rows, (short)6);
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table '" + table_name + "' doesn't exist.");
        }
        int table_id = master.getTableID();
        this.journal.entryAddTouchedTable(table_id);
        this.journal.entryTableConstraintAlter(table_id);
    }

    public void compactTable(TableName table_name) {
        MasterTableDataSource current_table = this.findVisibleTable(table_name, false);
        if (current_table == null) {
            throw new StatementException("Table '" + table_name + "' doesn't exist.");
        }
        if (current_table.isWorthCompacting()) {
            IndexSet index_set = this.getIndexSetForTable(current_table);
            this.dropTable(table_name);
            this.copyTable(current_table, index_set);
        }
    }

    boolean transactionErrorOnDirtySelect() {
        return this.transaction_error_on_dirty_select;
    }

    void setErrorOnDirtySelect(boolean status) {
        this.transaction_error_on_dirty_select = status;
    }

    private static String[] toColumns(SimpleTableQuery dt, IntegerVector cols) {
        int size = cols.size();
        String[] list = new String[size];
        block0: for (int n = 0; n < size; ++n) {
            for (int i = 0; i < size; ++i) {
                int row_index = cols.intAt(i);
                int seq_no = ((BigNumber)dt.get(2, row_index).getObject()).intValue();
                if (seq_no != n) continue;
                list[n] = dt.get(1, row_index).getObject().toString();
                continue block0;
            }
        }
        return list;
    }

    private static String makeUniqueConstraintName(String name, BigNumber unique_id) {
        if (name == null) {
            name = "_ANONYMOUS_CONSTRAINT_" + unique_id.toString();
        }
        return name;
    }

    void databaseObjectCreated(TableName table_name) {
        boolean dropped = this.dropped_database_objects.remove(table_name);
        if (!dropped) {
            this.created_database_objects.add(table_name);
        }
    }

    void databaseObjectDropped(TableName table_name) {
        boolean created = this.created_database_objects.remove(table_name);
        if (!created) {
            this.dropped_database_objects.add(table_name);
        }
    }

    ArrayList getAllNamesCreated() {
        return this.created_database_objects;
    }

    ArrayList getAllNamesDropped() {
        return this.dropped_database_objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String name, String type) {
        TableName table_name = TableDataConglomerate.SCHEMA_INFO_TABLE;
        MutableTableDataSource t = this.getTable(table_name);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        try {
            if (dt.existsSingle(1, name)) {
                throw new StatementException("Schema already exists: " + name);
            }
            RowData rd = new RowData(t);
            BigNumber unique_id = BigNumber.fromLong(this.nextUniqueID(table_name));
            rd.setColumnDataFromObject(0, unique_id);
            rd.setColumnDataFromObject(1, name);
            rd.setColumnDataFromObject(2, type);
            t.addRow(rd);
            Object var9_8 = null;
            dt.dispose();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            dt.dispose();
            throw throwable;
        }
    }

    public void dropSchema(String name) {
        TableName table_name = TableDataConglomerate.SCHEMA_INFO_TABLE;
        MutableTableDataSource t = this.getTable(table_name);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        boolean b = dt.deleteSingle(1, name);
        dt.dispose();
        if (!b) {
            throw new StatementException("Schema doesn't exists: " + name);
        }
    }

    public boolean schemaExists(String name) {
        TableName table_name = TableDataConglomerate.SCHEMA_INFO_TABLE;
        MutableTableDataSource t = this.getTable(table_name);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        boolean b = dt.existsSingle(1, name);
        dt.dispose();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaDef resolveSchemaCase(String name, boolean ignore_case) {
        SchemaDef schemaDef;
        SimpleTableQuery dt;
        block8: {
            SchemaDef schemaDef2;
            block7: {
                dt = new SimpleTableQuery(this.getTable(TableDataConglomerate.SCHEMA_INFO_TABLE));
                try {
                    RowEnumeration e = dt.rowEnumeration();
                    if (ignore_case) {
                        SchemaDef result = null;
                        while (true) {
                            if (!e.hasMoreRows()) {
                                SchemaDef row_index = result;
                                Object var10_15 = null;
                                dt.dispose();
                                return row_index;
                            }
                            int row_index = e.nextRowIndex();
                            String cur_name = dt.get(1, row_index).getObject().toString();
                            if (!name.equalsIgnoreCase(cur_name)) continue;
                            if (result != null) {
                                throw new StatementException("Ambiguous schema name: '" + name + "'");
                            }
                            String type = dt.get(2, row_index).getObject().toString();
                            result = new SchemaDef(cur_name, type);
                        }
                    }
                    while (e.hasMoreRows()) {
                        int row_index = e.nextRowIndex();
                        String cur_name = dt.get(1, row_index).getObject().toString();
                        if (!name.equals(cur_name)) continue;
                        String type = dt.get(2, row_index).getObject().toString();
                        schemaDef2 = new SchemaDef(cur_name, type);
                        break block7;
                    }
                    schemaDef = null;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    dt.dispose();
                    throw throwable;
                }
            }
            Object var10_16 = null;
            dt.dispose();
            return schemaDef2;
        }
        Object var10_17 = null;
        dt.dispose();
        return schemaDef;
    }

    public SchemaDef[] getSchemaList() {
        SimpleTableQuery dt = new SimpleTableQuery(this.getTable(TableDataConglomerate.SCHEMA_INFO_TABLE));
        RowEnumeration e = dt.rowEnumeration();
        SchemaDef[] arr = new SchemaDef[dt.getRowCount()];
        int i = 0;
        while (e.hasMoreRows()) {
            int row_index = e.nextRowIndex();
            String cur_name = dt.get(1, row_index).getObject().toString();
            String cur_type = dt.get(2, row_index).getObject().toString();
            arr[i] = new SchemaDef(cur_name, cur_type);
            ++i;
        }
        dt.dispose();
        return arr;
    }

    public void setPersistentVar(String variable, String value) {
        TableName table_name = TableDataConglomerate.PERSISTENT_VAR_TABLE;
        MutableTableDataSource t = this.getTable(table_name);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        dt.setVar(0, new Object[]{variable, value});
        dt.dispose();
    }

    public String getPersistantVar(String variable) {
        TableName table_name = TableDataConglomerate.PERSISTENT_VAR_TABLE;
        MutableTableDataSource t = this.getTable(table_name);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        String val = dt.getVar(1, 0, variable).toString();
        dt.dispose();
        return val;
    }

    public void createSequenceGenerator(TableName name, long start_value, long increment_by, long min_value, long max_value, long cache, boolean cycle) {
        SequenceManager.createSequenceGenerator(this, name, start_value, increment_by, min_value, max_value, cache, cycle);
        this.databaseObjectCreated(name);
    }

    public void dropSequenceGenerator(TableName name) {
        SequenceManager.dropSequenceGenerator(this, name);
        this.flushSequenceManager(name);
        this.databaseObjectDropped(name);
    }

    public void addUniqueConstraint(TableName table_name, String[] cols, short deferred, String constraint_name) {
        TableName tn1 = TableDataConglomerate.UNIQUE_INFO_TABLE;
        TableName tn2 = TableDataConglomerate.UNIQUE_COLS_TABLE;
        MutableTableDataSource t = this.getTable(tn1);
        MutableTableDataSource tcols = this.getTable(tn2);
        try {
            RowData rd = new RowData(t);
            BigNumber unique_id = BigNumber.fromLong(this.nextUniqueID(tn1));
            constraint_name = Transaction.makeUniqueConstraintName(constraint_name, unique_id);
            rd.setColumnDataFromObject(0, unique_id);
            rd.setColumnDataFromObject(1, constraint_name);
            rd.setColumnDataFromObject(2, table_name.getSchema());
            rd.setColumnDataFromObject(3, table_name.getName());
            rd.setColumnDataFromObject(4, BigNumber.fromInt(deferred));
            t.addRow(rd);
            for (int i = 0; i < cols.length; ++i) {
                rd = new RowData(tcols);
                rd.setColumnDataFromObject(0, unique_id);
                rd.setColumnDataFromObject(1, cols[i]);
                rd.setColumnDataFromObject(2, BigNumber.fromInt(i));
                tcols.addRow(rd);
            }
        }
        catch (DatabaseConstraintViolationException e) {
            if (e.getErrorCode() == 21) {
                throw new StatementException("Unique constraint name '" + constraint_name + "' is already being used.");
            }
            throw e;
        }
    }

    public void addForeignKeyConstraint(TableName table, String[] cols, TableName ref_table, String[] ref_cols, String delete_rule, String update_rule, short deferred, String constraint_name) {
        TableName tn1 = TableDataConglomerate.FOREIGN_INFO_TABLE;
        TableName tn2 = TableDataConglomerate.FOREIGN_COLS_TABLE;
        MutableTableDataSource t = this.getTable(tn1);
        MutableTableDataSource tcols = this.getTable(tn2);
        try {
            if (ref_cols.length == 0) {
                ColumnGroup set = Transaction.queryTablePrimaryKeyGroup(this, ref_table);
                if (set == null) {
                    throw new StatementException("No primary key defined for referenced table '" + ref_table + "'");
                }
                ref_cols = set.columns;
            }
            if (cols.length != ref_cols.length) {
                throw new StatementException("Foreign key reference '" + table + "' -> '" + ref_table + "' does not have an equal number of " + "column terms.");
            }
            if (delete_rule.equals(SET_NULL) || update_rule.equals(SET_NULL)) {
                DataTableDef table_def = this.getDataTableDef(table);
                for (int i = 0; i < cols.length; ++i) {
                    DataTableColumnDef column_def = table_def.columnAt(table_def.findColumnName(cols[i]));
                    if (!column_def.isNotNull()) continue;
                    throw new StatementException("Foreign key reference '" + table + "' -> '" + ref_table + "' update or delete triggered " + "action is SET NULL for columns that are constrained as " + "NOT NULL.");
                }
            }
            RowData rd = new RowData(t);
            BigNumber unique_id = BigNumber.fromLong(this.nextUniqueID(tn1));
            constraint_name = Transaction.makeUniqueConstraintName(constraint_name, unique_id);
            rd.setColumnDataFromObject(0, unique_id);
            rd.setColumnDataFromObject(1, constraint_name);
            rd.setColumnDataFromObject(2, table.getSchema());
            rd.setColumnDataFromObject(3, table.getName());
            rd.setColumnDataFromObject(4, ref_table.getSchema());
            rd.setColumnDataFromObject(5, ref_table.getName());
            rd.setColumnDataFromObject(6, update_rule);
            rd.setColumnDataFromObject(7, delete_rule);
            rd.setColumnDataFromObject(8, BigNumber.fromInt(deferred));
            t.addRow(rd);
            for (int i = 0; i < cols.length; ++i) {
                rd = new RowData(tcols);
                rd.setColumnDataFromObject(0, unique_id);
                rd.setColumnDataFromObject(1, cols[i]);
                rd.setColumnDataFromObject(2, ref_cols[i]);
                rd.setColumnDataFromObject(3, BigNumber.fromInt(i));
                tcols.addRow(rd);
            }
        }
        catch (DatabaseConstraintViolationException e) {
            if (e.getErrorCode() == 21) {
                throw new StatementException("Foreign key constraint name '" + constraint_name + "' is already being used.");
            }
            throw e;
        }
    }

    public void addPrimaryKeyConstraint(TableName table_name, String[] cols, short deferred, String constraint_name) {
        TableName tn1 = TableDataConglomerate.PRIMARY_INFO_TABLE;
        TableName tn2 = TableDataConglomerate.PRIMARY_COLS_TABLE;
        MutableTableDataSource t = this.getTable(tn1);
        MutableTableDataSource tcols = this.getTable(tn2);
        try {
            RowData rd = new RowData(t);
            BigNumber unique_id = BigNumber.fromLong(this.nextUniqueID(tn1));
            constraint_name = Transaction.makeUniqueConstraintName(constraint_name, unique_id);
            rd.setColumnDataFromObject(0, unique_id);
            rd.setColumnDataFromObject(1, constraint_name);
            rd.setColumnDataFromObject(2, table_name.getSchema());
            rd.setColumnDataFromObject(3, table_name.getName());
            rd.setColumnDataFromObject(4, BigNumber.fromInt(deferred));
            t.addRow(rd);
            for (int i = 0; i < cols.length; ++i) {
                rd = new RowData(tcols);
                rd.setColumnDataFromObject(0, unique_id);
                rd.setColumnDataFromObject(1, cols[i]);
                rd.setColumnDataFromObject(2, BigNumber.fromInt(i));
                tcols.addRow(rd);
            }
        }
        catch (DatabaseConstraintViolationException e) {
            if (e.getErrorCode() == 21) {
                throw new StatementException("Primary key constraint name '" + constraint_name + "' is already being used.");
            }
            throw e;
        }
    }

    public void addCheckConstraint(TableName table_name, Expression expression, short deferred, String constraint_name) {
        TableName tn = TableDataConglomerate.CHECK_INFO_TABLE;
        MutableTableDataSource t = this.getTable(tn);
        int col_count = t.getDataTableDef().columnCount();
        try {
            BigNumber unique_id = BigNumber.fromLong(this.nextUniqueID(tn));
            constraint_name = Transaction.makeUniqueConstraintName(constraint_name, unique_id);
            RowData rd = new RowData(t);
            rd.setColumnDataFromObject(0, unique_id);
            rd.setColumnDataFromObject(1, constraint_name);
            rd.setColumnDataFromObject(2, table_name.getSchema());
            rd.setColumnDataFromObject(3, table_name.getName());
            rd.setColumnDataFromObject(4, new String(expression.text()));
            rd.setColumnDataFromObject(5, BigNumber.fromInt(deferred));
            if (col_count > 6) {
                ByteLongObject serialized_expression = ObjectTranslator.serialize(expression);
                rd.setColumnDataFromObject(6, serialized_expression);
            }
            t.addRow(rd);
        }
        catch (DatabaseConstraintViolationException e) {
            if (e.getErrorCode() == 21) {
                throw new StatementException("Check constraint name '" + constraint_name + "' is already being used.");
            }
            throw e;
        }
    }

    public void dropAllConstraintsForTable(TableName table_name) {
        int i;
        ColumnGroup primary = Transaction.queryTablePrimaryKeyGroup(this, table_name);
        ColumnGroup[] uniques = Transaction.queryTableUniqueGroups(this, table_name);
        CheckExpression[] expressions = Transaction.queryTableCheckExpressions(this, table_name);
        ColumnGroupReference[] refs = Transaction.queryTableForeignKeyReferences(this, table_name);
        if (primary != null) {
            this.dropPrimaryKeyConstraintForTable(table_name, primary.name);
        }
        for (i = 0; i < uniques.length; ++i) {
            this.dropUniqueConstraintForTable(table_name, uniques[i].name);
        }
        for (i = 0; i < expressions.length; ++i) {
            this.dropCheckConstraintForTable(table_name, expressions[i].name);
        }
        for (i = 0; i < refs.length; ++i) {
            this.dropForeignKeyReferenceConstraintForTable(table_name, refs[i].name);
        }
    }

    public int dropNamedConstraint(TableName table_name, String constraint_name) {
        int drop_count = 0;
        if (this.dropPrimaryKeyConstraintForTable(table_name, constraint_name)) {
            ++drop_count;
        }
        if (this.dropUniqueConstraintForTable(table_name, constraint_name)) {
            ++drop_count;
        }
        if (this.dropCheckConstraintForTable(table_name, constraint_name)) {
            ++drop_count;
        }
        if (this.dropForeignKeyReferenceConstraintForTable(table_name, constraint_name)) {
            ++drop_count;
        }
        return drop_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropPrimaryKeyConstraintForTable(TableName table_name, String constraint_name) {
        SimpleTableQuery dtcols;
        SimpleTableQuery dt;
        block4: {
            MutableTableDataSource t = this.getTable(TableDataConglomerate.PRIMARY_INFO_TABLE);
            MutableTableDataSource t2 = this.getTable(TableDataConglomerate.PRIMARY_COLS_TABLE);
            dt = new SimpleTableQuery(t);
            dtcols = new SimpleTableQuery(t2);
            try {
                IntegerVector data = constraint_name != null ? dt.selectIndexesEqual(1, constraint_name, 2, table_name.getSchema()) : dt.selectIndexesEqual(3, table_name.getName(), 2, table_name.getSchema());
                if (data.size() > 1) {
                    throw new Error("Assertion failed: multiple primary key for: " + table_name);
                }
                if (data.size() != 1) break block4;
                int row_index = data.intAt(0);
                TObject id = dt.get(0, row_index);
                IntegerVector ivec = dtcols.selectIndexesEqual(0, id);
                dtcols.deleteRows(ivec);
                dt.deleteRows(data);
                boolean bl = true;
                Object var13_13 = null;
                dtcols.dispose();
                dt.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                dtcols.dispose();
                dt.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var13_14 = null;
        dtcols.dispose();
        dt.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropUniqueConstraintForTable(TableName table, String constraint_name) {
        SimpleTableQuery dtcols;
        SimpleTableQuery dt;
        block4: {
            MutableTableDataSource t = this.getTable(TableDataConglomerate.UNIQUE_INFO_TABLE);
            MutableTableDataSource t2 = this.getTable(TableDataConglomerate.UNIQUE_COLS_TABLE);
            dt = new SimpleTableQuery(t);
            dtcols = new SimpleTableQuery(t2);
            try {
                IntegerVector data = dt.selectIndexesEqual(1, constraint_name, 2, table.getSchema());
                if (data.size() > 1) {
                    throw new Error("Assertion failed: multiple unique constraint name: " + constraint_name);
                }
                if (data.size() != 1) break block4;
                int row_index = data.intAt(0);
                TObject id = dt.get(0, row_index);
                IntegerVector ivec = dtcols.selectIndexesEqual(0, id);
                dtcols.deleteRows(ivec);
                dt.deleteRows(data);
                boolean bl = true;
                Object var13_13 = null;
                dtcols.dispose();
                dt.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                dtcols.dispose();
                dt.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var13_14 = null;
        dtcols.dispose();
        dt.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCheckConstraintForTable(TableName table, String constraint_name) {
        SimpleTableQuery dt;
        block4: {
            MutableTableDataSource t = this.getTable(TableDataConglomerate.CHECK_INFO_TABLE);
            dt = new SimpleTableQuery(t);
            try {
                IntegerVector data = dt.selectIndexesEqual(1, constraint_name, 2, table.getSchema());
                if (data.size() > 1) {
                    throw new Error("Assertion failed: multiple check constraint name: " + constraint_name);
                }
                if (data.size() != 1) break block4;
                dt.deleteRows(data);
                boolean bl = true;
                Object var8_8 = null;
                dt.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                dt.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var8_9 = null;
        dt.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropForeignKeyReferenceConstraintForTable(TableName table, String constraint_name) {
        SimpleTableQuery dtcols;
        SimpleTableQuery dt;
        block4: {
            MutableTableDataSource t = this.getTable(TableDataConglomerate.FOREIGN_INFO_TABLE);
            MutableTableDataSource t2 = this.getTable(TableDataConglomerate.FOREIGN_COLS_TABLE);
            dt = new SimpleTableQuery(t);
            dtcols = new SimpleTableQuery(t2);
            try {
                IntegerVector data = dt.selectIndexesEqual(1, constraint_name, 2, table.getSchema());
                if (data.size() > 1) {
                    throw new Error("Assertion failed: multiple foreign key constraint name: " + constraint_name);
                }
                if (data.size() != 1) break block4;
                int row_index = data.intAt(0);
                TObject id = dt.get(0, row_index);
                IntegerVector ivec = dtcols.selectIndexesEqual(0, id);
                dtcols.deleteRows(ivec);
                dt.deleteRows(data);
                boolean bl = true;
                Object var13_13 = null;
                dtcols.dispose();
                dt.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                dtcols.dispose();
                dt.dispose();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var13_14 = null;
        dtcols.dispose();
        dt.dispose();
        return bl;
    }

    public static TableName[] queryTablesRelationallyLinkedTo(SimpleTransaction transaction, TableName table) {
        TableName tname;
        int i;
        ArrayList<TableName> list = new ArrayList<TableName>();
        ColumnGroupReference[] refs = Transaction.queryTableForeignKeyReferences(transaction, table);
        for (i = 0; i < refs.length; ++i) {
            tname = refs[i].ref_table_name;
            if (list.contains(tname)) continue;
            list.add(tname);
        }
        refs = Transaction.queryTableImportedForeignKeyReferences(transaction, table);
        for (i = 0; i < refs.length; ++i) {
            tname = refs[i].key_table_name;
            if (list.contains(tname)) continue;
            list.add(tname);
        }
        return list.toArray(new TableName[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnGroup[] queryTableUniqueGroups(SimpleTransaction transaction, TableName table_name) {
        ColumnGroup[] groups;
        TableDataSource t = transaction.getTableDataSource(TableDataConglomerate.UNIQUE_INFO_TABLE);
        TableDataSource t2 = transaction.getTableDataSource(TableDataConglomerate.UNIQUE_COLS_TABLE);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        SimpleTableQuery dtcols = new SimpleTableQuery(t2);
        try {
            IntegerVector data = dt.selectIndexesEqual(3, table_name.getName(), 2, table_name.getSchema());
            groups = new ColumnGroup[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                TObject id = dt.get(0, data.intAt(i));
                IntegerVector cols = dtcols.selectIndexesEqual(0, id);
                ColumnGroup group = new ColumnGroup();
                group.name = dt.get(1, data.intAt(i)).getObject().toString();
                group.columns = Transaction.toColumns(dtcols, cols);
                group.deferred = ((BigNumber)dt.get(4, data.intAt(i)).getObject()).shortValue();
                groups[i] = group;
            }
            Object var13_12 = null;
            dt.dispose();
            dtcols.dispose();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            dt.dispose();
            dtcols.dispose();
            throw throwable;
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnGroup queryTablePrimaryKeyGroup(SimpleTransaction transaction, TableName table_name) {
        SimpleTableQuery dtcols;
        SimpleTableQuery dt;
        block4: {
            TableDataSource t = transaction.getTableDataSource(TableDataConglomerate.PRIMARY_INFO_TABLE);
            TableDataSource t2 = transaction.getTableDataSource(TableDataConglomerate.PRIMARY_COLS_TABLE);
            dt = new SimpleTableQuery(t);
            dtcols = new SimpleTableQuery(t2);
            try {
                IntegerVector data = dt.selectIndexesEqual(3, table_name.getName(), 2, table_name.getSchema());
                if (data.size() > 1) {
                    throw new Error("Assertion failed: multiple primary key for: " + table_name);
                }
                if (data.size() != 1) break block4;
                int row_index = data.intAt(0);
                TObject id = dt.get(0, row_index);
                IntegerVector ivec = dtcols.selectIndexesEqual(0, id);
                ColumnGroup group = new ColumnGroup();
                group.name = dt.get(1, row_index).getObject().toString();
                group.columns = Transaction.toColumns(dtcols, ivec);
                group.deferred = ((BigNumber)dt.get(4, row_index).getObject()).shortValue();
                ColumnGroup columnGroup = group;
                Object var13_13 = null;
                dt.dispose();
                dtcols.dispose();
                return columnGroup;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                dt.dispose();
                dtcols.dispose();
                throw throwable;
            }
        }
        ColumnGroup columnGroup = null;
        Object var13_14 = null;
        dt.dispose();
        dtcols.dispose();
        return columnGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckExpression[] queryTableCheckExpressions(SimpleTransaction transaction, TableName table_name) {
        CheckExpression[] checks;
        TableDataSource t = transaction.getTableDataSource(TableDataConglomerate.CHECK_INFO_TABLE);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        try {
            IntegerVector data = dt.selectIndexesEqual(3, table_name.getName(), 2, table_name.getSchema());
            checks = new CheckExpression[data.size()];
            for (int i = 0; i < checks.length; ++i) {
                ByteLongObject sexp;
                int row_index = data.intAt(i);
                CheckExpression check = new CheckExpression();
                check.name = dt.get(1, row_index).getObject().toString();
                check.deferred = ((BigNumber)dt.get(5, row_index).getObject()).shortValue();
                if (t.getDataTableDef().columnCount() > 6 && (sexp = (ByteLongObject)dt.get(6, row_index).getObject()) != null) {
                    try {
                        check.expression = (Expression)ObjectTranslator.deserialize(sexp);
                    }
                    catch (Throwable e) {
                        transaction.Debug().write(20, class$com$mckoi$database$Transaction == null ? Transaction.class$("com.mckoi.database.Transaction") : class$com$mckoi$database$Transaction, "Unable to deserialize the check expression.  The error is: " + e.getMessage());
                        transaction.Debug().write(20, class$com$mckoi$database$Transaction == null ? Transaction.class$("com.mckoi.database.Transaction") : class$com$mckoi$database$Transaction, "Parsing the check expression instead.");
                        check.expression = null;
                    }
                }
                if (check.expression == null) {
                    Expression exp;
                    check.expression = exp = Expression.parse(dt.get(4, row_index).getObject().toString());
                }
                checks[i] = check;
            }
            Object var12_11 = null;
            dt.dispose();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            dt.dispose();
            throw throwable;
        }
        return checks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnGroupReference[] queryTableForeignKeyReferences(SimpleTransaction transaction, TableName table_name) {
        ColumnGroupReference[] groups;
        TableDataSource t = transaction.getTableDataSource(TableDataConglomerate.FOREIGN_INFO_TABLE);
        TableDataSource t2 = transaction.getTableDataSource(TableDataConglomerate.FOREIGN_COLS_TABLE);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        SimpleTableQuery dtcols = new SimpleTableQuery(t2);
        try {
            IntegerVector data = dt.selectIndexesEqual(3, table_name.getName(), 2, table_name.getSchema());
            groups = new ColumnGroupReference[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                int row_index = data.intAt(i);
                TObject id = dt.get(0, row_index);
                TableName ref_table_name = new TableName(dt.get(4, row_index).getObject().toString(), dt.get(5, row_index).getObject().toString());
                IntegerVector cols = dtcols.selectIndexesEqual(0, id);
                ColumnGroupReference group = new ColumnGroupReference();
                group.name = dt.get(1, row_index).getObject().toString();
                group.key_table_name = table_name;
                group.ref_table_name = ref_table_name;
                group.update_rule = dt.get(6, row_index).getObject().toString();
                group.delete_rule = dt.get(7, row_index).getObject().toString();
                group.deferred = ((BigNumber)dt.get(8, row_index).getObject()).shortValue();
                int cols_size = cols.size();
                String[] key_cols = new String[cols_size];
                String[] ref_cols = new String[cols_size];
                block3: for (int n = 0; n < cols_size; ++n) {
                    for (int p = 0; p < cols_size; ++p) {
                        int cols_index = cols.intAt(p);
                        if (((BigNumber)dtcols.get(3, cols_index).getObject()).intValue() != n) continue;
                        key_cols[n] = dtcols.get(1, cols_index).getObject().toString();
                        ref_cols[n] = dtcols.get(2, cols_index).getObject().toString();
                        continue block3;
                    }
                }
                group.key_columns = key_cols;
                group.ref_columns = ref_cols;
                groups[i] = group;
            }
            Object var21_20 = null;
            dt.dispose();
            dtcols.dispose();
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            dt.dispose();
            dtcols.dispose();
            throw throwable;
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnGroupReference[] queryTableImportedForeignKeyReferences(SimpleTransaction transaction, TableName ref_table_name) {
        ColumnGroupReference[] groups;
        TableDataSource t = transaction.getTableDataSource(TableDataConglomerate.FOREIGN_INFO_TABLE);
        TableDataSource t2 = transaction.getTableDataSource(TableDataConglomerate.FOREIGN_COLS_TABLE);
        SimpleTableQuery dt = new SimpleTableQuery(t);
        SimpleTableQuery dtcols = new SimpleTableQuery(t2);
        try {
            IntegerVector data = dt.selectIndexesEqual(5, ref_table_name.getName(), 4, ref_table_name.getSchema());
            groups = new ColumnGroupReference[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                int row_index = data.intAt(i);
                TObject id = dt.get(0, row_index);
                TableName table_name = new TableName(dt.get(2, row_index).getObject().toString(), dt.get(3, row_index).getObject().toString());
                IntegerVector cols = dtcols.selectIndexesEqual(0, id);
                ColumnGroupReference group = new ColumnGroupReference();
                group.name = dt.get(1, row_index).getObject().toString();
                group.key_table_name = table_name;
                group.ref_table_name = ref_table_name;
                group.update_rule = dt.get(6, row_index).getObject().toString();
                group.delete_rule = dt.get(7, row_index).getObject().toString();
                group.deferred = ((BigNumber)dt.get(8, row_index).getObject()).shortValue();
                int cols_size = cols.size();
                String[] key_cols = new String[cols_size];
                String[] ref_cols = new String[cols_size];
                block3: for (int n = 0; n < cols_size; ++n) {
                    for (int p = 0; p < cols_size; ++p) {
                        int cols_index = cols.intAt(p);
                        if (((BigNumber)dtcols.get(3, cols_index).getObject()).intValue() != n) continue;
                        key_cols[n] = dtcols.get(1, cols_index).getObject().toString();
                        ref_cols[n] = dtcols.get(2, cols_index).getObject().toString();
                        continue block3;
                    }
                }
                group.key_columns = key_cols;
                group.ref_columns = ref_cols;
                groups[i] = group;
            }
            Object var21_20 = null;
            dt.dispose();
            dtcols.dispose();
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            dt.dispose();
            dtcols.dispose();
            throw throwable;
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndCommit() throws TransactionException {
        if (!this.closed) {
            try {
                this.closed = true;
                this.conglomerate.processCommit(this, this.getVisibleTables(), this.selected_from_tables, this.touched_tables, this.journal);
                Object var2_1 = null;
                this.cleanup();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.cleanup();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndRollback() {
        if (!this.closed) {
            try {
                this.closed = true;
                this.conglomerate.processRollback(this, this.touched_tables, this.journal);
                Object var2_1 = null;
                this.cleanup();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.cleanup();
                throw throwable;
            }
        }
    }

    private void cleanup() {
        this.getSystem().stats().decrement("Transaction.count");
        this.disposeAllIndices();
        try {
            for (int i = 0; i < this.touched_tables.size(); ++i) {
                MutableTableDataSource source = (MutableTableDataSource)this.touched_tables.get(i);
                source.dispose();
            }
        }
        catch (Throwable e) {
            this.Debug().writeException(e);
        }
        this.getSystem().stats().increment("Transaction.cleanup");
        this.conglomerate = null;
        this.touched_tables = null;
        this.journal = null;
    }

    void dispose() {
        if (!this.isReadOnly()) {
            throw new RuntimeException("Assertion failed - tried to dispose a non read-only transaction.");
        }
        if (!this.closed) {
            this.closed = true;
            this.cleanup();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.Debug().write(40, this, "Transaction not closed!");
            this.closeAndRollback();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Transaction.INTERNAL_DEF_LIST[0] = GTTableColumnsDataSource.DEF_DATA_TABLE_DEF;
        Transaction.INTERNAL_DEF_LIST[1] = GTTableInfoDataSource.DEF_DATA_TABLE_DEF;
        Transaction.INTERNAL_DEF_LIST[2] = GTProductDataSource.DEF_DATA_TABLE_DEF;
    }

    public static class ColumnGroupReference {
        public String name;
        public TableName key_table_name;
        public String[] key_columns;
        public TableName ref_table_name;
        public String[] ref_columns;
        public String update_rule;
        public String delete_rule;
        public short deferred;
    }

    public static class CheckExpression {
        public String name;
        public Expression expression;
        public short deferred;
    }

    public static class ColumnGroup {
        public String name;
        public String[] columns;
        public short deferred;
    }

    private class TransactionInternalTables
    extends AbstractInternalTableInfo {
        public TransactionInternalTables() {
            super("SYSTEM TABLE", INTERNAL_DEF_LIST);
        }

        public MutableTableDataSource createInternalTable(int index) {
            if (index == 0) {
                return new GTTableColumnsDataSource(Transaction.this).init();
            }
            if (index == 1) {
                return new GTTableInfoDataSource(Transaction.this).init();
            }
            if (index == 2) {
                return new GTProductDataSource(Transaction.this).init();
            }
            throw new RuntimeException();
        }
    }
}

