/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import java.io.Serializable;

public final class TableName
implements Comparable,
Serializable {
    static final long serialVersionUID = 6527135256976754916L;
    private static final String UNKNOWN_SCHEMA_NAME = "##UNKNOWN_SCHEMA##";
    private final String schema_name;
    private final String table_name;

    public TableName(String schema_name, String table_name) {
        if (table_name == null) {
            throw new NullPointerException("'name' can not be null.");
        }
        if (schema_name == null) {
            schema_name = UNKNOWN_SCHEMA_NAME;
        }
        this.schema_name = schema_name;
        this.table_name = table_name;
    }

    public TableName(String table_name) {
        this(UNKNOWN_SCHEMA_NAME, table_name);
    }

    public String getSchema() {
        if (this.schema_name.equals(UNKNOWN_SCHEMA_NAME)) {
            return null;
        }
        return this.schema_name;
    }

    public String getName() {
        return this.table_name;
    }

    public TableName resolveSchema(String scheman) {
        if (this.schema_name.equals(UNKNOWN_SCHEMA_NAME)) {
            return new TableName(scheman, this.getName());
        }
        return this;
    }

    public static TableName resolve(String schemav, String namev) {
        int i = namev.indexOf(46);
        if (i == -1) {
            return new TableName(schemav, namev);
        }
        return new TableName(namev.substring(0, i), namev.substring(i + 1));
    }

    public static TableName resolve(String namev) {
        return TableName.resolve(UNKNOWN_SCHEMA_NAME, namev);
    }

    public String toString() {
        if (this.getSchema() != null) {
            return this.getSchema() + "." + this.getName();
        }
        return this.getName();
    }

    public boolean equals(Object ob) {
        TableName tn = (TableName)ob;
        return tn.schema_name.equals(this.schema_name) && tn.table_name.equals(this.table_name);
    }

    public boolean equalsIgnoreCase(TableName tn) {
        return tn.schema_name.equalsIgnoreCase(this.schema_name) && tn.table_name.equalsIgnoreCase(this.table_name);
    }

    public int compareTo(Object ob) {
        TableName tn = (TableName)ob;
        int v = this.schema_name.compareTo(tn.schema_name);
        if (v == 0) {
            return this.table_name.compareTo(tn.table_name);
        }
        return v;
    }

    public int hashCode() {
        return this.schema_name.hashCode() + this.table_name.hashCode();
    }
}

