/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.RowData;
import com.mckoi.database.TableName;

public class TableModificationEvent {
    public static final int BEFORE = 16;
    public static final int AFTER = 32;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 4;
    public static final int BEFORE_INSERT = 17;
    public static final int AFTER_INSERT = 33;
    public static final int BEFORE_UPDATE = 18;
    public static final int AFTER_UPDATE = 34;
    public static final int BEFORE_DELETE = 20;
    public static final int AFTER_DELETE = 36;
    private DatabaseConnection connection;
    private TableName table_name;
    private int event_type;
    private RowData row_data;
    private int row_index = -1;

    private TableModificationEvent(DatabaseConnection connection, TableName table_name, int row_index, RowData row_data, int type, boolean before) {
        this.connection = connection;
        this.table_name = table_name;
        this.row_index = row_index;
        this.row_data = row_data;
        this.event_type = type | (before ? 16 : 32);
    }

    TableModificationEvent(DatabaseConnection connection, TableName table_name, RowData row_data, boolean before) {
        this(connection, table_name, -1, row_data, 1, before);
    }

    TableModificationEvent(DatabaseConnection connection, TableName table_name, int row_index, RowData row_data, boolean before) {
        this(connection, table_name, row_index, row_data, 2, before);
    }

    TableModificationEvent(DatabaseConnection connection, TableName table_name, int row_index, boolean before) {
        this(connection, table_name, row_index, null, 4, before);
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    public int getType() {
        return this.event_type;
    }

    public boolean isBefore() {
        return (this.event_type & 0x10) != 0;
    }

    public boolean isAfter() {
        return (this.event_type & 0x20) != 0;
    }

    public boolean isInsert() {
        return (this.event_type & 1) != 0;
    }

    public boolean isUpdate() {
        return (this.event_type & 2) != 0;
    }

    public boolean isDelete() {
        return (this.event_type & 4) != 0;
    }

    public TableName getTableName() {
        return this.table_name;
    }

    public int getRowIndex() {
        return this.row_index;
    }

    public RowData getRowData() {
        return this.row_data;
    }

    public boolean listenedBy(int listen_t) {
        boolean ba_match = (this.event_type & 0x10) != 0 && (listen_t & 0x10) != 0 || (this.event_type & 0x20) != 0 && (listen_t & 0x20) != 0;
        boolean trig_match = (this.event_type & 1) != 0 && (listen_t & 1) != 0 || (this.event_type & 4) != 0 && (listen_t & 4) != 0 || (this.event_type & 2) != 0 && (listen_t & 2) != 0;
        return ba_match && trig_match;
    }
}

