/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.INHelper;
import com.mckoi.database.Operator;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.Variable;
import com.mckoi.database.VirtualTable;
import com.mckoi.util.IntegerVector;

public class TableFunctions {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Table anyAllNonCorrelated(Table left_table, Variable[] left_vars, Operator op, Table right_table) {
        TObject[] lowest_cells;
        IntegerVector select_vec;
        TObject[] highest_cells;
        if (right_table.getColumnCount() != left_vars.length) {
            throw new RuntimeException("Input table <> " + left_vars.length + " columns.");
        }
        if (left_table.getRowCount() == 0) {
            return left_table;
        }
        int sz = left_vars.length;
        int[] left_col_map = new int[sz];
        int[] right_col_map = new int[sz];
        for (int i = 0; i < sz; ++i) {
            left_col_map[i] = left_table.findFieldName(left_vars[i]);
            right_col_map[i] = i;
            if (left_col_map[i] == -1) {
                throw new RuntimeException("Invalid reference: " + left_vars[i]);
            }
            DataTableColumnDef left_type = left_table.getColumnDefAt(left_col_map[i]);
            DataTableColumnDef right_type = right_table.getColumnDefAt(i);
            if (left_type.getTType().comparableTypes(right_type.getTType())) continue;
            throw new Error("The type of the sub-query expression " + left_vars[i] + "(" + left_type.getSQLTypeString() + ") is incompatible with " + "the sub-query type " + right_type.getSQLTypeString() + ".");
        }
        if (op.isSubQueryForm(2)) {
            if (op.is(">") || op.is(">=")) {
                highest_cells = right_table.getLastCellContent(right_col_map);
                select_vec = left_table.selectRows(left_col_map, op, highest_cells);
            } else if (op.is("<") || op.is("<=")) {
                lowest_cells = right_table.getFirstCellContent(right_col_map);
                select_vec = left_table.selectRows(left_col_map, op, lowest_cells);
            } else if (op.is("=")) {
                TObject[] single_cell = right_table.getSingleCellContent(right_col_map);
                if (single_cell == null) return left_table.emptySelect();
                select_vec = left_table.selectRows(left_col_map, op, single_cell);
            } else {
                if (!op.is("<>")) throw new RuntimeException("Don't understand operator '" + op + "' in ALL.");
                select_vec = INHelper.notIn(left_table, right_table, left_col_map, right_col_map);
            }
        } else {
            if (!op.isSubQueryForm(1)) throw new RuntimeException("Unrecognised sub-query operator.");
            if (op.is(">") || op.is(">=")) {
                lowest_cells = right_table.getFirstCellContent(right_col_map);
                select_vec = left_table.selectRows(left_col_map, op, lowest_cells);
            } else if (op.is("<") || op.is("<=")) {
                highest_cells = right_table.getLastCellContent(right_col_map);
                select_vec = left_table.selectRows(left_col_map, op, highest_cells);
            } else if (op.is("=")) {
                select_vec = INHelper.in(left_table, right_table, left_col_map, right_col_map);
            } else {
                if (!op.is("<>")) throw new RuntimeException("Don't understand operator '" + op + "' in ANY.");
                TObject[] cells = right_table.getSingleCellContent(right_col_map);
                if (cells == null) return left_table;
                select_vec = left_table.selectRows(left_col_map, op, cells);
            }
        }
        VirtualTable rtable = new VirtualTable(left_table);
        rtable.set(left_table, select_vec);
        return rtable;
    }
}

