/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.TArrayType;
import com.mckoi.database.TBinaryType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TDateType;
import com.mckoi.database.TJavaObjectType;
import com.mckoi.database.TNullType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TQueryPlanType;
import com.mckoi.database.TStringType;
import com.mckoi.database.global.CastHelper;
import com.mckoi.util.StringUtil;
import java.io.Serializable;
import java.util.List;

public abstract class TType
implements Serializable {
    static final long serialVersionUID = 5866230818579853961L;
    private int sql_type;
    public static final TBooleanType BOOLEAN_TYPE = new TBooleanType(-7);
    public static final TStringType STRING_TYPE = new TStringType(12, -1, null);
    public static final TNumericType NUMERIC_TYPE = new TNumericType(2, -1, -1);
    public static final TDateType DATE_TYPE = new TDateType(93);
    public static final TBinaryType BINARY_TYPE = new TBinaryType(2004, -1);
    public static final TNullType NULL_TYPE = new TNullType();
    public static final TQueryPlanType QUERY_PLAN_TYPE = new TQueryPlanType();
    public static final TArrayType ARRAY_TYPE = new TArrayType();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$mckoi$util$BigNumber;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$mckoi$database$global$ByteLongObject;

    protected TType(int sql_type) {
        this.sql_type = sql_type;
    }

    public int getSQLType() {
        return this.sql_type;
    }

    public String asSQLString() {
        return DataTableColumnDef.sqlTypeToString(this.getSQLType());
    }

    public abstract boolean comparableTypes(TType var1);

    public abstract int compareObs(Object var1, Object var2);

    public abstract int calculateApproximateMemoryUse(Object var1);

    public abstract Class javaClass();

    private static String parseQuotedString(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        throw new RuntimeException("String is not quoted: " + str);
    }

    public static String asEncodedString(TType type) {
        StringBuffer buf = new StringBuffer();
        if (type instanceof TBooleanType) {
            buf.append("BOOLEAN(");
            buf.append(type.getSQLType());
            buf.append(')');
        } else if (type instanceof TStringType) {
            TStringType str_type = (TStringType)type;
            buf.append("STRING(");
            buf.append(type.getSQLType());
            buf.append(',');
            buf.append(str_type.getMaximumSize());
            buf.append(",'");
            buf.append(str_type.getLocaleString());
            buf.append("',");
            buf.append(str_type.getStrength());
            buf.append(',');
            buf.append(str_type.getDecomposition());
            buf.append(')');
        } else if (type instanceof TNumericType) {
            TNumericType num_type = (TNumericType)type;
            buf.append("NUMERIC(");
            buf.append(type.getSQLType());
            buf.append(',');
            buf.append(num_type.getSize());
            buf.append(',');
            buf.append(num_type.getScale());
            buf.append(')');
        } else if (type instanceof TBinaryType) {
            TBinaryType bin_type = (TBinaryType)type;
            buf.append("BINARY(");
            buf.append(type.getSQLType());
            buf.append(',');
            buf.append(bin_type.getMaximumSize());
            buf.append(')');
        } else if (type instanceof TDateType) {
            buf.append("DATE(");
            buf.append(type.getSQLType());
            buf.append(')');
        } else if (type instanceof TNullType) {
            buf.append("NULL(");
            buf.append(type.getSQLType());
            buf.append(')');
        } else if (type instanceof TJavaObjectType) {
            buf.append("JAVAOBJECT(");
            buf.append(type.getSQLType());
            buf.append(",'");
            buf.append(((TJavaObjectType)type).getJavaClassTypeString());
            buf.append("')");
        } else {
            throw new RuntimeException("Can not encode type: " + type);
        }
        return new String(buf);
    }

    public static String asEncodedString(TType[] types) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            buf.append(TType.asEncodedString(types[i]));
            if (i >= types.length - 1) continue;
            buf.append("!|");
        }
        return new String(buf);
    }

    public static TType decodeString(String encoded_str) {
        int param_s = encoded_str.indexOf(40);
        int param_e = encoded_str.lastIndexOf(41);
        String params = encoded_str.substring(param_s + 1, param_e);
        List param_list = StringUtil.explode(params, ",");
        int sql_type = Integer.parseInt((String)param_list.get(0));
        if (encoded_str.startsWith("BOOLEAN(")) {
            return new TBooleanType(sql_type);
        }
        if (encoded_str.startsWith("STRING(")) {
            int size = Integer.parseInt((String)param_list.get(1));
            String locale_str = TType.parseQuotedString((String)param_list.get(2));
            if (locale_str.length() == 0) {
                locale_str = null;
            }
            int strength = Integer.parseInt((String)param_list.get(3));
            int decomposition = Integer.parseInt((String)param_list.get(4));
            return new TStringType(sql_type, size, locale_str, strength, decomposition);
        }
        if (encoded_str.startsWith("NUMERIC(")) {
            int size = Integer.parseInt((String)param_list.get(1));
            int scale = Integer.parseInt((String)param_list.get(2));
            return new TNumericType(sql_type, size, scale);
        }
        if (encoded_str.startsWith("BINARY(")) {
            int size = Integer.parseInt((String)param_list.get(1));
            return new TBinaryType(sql_type, size);
        }
        if (encoded_str.startsWith("DATE(")) {
            return new TDateType(sql_type);
        }
        if (encoded_str.startsWith("NULL(")) {
            return new TNullType();
        }
        if (encoded_str.startsWith("JAVAOBJECT(")) {
            String class_str = TType.parseQuotedString((String)param_list.get(1));
            return new TJavaObjectType(class_str);
        }
        throw new RuntimeException("Can not parse encoded string: " + encoded_str);
    }

    public static TType[] decodeTypes(String encoded_str) {
        List items = StringUtil.explode(encoded_str, "!|");
        if (items.size() == 1 && items.get(0).equals("")) {
            return new TType[0];
        }
        int sz = items.size();
        TType[] return_types = new TType[sz];
        for (int i = 0; i < sz; ++i) {
            String str = (String)items.get(i);
            return_types[i] = TType.decodeString(str);
        }
        return return_types;
    }

    public static TType javaObjectType(String class_name) {
        return new TJavaObjectType(class_name);
    }

    public static TType stringType(int sql_type, int size, String locale, int strength, int decomposition) {
        return new TStringType(sql_type, size, locale, strength, decomposition);
    }

    public static TType numericType(int sql_type, int size, int scale) {
        return new TNumericType(sql_type, size, scale);
    }

    public static TType booleanType(int sql_type) {
        return new TBooleanType(sql_type);
    }

    public static TType dateType(int sql_type) {
        return new TDateType(sql_type);
    }

    public static TType binaryType(int sql_type, int size) {
        return new TBinaryType(sql_type, size);
    }

    public static Object castObjectToTType(Object ob, TType type) {
        if (ob == null) {
            return null;
        }
        int size = -1;
        int scale = -1;
        int sql_type = type.getSQLType();
        if (type instanceof TStringType) {
            size = ((TStringType)type).getMaximumSize();
        } else if (type instanceof TNumericType) {
            TNumericType num_type = (TNumericType)type;
            size = num_type.getSize();
            scale = num_type.getScale();
        } else if (type instanceof TBinaryType) {
            size = ((TBinaryType)type).getMaximumSize();
        }
        ob = CastHelper.castObjectToSQLType(ob, type.getSQLType(), size, scale, DataTableColumnDef.sqlTypeToString(sql_type));
        return ob;
    }

    public static TType fromClass(Class c) {
        if (c == (class$java$lang$String == null ? (class$java$lang$String = TType.class$("java.lang.String")) : class$java$lang$String)) {
            return STRING_TYPE;
        }
        if (c == (class$com$mckoi$util$BigNumber == null ? (class$com$mckoi$util$BigNumber = TType.class$("com.mckoi.util.BigNumber")) : class$com$mckoi$util$BigNumber)) {
            return NUMERIC_TYPE;
        }
        if (c == (class$java$util$Date == null ? (class$java$util$Date = TType.class$("java.util.Date")) : class$java$util$Date)) {
            return DATE_TYPE;
        }
        if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TType.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return BOOLEAN_TYPE;
        }
        if (c == (class$com$mckoi$database$global$ByteLongObject == null ? (class$com$mckoi$database$global$ByteLongObject = TType.class$("com.mckoi.database.global.ByteLongObject")) : class$com$mckoi$database$global$ByteLongObject)) {
            return BINARY_TYPE;
        }
        throw new Error("Don't know how to convert " + c + " to a TType.");
    }

    public static TType getWidestType(TType t1, TType t2) {
        int t1SQLType = t1.getSQLType();
        int t2SQLType = t2.getSQLType();
        if (t1SQLType == 3) {
            return t1;
        }
        if (t2SQLType == 3) {
            return t2;
        }
        if (t1SQLType == 2) {
            return t1;
        }
        if (t2SQLType == 2) {
            return t2;
        }
        if (t1SQLType == -7) {
            return t2;
        }
        if (t2SQLType == -7) {
            return t1;
        }
        int t1IntSize = TType.getIntSize(t1SQLType);
        int t2IntSize = TType.getIntSize(t2SQLType);
        if (t1IntSize > 0 && t2IntSize > 0) {
            return t1IntSize > t2IntSize ? t1 : t2;
        }
        int t1FloatSize = TType.getFloatSize(t1SQLType);
        int t2FloatSize = TType.getFloatSize(t2SQLType);
        if (t1FloatSize > 0 && t2FloatSize > 0) {
            return t1FloatSize > t2FloatSize ? t1 : t2;
        }
        if (t1FloatSize > t2IntSize) {
            return t1;
        }
        if (t2FloatSize > t1IntSize) {
            return t2;
        }
        if (t1IntSize >= t2FloatSize || t2IntSize >= t1FloatSize) {
            return new TNumericType(8, 8, -1);
        }
        throw new Error("Widest type error.");
    }

    private static int getIntSize(int sqlType) {
        switch (sqlType) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
        }
        return 0;
    }

    private static int getFloatSize(int sqlType) {
        switch (sqlType) {
            default: {
                return 0;
            }
            case 7: {
                return 4;
            }
            case 6: 
            case 8: 
        }
        return 8;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

