/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TBooleanType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.global.BlobRef;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ClobRef;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public final class TObject
implements Serializable {
    static final long serialVersionUID = -5129157457207765079L;
    private TType type;
    private Object ob;
    public static final TObject BOOLEAN_TRUE = new TObject(TType.BOOLEAN_TYPE, Boolean.TRUE);
    public static final TObject BOOLEAN_FALSE = new TObject(TType.BOOLEAN_TYPE, Boolean.FALSE);
    public static final TObject BOOLEAN_NULL = new TObject(TType.BOOLEAN_TYPE, null);
    public static final TObject NULL_OBJECT = new TObject(TType.NULL_TYPE, null);

    public TObject(TType type, Object ob) {
        this.type = type;
        this.ob = ob instanceof String ? StringObject.fromString((String)ob) : ob;
    }

    public TType getTType() {
        return this.type;
    }

    public boolean isNull() {
        return this.getObject() == null;
    }

    public Object getObject() {
        return this.ob;
    }

    public int approximateMemoryUse() {
        return this.getTType().calculateApproximateMemoryUse(this.getObject());
    }

    public boolean comparableTypes(TObject ob) {
        return this.getTType().comparableTypes(ob.getTType());
    }

    public BigNumber toBigNumber() {
        if (this.getTType() instanceof TNumericType) {
            return (BigNumber)this.getObject();
        }
        return null;
    }

    public Boolean toBoolean() {
        if (this.getTType() instanceof TBooleanType) {
            return (Boolean)this.getObject();
        }
        return null;
    }

    public String toStringValue() {
        if (this.getTType() instanceof TStringType) {
            return this.getObject().toString();
        }
        return null;
    }

    public static TObject booleanVal(boolean b) {
        if (b) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static TObject intVal(int val) {
        return TObject.bigNumberVal(BigNumber.fromLong(val));
    }

    public static TObject longVal(long val) {
        return TObject.bigNumberVal(BigNumber.fromLong(val));
    }

    public static TObject doubleVal(double val) {
        return TObject.bigNumberVal(BigNumber.fromDouble(val));
    }

    public static TObject bigNumberVal(BigNumber val) {
        return new TObject(TType.NUMERIC_TYPE, val);
    }

    public static TObject stringVal(StringObject str) {
        return new TObject(TType.STRING_TYPE, str);
    }

    public static TObject stringVal(String str) {
        return new TObject(TType.STRING_TYPE, StringObject.fromString(str));
    }

    public static TObject dateVal(Date d) {
        return new TObject(TType.DATE_TYPE, d);
    }

    public static TObject nullVal() {
        return NULL_OBJECT;
    }

    public static TObject objectVal(Object ob) {
        if (ob == null) {
            return TObject.nullVal();
        }
        if (ob instanceof BigNumber) {
            return TObject.bigNumberVal((BigNumber)ob);
        }
        if (ob instanceof StringObject) {
            return TObject.stringVal((StringObject)ob);
        }
        if (ob instanceof Boolean) {
            return TObject.booleanVal((Boolean)ob);
        }
        if (ob instanceof Date) {
            return TObject.dateVal((Date)ob);
        }
        if (ob instanceof ByteLongObject) {
            return new TObject(TType.BINARY_TYPE, (ByteLongObject)ob);
        }
        if (ob instanceof byte[]) {
            return new TObject(TType.BINARY_TYPE, new ByteLongObject((byte[])ob));
        }
        if (ob instanceof BlobRef) {
            return new TObject(TType.BINARY_TYPE, (BlobRef)ob);
        }
        if (ob instanceof ClobRef) {
            return new TObject(TType.STRING_TYPE, (ClobRef)ob);
        }
        throw new Error("Don't know how to convert object type " + ob.getClass());
    }

    public int compareToNoNulls(TObject tob) {
        TStringType stype;
        TType type = this.getTType();
        if (type instanceof TStringType && (stype = (TStringType)type).getLocale() == null) {
            type = tob.getTType();
        }
        return type.compareObs(this.getObject(), tob.getObject());
    }

    public int compareTo(TObject tob) {
        if (this.isNull()) {
            if (tob.isNull()) {
                return 0;
            }
            return -1;
        }
        if (tob.isNull()) {
            return 1;
        }
        return this.compareToNoNulls(tob);
    }

    public boolean equals(Object ob) {
        throw new Error("equals method should not be used.");
    }

    public boolean valuesEqual(TObject ob) {
        if (this == ob) {
            return true;
        }
        if (this.getTType().comparableTypes(ob.getTType())) {
            return this.compareTo(ob) == 0;
        }
        return false;
    }

    public TObject operatorOr(TObject val) {
        BigNumber v1 = this.toBigNumber();
        BigNumber v2 = val.toBigNumber();
        TType result_type = TType.getWidestType(this.getTType(), val.getTType());
        if (v1 == null || v2 == null) {
            return new TObject(result_type, null);
        }
        return new TObject(result_type, v1.bitWiseOr(v2));
    }

    public TObject operatorAdd(TObject val) {
        BigNumber v1 = this.toBigNumber();
        BigNumber v2 = val.toBigNumber();
        TType result_type = TType.getWidestType(this.getTType(), val.getTType());
        if (v1 == null || v2 == null) {
            return new TObject(result_type, null);
        }
        return new TObject(result_type, v1.add(v2));
    }

    public TObject operatorSubtract(TObject val) {
        BigNumber v1 = this.toBigNumber();
        BigNumber v2 = val.toBigNumber();
        TType result_type = TType.getWidestType(this.getTType(), val.getTType());
        if (v1 == null || v2 == null) {
            return new TObject(result_type, null);
        }
        return new TObject(result_type, v1.subtract(v2));
    }

    public TObject operatorMultiply(TObject val) {
        BigNumber v1 = this.toBigNumber();
        BigNumber v2 = val.toBigNumber();
        TType result_type = TType.getWidestType(this.getTType(), val.getTType());
        if (v1 == null || v2 == null) {
            return new TObject(result_type, null);
        }
        return new TObject(result_type, v1.multiply(v2));
    }

    public TObject operatorDivide(TObject val) {
        BigNumber v1 = this.toBigNumber();
        BigNumber v2 = val.toBigNumber();
        TType result_type = TType.getWidestType(this.getTType(), val.getTType());
        if (v1 == null || v2 == null) {
            return new TObject(result_type, null);
        }
        return new TObject(result_type, v1.divide(v2));
    }

    public TObject operatorConcat(TObject val) {
        if (this.isNull()) {
            return this;
        }
        if (val.isNull()) {
            return val;
        }
        TType tt1 = this.getTType();
        TType tt2 = val.getTType();
        if (tt1 instanceof TStringType && tt2 instanceof TStringType) {
            TStringType st1 = (TStringType)tt1;
            TStringType st2 = (TStringType)tt2;
            Locale str_locale = null;
            int str_strength = 0;
            int str_decomposition = 0;
            if (st1.getLocale() != null) {
                str_locale = st1.getLocale();
                str_strength = st1.getStrength();
                str_decomposition = st1.getDecomposition();
            } else if (st2.getLocale() != null) {
                str_locale = st2.getLocale();
                str_strength = st2.getStrength();
                str_decomposition = st2.getDecomposition();
            }
            TStringType dest_type = st1;
            if (str_locale != null) {
                dest_type = new TStringType(12, -1, str_locale, str_strength, str_decomposition);
            }
            return new TObject(dest_type, StringObject.fromString(this.toStringValue() + val.toStringValue()));
        }
        return new TObject(tt1, null);
    }

    public TObject operatorIs(TObject val) {
        if (this.isNull() && val.isNull()) {
            return BOOLEAN_TRUE;
        }
        if (this.comparableTypes(val)) {
            return TObject.booleanVal(this.compareTo(val) == 0);
        }
        return BOOLEAN_FALSE;
    }

    public TObject operatorEquals(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) == 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorNotEquals(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) != 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorGreater(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) > 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorGreaterEquals(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) >= 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorLess(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) < 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorLessEquals(TObject val) {
        if (this.comparableTypes(val) && !this.isNull() && !val.isNull()) {
            return TObject.booleanVal(this.compareToNoNulls(val) <= 0);
        }
        return BOOLEAN_NULL;
    }

    public TObject operatorNot() {
        if (this.isNull()) {
            return this;
        }
        Boolean b = this.toBoolean();
        if (b != null) {
            return TObject.booleanVal(b == false);
        }
        return BOOLEAN_NULL;
    }

    public static TObject createAndCastFromObject(TType type, Object ob) {
        return new TObject(type, TType.castObjectToTType(ob, type));
    }

    public TObject castTo(TType cast_to_type) {
        Object ob = this.getObject();
        return TObject.createAndCastFromObject(cast_to_type, ob);
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getObject().toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ob instanceof String) {
            this.ob = StringObject.fromString((String)this.ob);
        }
    }
}

