/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TType;
import com.mckoi.database.global.BlobAccessor;
import com.mckoi.database.global.BlobRef;
import com.mckoi.database.global.ByteLongObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TBinaryType
extends TType {
    static final long serialVersionUID = 5141996433600529406L;
    private int max_size;
    static /* synthetic */ Class class$com$mckoi$database$global$BlobAccessor;

    public TBinaryType(int sql_type, int max_size) {
        super(sql_type);
        this.max_size = max_size;
    }

    public int getMaximumSize() {
        return this.max_size;
    }

    static int compareBlobs(BlobAccessor blob1, BlobAccessor blob2) {
        int c = blob1.length() - blob2.length();
        if (c != 0) {
            return c;
        }
        InputStream b1 = blob1.getInputStream();
        InputStream b2 = blob2.getInputStream();
        try {
            BufferedInputStream bin1 = new BufferedInputStream(b1);
            BufferedInputStream bin2 = new BufferedInputStream(b2);
            for (int len = blob1.length(); len > 0; --len) {
                c = bin1.read() - bin2.read();
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error when comparing blobs: " + e.getMessage());
        }
    }

    public boolean comparableTypes(TType type) {
        return type instanceof BlobAccessor;
    }

    public int compareObs(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return 0;
        }
        BlobAccessor blob1 = (BlobAccessor)ob1;
        BlobAccessor blob2 = (BlobAccessor)ob2;
        return TBinaryType.compareBlobs(blob1, blob2);
    }

    public int calculateApproximateMemoryUse(Object ob) {
        if (ob != null) {
            if (ob instanceof BlobRef) {
                return 256;
            }
            return ((ByteLongObject)ob).length() + 24;
        }
        return 32;
    }

    public Class javaClass() {
        return class$com$mckoi$database$global$BlobAccessor == null ? (class$com$mckoi$database$global$BlobAccessor = TBinaryType.class$("com.mckoi.database.global.BlobAccessor")) : class$com$mckoi$database$global$BlobAccessor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

