/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.FilterTable;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RootTable;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;

public final class SubsetColumnTable
extends FilterTable
implements RootTable {
    private int[] column_map;
    private int[] reverse_column_map;
    private DataTableDef subset_table_def;
    private Variable[] aliases;

    public SubsetColumnTable(Table parent) {
        super(parent);
    }

    public void setColumnMap(int[] mapping, Variable[] aliases) {
        this.reverse_column_map = new int[this.parent.getColumnCount()];
        for (int i = 0; i < this.reverse_column_map.length; ++i) {
            this.reverse_column_map[i] = -1;
        }
        this.column_map = mapping;
        this.aliases = aliases;
        this.subset_table_def = new DataTableDef();
        DataTableDef parent_def = this.parent.getDataTableDef();
        this.subset_table_def.setTableName(parent_def.getTableName());
        int i = 0;
        while (i < mapping.length) {
            int map_to = mapping[i];
            DataTableColumnDef col_def = new DataTableColumnDef(this.parent.getColumnDefAt(map_to));
            col_def.setName(aliases[i].getName());
            this.subset_table_def.addVirtualColumn(col_def);
            this.reverse_column_map[map_to] = i++;
        }
        this.subset_table_def.setImmutable();
    }

    public int getColumnCount() {
        return this.aliases.length;
    }

    public int findFieldName(Variable v) {
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!v.equals(this.aliases[i])) continue;
            return i;
        }
        return -1;
    }

    public DataTableDef getDataTableDef() {
        return this.subset_table_def;
    }

    public Variable getResolvedVariable(int column) {
        return this.aliases[column];
    }

    final SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        int mapped_original_column = original_column;
        if (table == this) {
            mapped_original_column = this.column_map[original_column];
        }
        return super.getSelectableSchemeFor(this.column_map[column], mapped_original_column, table);
    }

    final void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        super.setToRowTableDomain(this.column_map[column], row_set, ancestor);
    }

    final RawTableInformation resolveToRawTable(RawTableInformation info) {
        throw new Error("Tricky to implement this method!");
    }

    public final TObject getCellContents(int column, int row) {
        return this.parent.getCellContents(this.column_map[column], row);
    }

    public boolean typeEquals(RootTable table) {
        return this == table;
    }

    public String toString() {
        String name = "SCT" + this.hashCode();
        return name + "[" + this.getRowCount() + "]";
    }
}

