/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementTreeObject;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Variable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class StatementTree
implements Serializable,
Cloneable {
    static final long serialVersionUID = -5907058730080713004L;
    private String statement_class;
    private HashMap map;

    public StatementTree(String statement_class) {
        if (!statement_class.startsWith("com.mckoi.database.interpret.")) {
            throw new Error("statement_class must be in the com.mckoi.database.interpret package.");
        }
        this.statement_class = statement_class;
        this.map = new HashMap();
    }

    public void putObject(String entry_name, Object ob) {
        if (entry_name == null) {
            throw new NullPointerException("entry_name is null.");
        }
        if (ob == null || ob instanceof Boolean || ob instanceof String || ob instanceof BigDecimal || ob instanceof Variable || ob instanceof Integer || ob instanceof TObject || ob instanceof TType || ob instanceof Expression || ob instanceof Expression[] || ob instanceof List || ob instanceof StatementTree || ob instanceof StatementTreeObject) {
            Object v = this.map.put(entry_name, ob);
            if (v != null) {
                throw new Error("Entry '" + entry_name + "' is already present in this tree.");
            }
        } else {
            throw new Error("ob of entry '" + entry_name + "' is not derived from a recognised class");
        }
    }

    public void putBoolean(String entry_name, boolean b) {
        this.putObject(entry_name, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putInt(String entry_name, int v) {
        this.putObject(entry_name, new Integer(v));
    }

    public Object getObject(String entry_name) {
        return this.map.get(entry_name);
    }

    public boolean getBoolean(String entry_name) {
        Object ob = this.map.get(entry_name);
        return (Boolean)ob;
    }

    public int getInt(String entry_name) {
        Object ob = this.map.get(entry_name);
        return (Integer)ob;
    }

    public String getClassName() {
        return this.statement_class;
    }

    public void prepareAllExpressions(ExpressionPreparer preparer) throws DatabaseException {
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Object v = i.next();
            if (v == null) continue;
            this.prepareExpressionsInObject(v, preparer);
        }
    }

    private void prepareExpressionsInObject(Object v, ExpressionPreparer preparer) throws DatabaseException {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            if (!(v instanceof Expression)) break block2;
                            ((Expression)v).prepare(preparer);
                            break block3;
                        }
                        if (!(v instanceof Expression[])) break block4;
                        Expression[] exp_list = (Expression[])v;
                        for (int n = 0; n < exp_list.length; ++n) {
                            exp_list[n].prepare(preparer);
                        }
                        break block3;
                    }
                    if (!(v instanceof StatementTreeObject)) break block5;
                    StatementTreeObject stob = (StatementTreeObject)v;
                    stob.prepareExpressions(preparer);
                    break block3;
                }
                if (!(v instanceof StatementTree)) break block6;
                StatementTree st = (StatementTree)v;
                st.prepareAllExpressions(preparer);
                break block3;
            }
            if (!(v instanceof List)) break block3;
            List list = (List)v;
            for (int n = 0; n < list.size(); ++n) {
                Object ob = list.get(n);
                this.prepareExpressionsInObject(ob, preparer);
            }
        }
    }

    public static Object cloneSingleObject(Object entry) throws CloneNotSupportedException {
        if (!(entry == null || entry instanceof TObject || entry instanceof TType || entry instanceof Boolean || entry instanceof String || entry instanceof BigDecimal || entry instanceof Integer)) {
            if (entry instanceof Expression) {
                entry = ((Expression)entry).clone();
            } else if (entry instanceof Expression[]) {
                Expression[] exps = (Expression[])((Expression[])entry).clone();
                for (int n = 0; n < exps.length; ++n) {
                    exps[n] = (Expression)exps[n].clone();
                }
                entry = exps;
            } else if (entry instanceof Variable) {
                entry = ((Variable)entry).clone();
            } else if (entry instanceof StatementTreeObject) {
                entry = ((StatementTreeObject)entry).clone();
            } else if (entry instanceof StatementTree) {
                entry = ((StatementTree)entry).clone();
            } else if (entry instanceof List) {
                List list = (List)entry;
                ArrayList<Object> cloned_list = new ArrayList<Object>(list.size());
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    cloned_list.add(StatementTree.cloneSingleObject(i.next()));
                }
                entry = cloned_list;
            } else {
                throw new CloneNotSupportedException(entry.getClass().toString());
            }
        }
        return entry;
    }

    public Object clone() throws CloneNotSupportedException {
        HashMap cloned_map;
        StatementTree v = (StatementTree)super.clone();
        v.map = cloned_map = new HashMap();
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object entry = this.map.get(key);
            entry = StatementTree.cloneSingleObject(entry);
            cloned_map.put(key, entry);
        }
        return v;
    }

    public String toString() {
        return "[ " + this.getClassName() + " [ " + this.map + " ] ]";
    }
}

