/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableDataSource;
import com.mckoi.util.IntegerVector;

public final class SimpleTableQuery {
    private DataTableDef table_def;
    private TableDataSource table;

    public SimpleTableQuery(TableDataSource in_table) {
        this.table = in_table;
        this.table_def = this.table.getDataTableDef();
    }

    public RowEnumeration rowEnumeration() {
        return this.table.rowEnumeration();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public TObject get(int column, int row) {
        return this.table.getCellContents(column, row);
    }

    public IntegerVector selectIndexesEqual(int column, TObject cell) {
        return this.table.getColumnScheme(column).selectEqual(cell);
    }

    public IntegerVector selectIndexesEqual(int column, Object value) {
        TType ttype = this.table_def.columnAt(column).getTType();
        TObject cell = new TObject(ttype, value);
        return this.selectIndexesEqual(column, cell);
    }

    public IntegerVector selectIndexesEqual(int col1, TObject cell1, int col2, TObject cell2) {
        IntegerVector ivec = this.table.getColumnScheme(col1).selectEqual(cell1);
        for (int index = ivec.size() - 1; index >= 0; --index) {
            if (this.get(col2, ivec.intAt(index)).compareTo(cell2) == 0) continue;
            ivec.removeIntAt(index);
        }
        return ivec;
    }

    public IntegerVector selectIndexesEqual(int col1, Object val1, int col2, Object val2) {
        TType t1 = this.table_def.columnAt(col1).getTType();
        TType t2 = this.table_def.columnAt(col2).getTType();
        TObject cell1 = new TObject(t1, val1);
        TObject cell2 = new TObject(t2, val2);
        return this.selectIndexesEqual(col1, cell1, col2, cell2);
    }

    public boolean existsSingle(int col, Object val) {
        IntegerVector ivec = this.selectIndexesEqual(col, val);
        if (ivec.size() == 0) {
            return false;
        }
        if (ivec.size() == 1) {
            return true;
        }
        throw new Error("Assertion failed: existsSingle found multiple values.");
    }

    public Object getVar(int value_column, int key_column, Object key_value) {
        IntegerVector ivec = this.selectIndexesEqual(key_column, key_value);
        if (ivec.size() > 1) {
            throw new Error("Assertion failed: getVar found multiple key values.");
        }
        if (ivec.size() == 0) {
            return this.get(value_column, ivec.intAt(0));
        }
        return null;
    }

    public void setVar(int key_column, Object[] vals) {
        MutableTableDataSource mtable = (MutableTableDataSource)this.table;
        IntegerVector ivec = this.selectIndexesEqual(key_column, vals[key_column]);
        if (ivec.size() > 1) {
            throw new Error("Assertion failed: setVar found multiple key values.");
        }
        if (ivec.size() == 1) {
            mtable.removeRow(ivec.intAt(0));
        }
        RowData row_data = new RowData(this.table);
        for (int i = 0; i < this.table_def.columnCount(); ++i) {
            row_data.setColumnDataFromObject(i, vals[i]);
        }
        mtable.addRow(row_data);
    }

    public boolean deleteSingle(int col, Object val) {
        MutableTableDataSource mtable = (MutableTableDataSource)this.table;
        IntegerVector ivec = this.selectIndexesEqual(col, val);
        if (ivec.size() == 0) {
            return false;
        }
        if (ivec.size() == 1) {
            mtable.removeRow(ivec.intAt(0));
            return true;
        }
        throw new Error("Assertion failed: deleteSingle found multiple values.");
    }

    public void deleteRows(IntegerVector list) {
        MutableTableDataSource mtable = (MutableTableDataSource)this.table;
        for (int i = 0; i < list.size(); ++i) {
            mtable.removeRow(list.intAt(i));
        }
    }

    public void dispose() {
        if (this.table != null) {
            this.table = null;
        }
    }

    public void finalize() {
        this.dispose();
    }
}

