/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Assignment;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.QueryContext;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.global.StringObject;
import com.mckoi.database.global.Types;
import java.util.Arrays;
import java.util.List;

public class RowData
implements Types {
    private TransactionSystem system;
    private TableDataSource table;
    private DataTableDef table_def;
    private TObject[] data_cell_list;
    private int col_count;
    private RDVariableResolver variable_resolver = null;

    public RowData(TransactionSystem system, int col_count) {
        this.system = system;
        this.col_count = col_count;
        this.data_cell_list = new TObject[col_count];
    }

    public RowData(TableDataSource table) {
        this.system = table.getSystem();
        this.table = table;
        this.table_def = table.getDataTableDef();
        this.col_count = this.table_def.columnCount();
        this.data_cell_list = new TObject[this.col_count];
    }

    void setFromRow(int row) {
        for (int col = 0; col < this.col_count; ++col) {
            this.setColumnData(col, this.table.getCellContents(col, row));
        }
    }

    boolean isSameTable(DataTable tab) {
        return this.table == tab;
    }

    public void setColumnData(int column, TObject cell) {
        DataTableColumnDef col = this.table_def.columnAt(column);
        if (this.table != null && col.getSQLType() != cell.getTType().getSQLType()) {
            cell = cell.castTo(col.getTType());
        }
        this.setColumnDataFromTObject(column, cell);
    }

    public void setColumnDataFromObject(int column, Object ob) {
        DataTableColumnDef col_def = this.table_def.columnAt(column);
        if (ob instanceof String) {
            ob = StringObject.fromString((String)ob);
        }
        TObject cell = TObject.createAndCastFromObject(col_def.getTType(), ob);
        this.setColumnDataFromTObject(column, cell);
    }

    public void setColumnDataFromTObject(int column, TObject ob) {
        this.data_cell_list[column] = ob;
    }

    public void setColumnToNull(int column) {
        DataTableColumnDef col_def = this.table_def.columnAt(column);
        this.setColumnDataFromTObject(column, new TObject(col_def.getTType(), null));
    }

    public void setColumnToDefault(int column, QueryContext context) {
        DataTableColumnDef column_def;
        Expression exp;
        if (this.table != null && (exp = (column_def = this.table_def.columnAt(column)).getDefaultExpression(this.system)) != null) {
            TObject def_val = this.evaluate(exp, context);
            this.setColumnData(column, def_val);
            return;
        }
        this.setColumnToNull(column);
    }

    public TObject getCellData(int column) {
        TObject cell = this.data_cell_list[column];
        if (cell == null) {
            DataTableColumnDef col_def = this.table_def.columnAt(column);
            cell = new TObject(col_def.getTType(), null);
        }
        return cell;
    }

    public String getColumnName(int column) {
        return this.table_def.columnAt(column).getName();
    }

    public int findFieldName(String column_name) {
        return this.table_def.findColumnName(column_name);
    }

    public int getColumnCount() {
        return this.col_count;
    }

    TObject evaluate(Expression expression, QueryContext context) {
        boolean ignore_case = this.system.ignoreIdentifierCase();
        this.table_def.resolveColumns(ignore_case, expression);
        VariableResolver vresolver = this.getVariableResolver();
        return expression.evaluate(null, vresolver, context);
    }

    void evaluate(Assignment assignment, QueryContext context) {
        VariableResolver vresolver = this.getVariableResolver();
        TObject ob = assignment.getExpression().evaluate(null, vresolver, context);
        Variable variable = assignment.getVariable();
        int column = this.findFieldName(variable.getName());
        this.setColumnData(column, ob);
    }

    public void setDefaultForRest(QueryContext context) throws DatabaseException {
        for (int i = 0; i < this.col_count; ++i) {
            if (this.data_cell_list[i] != null) continue;
            this.setColumnToDefault(i, context);
        }
    }

    public void setupEntire(Assignment[] assignments, QueryContext context) throws DatabaseException {
        for (int i = 0; i < assignments.length; ++i) {
            this.evaluate(assignments[i], context);
        }
        this.setDefaultForRest(context);
    }

    public void setupEntire(int[] col_indices, List insert_elements, QueryContext context) throws DatabaseException {
        int elem_size = insert_elements.size();
        if (col_indices.length != elem_size) {
            throw new DatabaseException("Column indices and expression array sizes don't match");
        }
        VariableResolver vresolver = this.getVariableResolver();
        for (int i = 0; i < col_indices.length; ++i) {
            Object element = insert_elements.get(i);
            if (element instanceof Expression) {
                TObject ob = ((Expression)element).evaluate(null, vresolver, context);
                int table_column = col_indices[i];
                ob = ob.castTo(this.table_def.columnAt(table_column).getTType());
                this.setColumnDataFromTObject(table_column, ob);
                continue;
            }
            if (element.equals("DEFAULT")) continue;
            throw new DatabaseException("Invalid value in 'insert_elements' list.");
        }
        this.setDefaultForRest(context);
    }

    public void setupEntire(int[] col_indices, Expression[] exps, QueryContext context) throws DatabaseException {
        this.setupEntire(col_indices, Arrays.asList(exps), context);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[RowData: ");
        for (int i = 0; i < this.col_count; ++i) {
            buf.append(this.data_cell_list[i].getObject());
            buf.append(", ");
        }
        return new String(buf);
    }

    private VariableResolver getVariableResolver() {
        if (this.variable_resolver == null) {
            this.variable_resolver = new RDVariableResolver();
        } else {
            this.variable_resolver.nextAssignment();
        }
        return this.variable_resolver;
    }

    private class RDVariableResolver
    implements VariableResolver {
        private int assignment_count = 0;

        private RDVariableResolver() {
        }

        void nextAssignment() {
            ++this.assignment_count;
        }

        public int setID() {
            return this.assignment_count;
        }

        public TObject resolve(Variable variable) {
            String col_name = variable.getName();
            int col_index = RowData.this.table_def.findColumnName(col_name);
            if (col_index == -1) {
                throw new Error("Can't find column: " + col_name);
            }
            TObject cell = RowData.this.data_cell_list[col_index];
            if (cell == null) {
                throw new Error("Column " + col_name + " hasn't been set yet.");
            }
            return cell;
        }

        public TType returnTType(Variable variable) {
            String col_name = variable.getName();
            int col_index = RowData.this.table_def.findColumnName(col_name);
            if (col_index == -1) {
                throw new Error("Can't find column: " + col_name);
            }
            return RowData.this.table_def.columnAt(col_index).getTType();
        }
    }
}

