/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractInternalTableInfo2;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.Operator;
import com.mckoi.database.ProcedureConnection;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.StatementException;
import com.mckoi.database.TBinaryType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TDateType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TObject;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.User;
import com.mckoi.database.Variable;
import com.mckoi.database.global.BlobAccessor;
import com.mckoi.database.global.StringAccessor;
import com.mckoi.util.BigNumber;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ProcedureManager {
    private DatabaseConnection connection;
    private DatabaseQueryContext context;
    static /* synthetic */ Class class$com$mckoi$database$ProcedureConnection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$com$mckoi$util$BigNumber;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$B;

    ProcedureManager(DatabaseConnection connection) {
        this.connection = connection;
        this.context = new DatabaseQueryContext(connection);
    }

    private Table findProcedureEntry(DataTable table, ProcedureName procedure_name) {
        Operator EQUALS = Operator.get("=");
        Variable schemav = table.getResolvedVariable(0);
        Variable namev = table.getResolvedVariable(1);
        Table t = table.simpleSelect(this.context, namev, EQUALS, new Expression(TObject.stringVal(procedure_name.getName())));
        if ((t = t.exhaustiveSelect(this.context, Expression.simple(schemav, EQUALS, TObject.stringVal(procedure_name.getSchema())))).getRowCount() > 1) {
            throw new RuntimeException("Assert failed: multiple procedure names for " + procedure_name);
        }
        return t;
    }

    private static String procedureInfoString(ProcedureName name, TType ret, TType[] params) {
        StringBuffer buf = new StringBuffer();
        if (ret != null) {
            buf.append(ret.asSQLString());
            buf.append(" ");
        }
        buf.append(name.getName());
        buf.append("(");
        for (int i = 0; i < params.length; ++i) {
            buf.append(params[i].asSQLString());
            if (i >= params.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return new String(buf);
    }

    public static String[] parseJavaLocationString(String str) {
        int parenthese_delim = str.indexOf("(");
        if (parenthese_delim != -1) {
            String class_method = str.substring(0, parenthese_delim);
            int method_delim = class_method.lastIndexOf(".");
            if (method_delim == -1) {
                throw new StatementException("Incorrectly formatted Java method string: " + str);
            }
            String class_str = class_method.substring(0, method_delim);
            String method_str = class_method.substring(method_delim + 1);
            int end_parenthese_delim = str.lastIndexOf(")");
            if (end_parenthese_delim == -1) {
                throw new StatementException("Incorrectly formatted Java method string: " + str);
            }
            String arg_list_str = str.substring(parenthese_delim + 1, end_parenthese_delim);
            ArrayList<String> arg_list = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(arg_list_str, ",");
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken();
                arg_list.add(arg);
            }
            int sz = arg_list.size();
            String[] return_array = new String[2 + sz];
            return_array[0] = class_str;
            return_array[1] = method_str;
            for (int i = 0; i < sz; ++i) {
                return_array[i + 2] = (String)arg_list.get(i);
            }
            return return_array;
        }
        return new String[]{str};
    }

    public boolean procedureExists(ProcedureName procedure_name) {
        DataTable table = this.connection.getTable(Database.SYS_FUNCTION);
        return this.findProcedureEntry(table, procedure_name).getRowCount() == 1;
    }

    public boolean procedureExists(TableName procedure_name) {
        return this.procedureExists(new ProcedureName(procedure_name));
    }

    public void defineJavaProcedure(ProcedureName procedure_name, String java_specification, TType return_type, TType[] param_types, String username) throws DatabaseException {
        TableName proc_table_name = new TableName(procedure_name.getSchema(), procedure_name.getName());
        DatabaseConnection.checkAllowCreate(proc_table_name);
        DataTable table = this.connection.getTable(Database.SYS_FUNCTION);
        RowData row_data = new RowData(table);
        row_data.setColumnDataFromObject(0, procedure_name.getSchema());
        row_data.setColumnDataFromObject(1, procedure_name.getName());
        row_data.setColumnDataFromObject(2, "Java-1");
        row_data.setColumnDataFromObject(3, java_specification);
        if (return_type != null) {
            row_data.setColumnDataFromObject(4, TType.asEncodedString(return_type));
        }
        row_data.setColumnDataFromObject(5, TType.asEncodedString(param_types));
        row_data.setColumnDataFromObject(6, username);
        Table t = this.findProcedureEntry(table, procedure_name);
        if (t.getRowCount() == 1) {
            table.delete(t);
        }
        table.add(row_data);
        this.connection.databaseObjectCreated(proc_table_name);
    }

    public void deleteProcedure(ProcedureName procedure_name) throws DatabaseException {
        DataTable table = this.connection.getTable(Database.SYS_FUNCTION);
        Table t = this.findProcedureEntry(table, procedure_name);
        if (t.getRowCount() == 0) {
            throw new StatementException("Procedure " + procedure_name + " doesn't exist.");
        }
        table.delete(t);
        this.connection.databaseObjectDropped(new TableName(procedure_name.getSchema(), procedure_name.getName()));
    }

    static InternalTableInfo createInternalTableInfo(Transaction transaction) {
        return new ProcedureInternalTableInfo(transaction);
    }

    public TObject invokeProcedure(ProcedureName procedure_name, TObject[] params) {
        DataTable table = this.connection.getTable(Database.SYS_FUNCTION);
        Table t = this.findProcedureEntry(table, procedure_name);
        if (t.getRowCount() == 0) {
            throw new StatementException("Procedure " + procedure_name + " doesn't exist.");
        }
        int row_index = t.rowEnumeration().nextRowIndex();
        TObject type_ob = t.getCellContents(2, row_index);
        TObject location_ob = t.getCellContents(3, row_index);
        TObject return_type_ob = t.getCellContents(4, row_index);
        TObject param_types_ob = t.getCellContents(5, row_index);
        TObject owner_ob = t.getCellContents(6, row_index);
        String type = type_ob.getObject().toString();
        String location = location_ob.getObject().toString();
        TType return_type = null;
        if (!return_type_ob.isNull()) {
            return_type = TType.decodeString(return_type_ob.getObject().toString());
        }
        TType[] param_types = TType.decodeTypes(param_types_ob.getObject().toString());
        String owner = owner_ob.getObject().toString();
        if (params.length != param_types.length) {
            throw new StatementException("Parameters given do not match the parameters of the procedure: " + ProcedureManager.procedureInfoString(procedure_name, return_type, param_types));
        }
        if (type.equals("Java-1")) {
            return this.invokeJavaV1Procedure(procedure_name, location, return_type, param_types, owner, params);
        }
        throw new RuntimeException("Unknown procedure type: " + type);
    }

    private static Class resolveToClass(String java_spec) {
        Class cl;
        java_spec = java_spec.trim();
        int dimensions = -1;
        int last_index = java_spec.length();
        while (last_index > 0) {
            ++dimensions;
            last_index = java_spec.lastIndexOf("[]", last_index) - 1;
        }
        int array_end = java_spec.length() - dimensions * 2;
        String class_part = java_spec.substring(0, array_end);
        if (class_part.indexOf("[]") != -1) {
            throw new RuntimeException("Java class specification incorrectly formatted: " + java_spec);
        }
        if (class_part.indexOf(".") != -1) {
            try {
                cl = Class.forName(class_part);
            }
            catch (ClassNotFoundException i) {
                throw new RuntimeException("Java class not found: " + class_part);
            }
        }
        if (class_part.equals("boolean")) {
            cl = Boolean.TYPE;
        } else if (class_part.equals("byte")) {
            cl = Byte.TYPE;
        } else if (class_part.equals("short")) {
            cl = Short.TYPE;
        } else if (class_part.equals("char")) {
            cl = Character.TYPE;
        } else if (class_part.equals("int")) {
            cl = Integer.TYPE;
        } else if (class_part.equals("long")) {
            cl = Long.TYPE;
        } else if (class_part.equals("float")) {
            cl = Float.TYPE;
        } else if (class_part.equals("double")) {
            cl = Double.TYPE;
        } else if (class_part.equals("ProcedureConnection")) {
            cl = class$com$mckoi$database$ProcedureConnection == null ? (class$com$mckoi$database$ProcedureConnection = ProcedureManager.class$("com.mckoi.database.ProcedureConnection")) : class$com$mckoi$database$ProcedureConnection;
        } else {
            try {
                cl = Class.forName("java.lang." + class_part);
            }
            catch (ClassNotFoundException i) {
                throw new RuntimeException("Java class not found: " + class_part);
            }
        }
        if (dimensions > 0) {
            cl = Array.newInstance(cl, new int[dimensions]).getClass();
        }
        return cl;
    }

    public static Method javaProcedureMethod(String location_str, TType[] param_types) {
        Class<?> procedure_class;
        boolean firstProcedureConnectionIgnore;
        Class[] object_specification;
        String method_name;
        String class_name;
        String[] loc_parts = ProcedureManager.parseJavaLocationString(location_str);
        if (loc_parts.length == 1) {
            class_name = loc_parts[0];
            method_name = "invoke";
            object_specification = new Class[param_types.length];
            firstProcedureConnectionIgnore = true;
        } else {
            class_name = loc_parts[0];
            method_name = loc_parts[1];
            object_specification = new Class[loc_parts.length - 2];
            for (int i = 0; i < loc_parts.length - 2; ++i) {
                String java_spec = loc_parts[i + 2];
                object_specification[i] = ProcedureManager.resolveToClass(java_spec);
            }
            firstProcedureConnectionIgnore = false;
        }
        try {
            procedure_class = Class.forName(class_name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Procedure class not found: " + class_name);
        }
        Method[] methods = procedure_class.getMethods();
        Method invoke_method = null;
        for (int i = 0; i < methods.length; ++i) {
            boolean params_match;
            Method method = methods[i];
            int modifier = method.getModifiers();
            if (!Modifier.isStatic(modifier) || !Modifier.isPublic(modifier) || !method.getName().equals(method_name)) continue;
            Class<?>[] method_args = method.getParameterTypes();
            if (method_args.length == 0 && object_specification.length == 0) {
                params_match = true;
            } else {
                int search_start = 0;
                if (firstProcedureConnectionIgnore && (class$com$mckoi$database$ProcedureConnection == null ? ProcedureManager.class$("com.mckoi.database.ProcedureConnection") : class$com$mckoi$database$ProcedureConnection).isAssignableFrom(method_args[0])) {
                    search_start = 1;
                }
                if (object_specification.length == method_args.length - search_start) {
                    boolean match_spec = true;
                    for (int n = 0; n < object_specification.length && match_spec; ++n) {
                        Class ob_spec = object_specification[n];
                        if (ob_spec == null || ob_spec == method_args[n + search_start]) continue;
                        match_spec = false;
                    }
                    params_match = match_spec;
                } else {
                    params_match = false;
                }
            }
            if (!params_match) continue;
            if (invoke_method == null) {
                invoke_method = method;
                continue;
            }
            throw new RuntimeException("Ambiguous public static " + method_name + " methods in stored procedure class '" + class_name + "'");
        }
        return invoke_method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TObject invokeJavaV1Procedure(ProcedureName procedure_name, String location_str, TType return_type, TType[] param_types, String owner, TObject[] param_values) {
        Object result;
        Object[] java_values;
        int start_param;
        Method invoke_method = ProcedureManager.javaProcedureMethod(location_str, param_types);
        if (invoke_method == null) {
            throw new RuntimeException("Could not find the invokation method for the Java location string '" + location_str + "'");
        }
        Class<?>[] java_param_types = invoke_method.getParameterTypes();
        if (java_param_types.length > 0 && (class$com$mckoi$database$ProcedureConnection == null ? (class$com$mckoi$database$ProcedureConnection = ProcedureManager.class$("com.mckoi.database.ProcedureConnection")) : class$com$mckoi$database$ProcedureConnection).isAssignableFrom(java_param_types[0])) {
            start_param = 1;
            java_values = new Object[param_types.length + 1];
        } else {
            start_param = 0;
            java_values = new Object[param_types.length];
        }
        for (int i = 0; i < param_types.length; ++i) {
            TObject value = param_values[i];
            TType proc_type = param_types[i];
            Class<?> java_type = java_param_types[i + start_param];
            String java_type_str = java_type.getName();
            if (value.isNull()) {
                java_values[i + start_param] = null;
                continue;
            }
            TType value_type = value.getTType();
            if (proc_type.comparableTypes(value_type)) {
                boolean error_cast = false;
                Object cast_value = null;
                if (value_type instanceof TStringType) {
                    StringAccessor accessor = (StringAccessor)value.getObject();
                    if (java_type == (class$java$lang$String == null ? ProcedureManager.class$("java.lang.String") : class$java$lang$String)) {
                        cast_value = ((Object)accessor).toString();
                    } else if (java_type == (class$java$io$Reader == null ? ProcedureManager.class$("java.io.Reader") : class$java$io$Reader)) {
                        cast_value = accessor.getReader();
                    } else {
                        error_cast = true;
                    }
                } else if (value_type instanceof TBooleanType) {
                    if (java_type == (class$java$lang$Boolean == null ? ProcedureManager.class$("java.lang.Boolean") : class$java$lang$Boolean) || java_type == Boolean.TYPE) {
                        cast_value = value.getObject();
                    } else {
                        error_cast = true;
                    }
                } else if (value_type instanceof TDateType) {
                    java.util.Date d = (java.util.Date)value.getObject();
                    if (java_type == (class$java$util$Date == null ? ProcedureManager.class$("java.util.Date") : class$java$util$Date)) {
                        cast_value = d;
                    } else if (java_type == (class$java$sql$Date == null ? ProcedureManager.class$("java.sql.Date") : class$java$sql$Date)) {
                        cast_value = new Date(d.getTime());
                    } else if (java_type == (class$java$sql$Time == null ? ProcedureManager.class$("java.sql.Time") : class$java$sql$Time)) {
                        cast_value = new Time(d.getTime());
                    } else if (java_type == (class$java$sql$Timestamp == null ? ProcedureManager.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                        cast_value = new Timestamp(d.getTime());
                    } else {
                        error_cast = true;
                    }
                } else if (value_type instanceof TNumericType) {
                    BigNumber num = (BigNumber)value.getObject();
                    if (java_type == (class$com$mckoi$util$BigNumber == null ? ProcedureManager.class$("com.mckoi.util.BigNumber") : class$com$mckoi$util$BigNumber)) {
                        cast_value = num;
                    } else if (java_type == (class$java$lang$Byte == null ? ProcedureManager.class$("java.lang.Byte") : class$java$lang$Byte) || java_type == Byte.TYPE) {
                        cast_value = new Byte(num.byteValue());
                    } else if (java_type == (class$java$lang$Short == null ? ProcedureManager.class$("java.lang.Short") : class$java$lang$Short) || java_type == Short.TYPE) {
                        cast_value = new Short(num.shortValue());
                    } else if (java_type == (class$java$lang$Integer == null ? ProcedureManager.class$("java.lang.Integer") : class$java$lang$Integer) || java_type == Integer.TYPE) {
                        cast_value = new Integer(num.intValue());
                    } else if (java_type == (class$java$lang$Long == null ? ProcedureManager.class$("java.lang.Long") : class$java$lang$Long) || java_type == Long.TYPE) {
                        cast_value = new Long(num.longValue());
                    } else if (java_type == (class$java$lang$Float == null ? ProcedureManager.class$("java.lang.Float") : class$java$lang$Float) || java_type == Float.TYPE) {
                        cast_value = new Float(num.floatValue());
                    } else if (java_type == (class$java$lang$Double == null ? ProcedureManager.class$("java.lang.Double") : class$java$lang$Double) || java_type == Double.TYPE) {
                        cast_value = new Double(num.doubleValue());
                    } else if (java_type == (class$java$math$BigDecimal == null ? ProcedureManager.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                        cast_value = num.asBigDecimal();
                    } else {
                        error_cast = true;
                    }
                } else if (value_type instanceof TBinaryType) {
                    BlobAccessor blob = (BlobAccessor)value.getObject();
                    if (java_type == (class$java$io$InputStream == null ? ProcedureManager.class$("java.io.InputStream") : class$java$io$InputStream)) {
                        cast_value = blob.getInputStream();
                    } else if (java_type == (array$B == null ? ProcedureManager.class$("[B") : array$B)) {
                        byte[] buf = new byte[blob.length()];
                        try {
                            int count;
                            InputStream in = blob.getInputStream();
                            int n = 0;
                            for (int len = blob.length(); len > 0; len -= count) {
                                count = in.read(buf, n, len);
                                if (count == -1) {
                                    throw new IOException("End of stream.");
                                }
                                n += count;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException("IO Error: " + e.getMessage());
                        }
                        cast_value = buf;
                    } else {
                        error_cast = true;
                    }
                }
                if (error_cast) {
                    throw new StatementException("Unable to cast argument " + i + " ... " + value_type.asSQLString() + " to " + java_type_str + " for procedure: " + ProcedureManager.procedureInfoString(procedure_name, return_type, param_types));
                }
                java_values[i + start_param] = cast_value;
                continue;
            }
            throw new StatementException("Parameter (" + i + ") not compatible " + value.getTType().asSQLString() + " -> " + proc_type.asSQLString() + " for procedure: " + ProcedureManager.procedureInfoString(procedure_name, return_type, param_types));
        }
        User priv_user = new User(owner, this.connection.getDatabase(), "/Internal/Procedure/", System.currentTimeMillis());
        ProcedureConnection proc_connection = this.connection.createProcedureConnection(priv_user);
        try {
            if (start_param > 0) {
                java_values[0] = proc_connection;
            }
            try {
                result = invoke_method.invoke(null, java_values);
            }
            catch (IllegalAccessException e) {
                this.connection.Debug().writeException(e);
                throw new StatementException("Illegal access exception when invoking stored procedure: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable real_e = e.getTargetException();
                this.connection.Debug().writeException(real_e);
                throw new StatementException("Procedure Exception: " + real_e.getMessage());
            }
            Object var26_29 = null;
            this.connection.disposeProcedureConnection(proc_connection);
        }
        catch (Throwable throwable) {
            Object var26_30 = null;
            this.connection.disposeProcedureConnection(proc_connection);
            throw throwable;
        }
        if (return_type == null) {
            return null;
        }
        return TObject.createAndCastFromObject(return_type, result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProcedureInternalTableInfo
    extends AbstractInternalTableInfo2 {
        ProcedureInternalTableInfo(Transaction transaction) {
            super(transaction, Database.SYS_FUNCTION);
        }

        private static DataTableDef createDataTableDef(String schema, String name) {
            DataTableDef def = new DataTableDef();
            def.setTableName(new TableName(schema, name));
            def.addColumn(DataTableColumnDef.createStringColumn("type"));
            def.addColumn(DataTableColumnDef.createStringColumn("location"));
            def.addColumn(DataTableColumnDef.createStringColumn("return_type"));
            def.addColumn(DataTableColumnDef.createStringColumn("param_args"));
            def.addColumn(DataTableColumnDef.createStringColumn("owner"));
            def.setImmutable();
            return def;
        }

        public String getTableType(int i) {
            return "FUNCTION";
        }

        public DataTableDef getDataTableDef(int i) {
            TableName table_name = this.getTableName(i);
            return ProcedureInternalTableInfo.createDataTableDef(table_name.getSchema(), table_name.getName());
        }

        public MutableTableDataSource createInternalTable(int index) {
            MutableTableDataSource table = this.transaction.getTable(Database.SYS_FUNCTION);
            RowEnumeration row_e = table.rowEnumeration();
            int p = 0;
            int row_i = -1;
            while (row_e.hasMoreRows()) {
                int i = row_e.nextRowIndex();
                if (p == index) {
                    row_i = i;
                    continue;
                }
                ++p;
            }
            if (p == index) {
                String schema = table.getCellContents(0, row_i).getObject().toString();
                String name = table.getCellContents(1, row_i).getObject().toString();
                final DataTableDef table_def = ProcedureInternalTableInfo.createDataTableDef(schema, name);
                final TObject type = table.getCellContents(2, row_i);
                final TObject location = table.getCellContents(3, row_i);
                final TObject return_type = table.getCellContents(4, row_i);
                final TObject param_types = table.getCellContents(5, row_i);
                final TObject owner = table.getCellContents(6, row_i);
                return new GTDataSource(this.transaction.getSystem()){

                    public DataTableDef getDataTableDef() {
                        return table_def;
                    }

                    public int getRowCount() {
                        return 1;
                    }

                    public TObject getCellContents(int col, int row) {
                        switch (col) {
                            case 0: {
                                return type;
                            }
                            case 1: {
                                return location;
                            }
                            case 2: {
                                return return_type;
                            }
                            case 3: {
                                return param_types;
                            }
                            case 4: {
                                return owner;
                            }
                        }
                        throw new RuntimeException("Column out of bounds.");
                    }
                };
            }
            throw new RuntimeException("Index out of bounds.");
        }
    }
}

