/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CorrelatedVariable;
import com.mckoi.database.Expression;
import com.mckoi.database.GroupResolver;
import com.mckoi.database.PatternSearch;
import com.mckoi.database.QueryContext;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.TArrayType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TObject;
import com.mckoi.database.TQueryPlanType;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.VariableResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Operator
implements Serializable {
    static final long serialVersionUID = 516615288995154064L;
    public static final int NONE = 0;
    public static final int ANY = 1;
    public static final int ALL = 2;
    private String op;
    private int set_type;
    private int precedence;
    private static final AddOperator add_op = new AddOperator();
    private static final SubtractOperator sub_op = new SubtractOperator();
    private static final MultiplyOperator mul_op = new MultiplyOperator();
    private static final DivideOperator div_op = new DivideOperator();
    private static final ConcatOperator concat_op = new ConcatOperator();
    private static final EqualOperator eq_op = new EqualOperator();
    private static final NotEqualOperator neq_op = new NotEqualOperator();
    private static final GreaterOperator g_op = new GreaterOperator();
    private static final LesserOperator l_op = new LesserOperator();
    private static final GreaterEqualOperator geq_op = new GreaterEqualOperator();
    private static final LesserEqualOperator leq_op = new LesserEqualOperator();
    private static final IsOperator is_op = new IsOperator();
    private static final IsNotOperator isn_op = new IsNotOperator();
    private static final PatternMatchTrueOperator like_op = new PatternMatchTrueOperator();
    private static final PatternMatchFalseOperator nlike_op = new PatternMatchFalseOperator();
    private static final RegexOperator regex_op = new RegexOperator();
    private static final Operator in_op;
    private static final Operator nin_op;
    private static final Operator not_op;
    private static final AndOperator and_op;
    private static final OrOperator or_op;
    private static final ParenOperator par1_op;
    private static final ParenOperator par2_op;
    private static final HashMap any_map;
    private static final HashMap all_map;

    protected Operator(String op) {
        this(op, 0, 0);
    }

    protected Operator(String op, int precedence) {
        this(op, precedence, 0);
    }

    protected Operator(String op, int precedence, int set_type) {
        if (set_type != 0 && set_type != 1 && set_type != 2) {
            throw new Error("Invalid set_type.");
        }
        this.op = op;
        this.precedence = precedence;
        this.set_type = set_type;
    }

    public boolean is(String given_op) {
        return given_op.equals(this.op);
    }

    public abstract TObject eval(TObject var1, TObject var2, GroupResolver var3, VariableResolver var4, QueryContext var5);

    public int precedence() {
        return this.precedence;
    }

    public boolean isCondition() {
        return this.equals(eq_op) || this.equals(neq_op) || this.equals(g_op) || this.equals(l_op) || this.equals(geq_op) || this.equals(leq_op) || this.equals(is_op) || this.equals(isn_op);
    }

    public boolean isMathematical() {
        return this.equals(add_op) || this.equals(sub_op) || this.equals(mul_op) || this.equals(div_op) || this.equals(concat_op);
    }

    public boolean isPattern() {
        return this.equals(like_op) || this.equals(nlike_op) || this.equals(regex_op);
    }

    public boolean isLogical() {
        return this.equals(and_op) || this.equals(or_op);
    }

    public boolean isNot() {
        return this.equals(not_op);
    }

    public boolean isSubQuery() {
        return this.set_type != 0 || this.equals(in_op) || this.equals(nin_op);
    }

    public Operator reverse() {
        if (this.equals(eq_op) || this.equals(neq_op) || this.equals(is_op) || this.equals(isn_op)) {
            return this;
        }
        if (this.equals(g_op)) {
            return l_op;
        }
        if (this.equals(l_op)) {
            return g_op;
        }
        if (this.equals(geq_op)) {
            return leq_op;
        }
        if (this.equals(leq_op)) {
            return geq_op;
        }
        throw new Error("Can't reverse a non conditional operator.");
    }

    public boolean isNotInversible() {
        return this.equals(regex_op) || this.isMathematical();
    }

    public Operator inverse() {
        if (this.isSubQuery()) {
            int inv_type;
            if (this.isSubQueryForm(1)) {
                inv_type = 2;
            } else if (this.isSubQueryForm(2)) {
                inv_type = 1;
            } else {
                throw new RuntimeException("Can not handle sub-query form.");
            }
            Operator inv_op = Operator.get(this.op).inverse();
            return inv_op.getSubQueryForm(inv_type);
        }
        if (this.equals(eq_op)) {
            return neq_op;
        }
        if (this.equals(neq_op)) {
            return eq_op;
        }
        if (this.equals(g_op)) {
            return leq_op;
        }
        if (this.equals(l_op)) {
            return geq_op;
        }
        if (this.equals(geq_op)) {
            return l_op;
        }
        if (this.equals(leq_op)) {
            return g_op;
        }
        if (this.equals(and_op)) {
            return or_op;
        }
        if (this.equals(or_op)) {
            return and_op;
        }
        if (this.equals(like_op)) {
            return nlike_op;
        }
        if (this.equals(nlike_op)) {
            return like_op;
        }
        if (this.equals(is_op)) {
            return isn_op;
        }
        if (this.equals(isn_op)) {
            return is_op;
        }
        throw new Error("Can't inverse operator '" + this.op + "'");
    }

    public boolean isSubQueryForm(int type) {
        return type == this.set_type;
    }

    int getSubQueryFormRepresentation() {
        return this.set_type;
    }

    public Operator getSubQueryForm(int type) {
        Operator result_op = null;
        if (type == 1) {
            result_op = (Operator)any_map.get(this.op);
        } else if (type == 2) {
            result_op = (Operator)all_map.get(this.op);
        } else if (type == 0) {
            result_op = Operator.get(this.op);
        }
        if (result_op == null) {
            throw new Error("Couldn't change the form of operator '" + this.op + "'.");
        }
        return result_op;
    }

    public Operator getSubQueryForm(String type_str) {
        String s = type_str.toUpperCase();
        if (s.equals("SINGLE") || s.equals("ANY") || s.equals("SOME")) {
            return this.getSubQueryForm(1);
        }
        if (s.equals("ALL")) {
            return this.getSubQueryForm(2);
        }
        throw new Error("Do not understand subquery type '" + type_str + "'");
    }

    public TType returnTType() {
        if (this.equals(concat_op)) {
            return TType.STRING_TYPE;
        }
        if (this.isMathematical()) {
            return TType.NUMERIC_TYPE;
        }
        return TType.BOOLEAN_TYPE;
    }

    String stringRepresentation() {
        return this.op;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.op);
        if (this.set_type == 1) {
            buf.append(" ANY");
        } else if (this.set_type == 2) {
            buf.append(" ALL");
        }
        return new String(buf);
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        Operator oob = (Operator)ob;
        return this.op.equals(oob.op) && this.set_type == oob.set_type;
    }

    public static Operator get(String op) {
        if (op.equals("+")) {
            return add_op;
        }
        if (op.equals("-")) {
            return sub_op;
        }
        if (op.equals("*")) {
            return mul_op;
        }
        if (op.equals("/")) {
            return div_op;
        }
        if (op.equals("||")) {
            return concat_op;
        }
        if (op.equals("=") | op.equals("==")) {
            return eq_op;
        }
        if (op.equals("<>") | op.equals("!=")) {
            return neq_op;
        }
        if (op.equals(">")) {
            return g_op;
        }
        if (op.equals("<")) {
            return l_op;
        }
        if (op.equals(">=")) {
            return geq_op;
        }
        if (op.equals("<=")) {
            return leq_op;
        }
        if (op.equals("(")) {
            return par1_op;
        }
        if (op.equals(")")) {
            return par2_op;
        }
        if ((op = op.toLowerCase()).equals("is")) {
            return is_op;
        }
        if (op.equals("is not")) {
            return isn_op;
        }
        if (op.equals("like")) {
            return like_op;
        }
        if (op.equals("not like")) {
            return nlike_op;
        }
        if (op.equals("regex")) {
            return regex_op;
        }
        if (op.equals("in")) {
            return in_op;
        }
        if (op.equals("not in")) {
            return nin_op;
        }
        if (op.equals("not")) {
            return not_op;
        }
        if (op.equals("and")) {
            return and_op;
        }
        if (op.equals("or")) {
            return or_op;
        }
        throw new Error("Unrecognised operator type: " + op);
    }

    private static boolean isTrue(TObject bool) {
        return !bool.isNull() && bool.getTType() instanceof TBooleanType && bool.getObject().equals(Boolean.TRUE);
    }

    static {
        not_op = new SimpleOperator("not", 3);
        and_op = new AndOperator();
        or_op = new OrOperator();
        par1_op = new ParenOperator("(");
        par2_op = new ParenOperator(")");
        any_map = new HashMap();
        all_map = new HashMap();
        any_map.put("=", new AnyOperator("="));
        any_map.put("<>", new AnyOperator("<>"));
        any_map.put(">", new AnyOperator(">"));
        any_map.put(">=", new AnyOperator(">="));
        any_map.put("<", new AnyOperator("<"));
        any_map.put("<=", new AnyOperator("<="));
        all_map.put("=", new AllOperator("="));
        all_map.put("<>", new AllOperator("<>"));
        all_map.put(">", new AllOperator(">"));
        all_map.put(">=", new AllOperator(">="));
        all_map.put("<", new AllOperator("<"));
        all_map.put("<=", new AllOperator("<="));
        in_op = (Operator)any_map.get("=");
        nin_op = (Operator)all_map.get("<>");
    }

    static class SimpleOperator
    extends Operator {
        static final long serialVersionUID = 1136249637094226133L;

        public SimpleOperator(String str) {
            super(str);
        }

        public SimpleOperator(String str, int prec) {
            super(str, prec);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            throw new Error("SimpleOperator should never be evaluated!");
        }
    }

    static class ParenOperator
    extends Operator {
        static final long serialVersionUID = -5720902399037456435L;

        public ParenOperator(String paren) {
            super(paren);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            throw new Error("Parenthese should never be evaluated!");
        }
    }

    static class OrOperator
    extends Operator {
        static final long serialVersionUID = 6505549460035023998L;

        public OrOperator() {
            super("or", 1);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            Boolean b1 = ob1.toBoolean();
            Boolean b2 = ob2.toBoolean();
            if (b1 == null) {
                if (b2 != null && b2.equals(Boolean.TRUE)) {
                    return TObject.BOOLEAN_TRUE;
                }
                return TObject.BOOLEAN_NULL;
            }
            if (b2 == null) {
                if (b1.equals(Boolean.TRUE)) {
                    return TObject.BOOLEAN_TRUE;
                }
                return TObject.BOOLEAN_NULL;
            }
            return TObject.booleanVal(b1.equals(Boolean.TRUE) || b2.equals(Boolean.TRUE));
        }
    }

    static class AndOperator
    extends Operator {
        static final long serialVersionUID = -6044610739300316190L;

        public AndOperator() {
            super("and", 2);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            Boolean b1 = ob1.toBoolean();
            Boolean b2 = ob2.toBoolean();
            if (b1 == null) {
                if (b2 != null && b2.equals(Boolean.FALSE)) {
                    return TObject.BOOLEAN_FALSE;
                }
                return TObject.BOOLEAN_NULL;
            }
            if (b2 == null) {
                if (b1.equals(Boolean.FALSE)) {
                    return TObject.BOOLEAN_FALSE;
                }
                return TObject.BOOLEAN_NULL;
            }
            return TObject.booleanVal(b1.equals(Boolean.TRUE) && b2.equals(Boolean.TRUE));
        }
    }

    static class PatternMatchFalseOperator
    extends Operator {
        static final long serialVersionUID = 7271394661743778291L;

        public PatternMatchFalseOperator() {
            super("not like", 8);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (ob1.isNull()) {
                return ob1;
            }
            if (ob2.isNull()) {
                return ob2;
            }
            String val = ob1.castTo(TType.STRING_TYPE).toStringValue();
            String pattern = ob2.castTo(TType.STRING_TYPE).toStringValue();
            return TObject.booleanVal(!PatternSearch.fullPatternMatch(pattern, val, '\\'));
        }
    }

    static class PatternMatchTrueOperator
    extends Operator {
        static final long serialVersionUID = 3038856811053114238L;

        public PatternMatchTrueOperator() {
            super("like", 8);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (ob1.isNull()) {
                return ob1;
            }
            if (ob2.isNull()) {
                return ob2;
            }
            String val = ob1.castTo(TType.STRING_TYPE).toStringValue();
            String pattern = ob2.castTo(TType.STRING_TYPE).toStringValue();
            TObject result = TObject.booleanVal(PatternSearch.fullPatternMatch(pattern, val, '\\'));
            return result;
        }
    }

    static class RegexOperator
    extends Operator {
        static final long serialVersionUID = 8062751421429261272L;

        public RegexOperator() {
            super("regex", 8);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (ob1.isNull()) {
                return ob1;
            }
            if (ob2.isNull()) {
                return ob2;
            }
            String val = ob1.castTo(TType.STRING_TYPE).toStringValue();
            String pattern = ob2.castTo(TType.STRING_TYPE).toStringValue();
            return TObject.booleanVal(PatternSearch.regexMatch(context.getSystem(), pattern, val));
        }
    }

    static class AllOperator
    extends Operator {
        static final long serialVersionUID = -4605268759294925687L;

        public AllOperator(String op) {
            super(op, 8, 2);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (ob2.getTType() instanceof TQueryPlanType) {
                Operator rev_plain_op;
                Table t;
                QueryPlanNode plan = (QueryPlanNode)ob2.getObject();
                ArrayList list = plan.discoverCorrelatedVariables(1, new ArrayList());
                if (list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        ((CorrelatedVariable)list.get(i)).setFromResolver(resolver);
                    }
                    context.clearCache();
                }
                if ((t = plan.evaluate(context)).allColumnMatchesValue(0, rev_plain_op = this.getSubQueryForm(0).reverse(), ob1)) {
                    return TObject.BOOLEAN_TRUE;
                }
                return TObject.BOOLEAN_FALSE;
            }
            if (ob2.getTType() instanceof TArrayType) {
                Operator plain_op = this.getSubQueryForm(0);
                Expression[] exp_list = (Expression[])ob2.getObject();
                TObject ret_val = TObject.BOOLEAN_TRUE;
                for (int i = 0; i < exp_list.length; ++i) {
                    TObject exp_item = exp_list[i].evaluate(group, resolver, context);
                    if (exp_item.isNull()) {
                        ret_val = TObject.BOOLEAN_NULL;
                        continue;
                    }
                    if (Operator.isTrue(plain_op.eval(ob1, exp_item, null, null, null))) continue;
                    return TObject.BOOLEAN_FALSE;
                }
                return ret_val;
            }
            throw new Error("Unknown RHS of ALL.");
        }
    }

    static class AnyOperator
    extends Operator {
        static final long serialVersionUID = 6421321961221271735L;

        public AnyOperator(String op) {
            super(op, 8, 1);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (ob2.getTType() instanceof TQueryPlanType) {
                Operator rev_plain_op;
                Table t;
                QueryPlanNode plan = (QueryPlanNode)ob2.getObject();
                ArrayList list = plan.discoverCorrelatedVariables(1, new ArrayList());
                if (list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        ((CorrelatedVariable)list.get(i)).setFromResolver(resolver);
                    }
                    context.clearCache();
                }
                if ((t = plan.evaluate(context)).columnMatchesValue(0, rev_plain_op = this.getSubQueryForm(0).reverse(), ob1)) {
                    return TObject.BOOLEAN_TRUE;
                }
                return TObject.BOOLEAN_FALSE;
            }
            if (ob2.getTType() instanceof TArrayType) {
                Operator plain_op = this.getSubQueryForm(0);
                Expression[] exp_list = (Expression[])ob2.getObject();
                TObject ret_val = TObject.BOOLEAN_FALSE;
                for (int i = 0; i < exp_list.length; ++i) {
                    TObject exp_item = exp_list[i].evaluate(group, resolver, context);
                    if (exp_item.isNull()) {
                        ret_val = TObject.BOOLEAN_NULL;
                        continue;
                    }
                    if (!Operator.isTrue(plain_op.eval(ob1, exp_item, null, null, null))) continue;
                    return TObject.BOOLEAN_TRUE;
                }
                return ret_val;
            }
            throw new Error("Unknown RHS of ANY.");
        }
    }

    static class IsNotOperator
    extends Operator {
        static final long serialVersionUID = 1224184162192790982L;

        public IsNotOperator() {
            super("is not", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorIs(ob2).operatorNot();
        }
    }

    static class IsOperator
    extends Operator {
        static final long serialVersionUID = -5537856102106541908L;

        public IsOperator() {
            super("is", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorIs(ob2);
        }
    }

    static class LesserEqualOperator
    extends Operator {
        static final long serialVersionUID = 4298966494510169621L;

        public LesserEqualOperator() {
            super("<=", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorLessEquals(ob2);
        }
    }

    static class GreaterEqualOperator
    extends Operator {
        static final long serialVersionUID = 6040843932499067476L;

        public GreaterEqualOperator() {
            super(">=", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorGreaterEquals(ob2);
        }
    }

    static class LesserOperator
    extends Operator {
        static final long serialVersionUID = 2962736161551360032L;

        public LesserOperator() {
            super("<", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorLess(ob2);
        }
    }

    static class GreaterOperator
    extends Operator {
        static final long serialVersionUID = -6870425685250387549L;

        public GreaterOperator() {
            super(">", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorGreater(ob2);
        }
    }

    static class NotEqualOperator
    extends Operator {
        static final long serialVersionUID = 5868174826733282297L;

        public NotEqualOperator() {
            super("<>", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorNotEquals(ob2);
        }
    }

    static class EqualOperator
    extends Operator {
        static final long serialVersionUID = -5022271093834866261L;

        public EqualOperator() {
            super("=", 4);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorEquals(ob2);
        }
    }

    static class ConcatOperator
    extends Operator {
        public ConcatOperator() {
            super("||", 10);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorConcat(ob2);
        }
    }

    static class DivideOperator
    extends Operator {
        static final long serialVersionUID = -2695205152105036247L;

        public DivideOperator() {
            super("/", 20);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorDivide(ob2);
        }
    }

    static class MultiplyOperator
    extends Operator {
        static final long serialVersionUID = 8191233936463163847L;

        public MultiplyOperator() {
            super("*", 20);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorMultiply(ob2);
        }
    }

    static class SubtractOperator
    extends Operator {
        static final long serialVersionUID = 3035882496296296786L;

        public SubtractOperator() {
            super("-", 15);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorSubtract(ob2);
        }
    }

    static class AddOperator
    extends Operator {
        static final long serialVersionUID = 6995379384325694391L;

        public AddOperator() {
            super("+", 10);
        }

        public TObject eval(TObject ob1, TObject ob2, GroupResolver group, VariableResolver resolver, QueryContext context) {
            return ob1.operatorAdd(ob2);
        }
    }
}

