/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTable;
import com.mckoi.database.Lock;
import java.util.ArrayList;

final class LockingQueue {
    private DataTable parent_table;
    private ArrayList queue;

    LockingQueue(DataTable table) {
        this.parent_table = table;
        this.queue = new ArrayList();
    }

    DataTable getTable() {
        return this.parent_table;
    }

    synchronized void addLock(Lock lock) {
        this.queue.add(lock);
    }

    synchronized void removeLock(Lock lock) {
        this.queue.remove(lock);
        lock.getTable().notifyReleaseRWLock(lock.getType());
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAccess(Lock lock) {
        LockingQueue lockingQueue = this;
        synchronized (lockingQueue) {
            if (!this.queue.contains(lock)) {
                throw new Error("Queue does not contain the given lock");
            }
            if (lock.getType() == 0) {
                boolean blocked;
                do {
                    blocked = false;
                    int index = this.queue.indexOf(lock);
                    for (int i = index - 1; i >= 0 && !blocked; --i) {
                        Lock test_lock = (Lock)this.queue.get(i);
                        if (test_lock.getType() != 1) continue;
                        blocked = true;
                    }
                    if (!blocked) continue;
                    this.getTable().Debug().write(10, this, "Blocking on read.");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                } while (blocked);
            } else {
                boolean blocked;
                do {
                    blocked = false;
                    int index = this.queue.indexOf(lock);
                    if (index == 0) continue;
                    blocked = true;
                    this.getTable().Debug().write(10, this, "Blocking on write.");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                } while (blocked);
            }
            lock.getTable().notifyAddRWLock(lock.getType());
        }
    }

    public synchronized String toString() {
        StringBuffer str = new StringBuffer("[LockingQueue]: (");
        for (int i = 0; i < this.queue.size(); ++i) {
            str.append(this.queue.get(i));
            str.append(", ");
        }
        str.append(")");
        return new String(str);
    }
}

