/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTable;
import com.mckoi.database.Lock;
import com.mckoi.database.LockHandle;
import com.mckoi.database.LockingQueue;
import com.mckoi.debug.DebugLogger;
import java.util.HashMap;

public final class LockingMechanism {
    public static final int SHARED_MODE = 1;
    public static final int EXCLUSIVE_MODE = 2;
    private HashMap queues_map = new HashMap();
    private boolean in_exclusive_mode = false;
    private int shared_mode = 0;
    private final DebugLogger debug;

    public LockingMechanism(DebugLogger logger) {
        this.debug = logger;
    }

    private LockingQueue getQueueFor(DataTable table) {
        LockingQueue queue = (LockingQueue)this.queues_map.get(table);
        if (queue == null) {
            queue = new LockingQueue(table);
            this.queues_map.put(table, queue);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LockingMechanism lockingMechanism = this;
        synchronized (lockingMechanism) {
            if (!this.isInExclusiveMode()) {
                this.debug.writeException(new RuntimeException("Should not clear a LockingMechanism that's not in exclusive mode."));
            }
            this.queues_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHandle lockTables(DataTable[] t_write, DataTable[] t_read) {
        int lock_count = t_read.length + t_write.length;
        LockHandle handle = new LockHandle(lock_count, this.debug);
        LockingMechanism lockingMechanism = this;
        synchronized (lockingMechanism) {
            Lock lock;
            LockingQueue queue;
            int i;
            for (i = t_write.length - 1; i >= 0; --i) {
                DataTable to_write_lock = t_write[i];
                queue = this.getQueueFor(to_write_lock);
                lock = new Lock(1, queue, this.debug);
                handle.addLock(lock);
                this.debug.write(10, this, "[LockingMechanism] Locking for WRITE: " + to_write_lock.getTableName());
            }
            for (i = t_read.length - 1; i >= 0; --i) {
                DataTable to_read_lock = t_read[i];
                queue = this.getQueueFor(to_read_lock);
                lock = new Lock(0, queue, this.debug);
                handle.addLock(lock);
                this.debug.write(10, this, "[LockingMechanism] Locking for READ: " + to_read_lock.getTableName());
            }
        }
        this.debug.write(10, this, "Locked Tables");
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockTables(LockHandle handle) {
        LockingMechanism lockingMechanism = this;
        synchronized (lockingMechanism) {
            handle.unlockAll();
        }
        this.debug.write(10, this, "UnLocked Tables");
    }

    public synchronized boolean isInExclusiveMode() {
        return this.in_exclusive_mode;
    }

    public synchronized void setMode(int mode) {
        while (this.in_exclusive_mode) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (mode == 2) {
            this.in_exclusive_mode = true;
            while (this.shared_mode > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.debug.write(10, this, "Locked into ** EXCLUSIVE MODE **");
        } else if (mode == 1) {
            ++this.shared_mode;
            this.debug.write(10, this, "Locked into SHARED MODE");
        } else {
            throw new Error("Invalid mode");
        }
    }

    public synchronized void finishMode(int mode) {
        if (mode == 2) {
            this.in_exclusive_mode = false;
            this.notifyAll();
            this.debug.write(10, this, "UnLocked from ** EXCLUSIVE MODE **");
        } else if (mode == 1) {
            --this.shared_mode;
            if (this.shared_mode == 0 && this.in_exclusive_mode) {
                this.notifyAll();
            } else if (this.shared_mode < 0) {
                this.shared_mode = 0;
                this.notifyAll();
                throw new RuntimeException("Too many 'finishMode(SHARED_MODE)' calls");
            }
            this.debug.write(10, this, "UnLocked from SHARED MODE");
        } else {
            throw new Error("Invalid mode");
        }
    }
}

