/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTable;
import com.mckoi.database.Lock;
import com.mckoi.debug.DebugLogger;

public final class LockHandle {
    private Lock[] lock_list;
    private int lock_index;
    private boolean unlocked;
    private final DebugLogger debug;

    LockHandle(int lock_count, DebugLogger logger) {
        this.debug = logger;
        this.lock_list = new Lock[lock_count];
        this.lock_index = 0;
        this.unlocked = false;
    }

    void addLock(Lock lock) {
        this.lock_list[this.lock_index] = lock;
        ++this.lock_index;
    }

    void unlockAll() {
        if (!this.unlocked) {
            for (int i = this.lock_list.length - 1; i >= 0; --i) {
                this.lock_list[i].release();
            }
            this.unlocked = true;
        }
    }

    public void checkAccess(DataTable table, int access_type) {
        for (int i = this.lock_list.length - 1; i >= 0; --i) {
            Lock l = this.lock_list[i];
            if (l.getTable() != table) continue;
            l.checkAccess(access_type);
            return;
        }
        throw new RuntimeException("The given DataTable was not found in the lock list for this handle");
    }

    public void finalize() {
        if (!this.unlocked) {
            this.unlockAll();
            this.debug.write(40, this, "Finalize released a table lock - This indicates that there is a serious error.  Locks should only have a very short life span.  The 'unlockAll' method should have been called before finalization.  " + this.toString());
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer("LockHandle: ");
        for (int i = 0; i < this.lock_list.length; ++i) {
            str.append(this.lock_list[i].toString());
        }
        return new String(str);
    }
}

