/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.Expression;
import com.mckoi.database.TableName;
import java.io.Serializable;
import java.util.ArrayList;

public final class JoiningSet
implements Serializable,
Cloneable {
    static final long serialVersionUID = -380871062550922402L;
    public static final int INNER_JOIN = 1;
    public static final int LEFT_OUTER_JOIN = 2;
    public static final int RIGHT_OUTER_JOIN = 3;
    public static final int FULL_OUTER_JOIN = 4;
    private ArrayList join_set = new ArrayList();

    public void prepare(DatabaseConnection connection) {
    }

    public void addTable(TableName table_name) {
        this.join_set.add(table_name);
    }

    public void addPreviousJoin(int type, Expression on_expression) {
        this.join_set.add(this.join_set.size() - 1, new JoinPart(type, on_expression));
    }

    public void addJoin(int type, Expression on_expression) {
        this.join_set.add(new JoinPart(type, on_expression));
    }

    public void addJoin(int type) {
        this.join_set.add(new JoinPart(type));
    }

    public int getTableCount() {
        return (this.join_set.size() + 1) / 2;
    }

    public TableName getFirstTable() {
        return this.getTable(0);
    }

    public TableName getTable(int n) {
        return (TableName)this.join_set.get(n * 2);
    }

    private void setTable(int n, TableName table) {
        this.join_set.set(n * 2, table);
    }

    public int getJoinType(int n) {
        return ((JoinPart)this.join_set.get((int)(n * 2 + 1))).type;
    }

    public Expression getOnExpression(int n) {
        return ((JoinPart)this.join_set.get((int)(n * 2 + 1))).on_expression;
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList cloned_join_set;
        JoiningSet v = (JoiningSet)super.clone();
        int size = this.join_set.size();
        v.join_set = cloned_join_set = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object element = this.join_set.get(i);
            if (!(element instanceof TableName)) {
                if (element instanceof JoinPart) {
                    element = ((JoinPart)element).clone();
                } else {
                    throw new CloneNotSupportedException(element.getClass().toString());
                }
            }
            cloned_join_set.add(element);
        }
        return v;
    }

    public static class JoinPart
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = -1664565759669808084L;
        int type;
        Expression on_expression;

        public JoinPart(int type, Expression on_expression) {
            this.type = type;
            this.on_expression = on_expression;
        }

        public JoinPart(int type) {
            this(type, null);
        }

        public Object clone() throws CloneNotSupportedException {
            JoinPart v = (JoinPart)super.clone();
            if (this.on_expression != null) {
                v.on_expression = (Expression)this.on_expression.clone();
            }
            return v;
        }
    }
}

