/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.Database;
import com.mckoi.database.InsertSearch;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RootTable;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;
import java.io.PrintStream;

public abstract class JoinedTable
extends Table {
    protected Table[] reference_list;
    protected SelectableScheme[] column_scheme;
    protected int[] column_table;
    protected int[] column_filter;
    private int sorted_against_column = -1;
    private DataTableDef vt_table_def;
    private byte roots_locked;

    JoinedTable(Table[] tables) {
        this.init(tables);
    }

    JoinedTable(Table table) {
        Table[] tables = new Table[]{table};
        this.init(tables);
    }

    protected JoinedTable() {
    }

    protected void init(Table[] tables) {
        int table_count = tables.length;
        this.reference_list = tables;
        int col_count = this.getColumnCount();
        this.column_scheme = new SelectableScheme[col_count];
        this.vt_table_def = new DataTableDef();
        this.column_table = new int[col_count];
        this.column_filter = new int[col_count];
        int index = 0;
        for (int i = 0; i < this.reference_list.length; ++i) {
            Table cur_table = this.reference_list[i];
            DataTableDef cur_table_def = cur_table.getDataTableDef();
            int ref_col_count = cur_table.getColumnCount();
            for (int n = 0; n < ref_col_count; ++n) {
                this.column_filter[index] = n;
                this.column_table[index] = i;
                ++index;
                this.vt_table_def.addVirtualColumn(new DataTableColumnDef(cur_table_def.columnAt(n)));
            }
        }
        this.vt_table_def.setTableName(new TableName(null, "#VIRTUAL TABLE#"));
        this.vt_table_def.setImmutable();
    }

    private IntegerVector calculateRowReferenceList() {
        int size = this.getRowCount();
        IntegerVector all_list = new IntegerVector(size);
        for (int i = 0; i < size; ++i) {
            all_list.addInt(i);
        }
        return all_list;
    }

    public Database getDatabase() {
        return this.reference_list[0].getDatabase();
    }

    public int getColumnCount() {
        int column_count_sum = 0;
        for (int i = 0; i < this.reference_list.length; ++i) {
            column_count_sum += this.reference_list[i].getColumnCount();
        }
        return column_count_sum;
    }

    public int findFieldName(Variable v) {
        int col_index = 0;
        for (int i = 0; i < this.reference_list.length; ++i) {
            int col = this.reference_list[i].findFieldName(v);
            if (col != -1) {
                return col + col_index;
            }
            col_index += this.reference_list[i].getColumnCount();
        }
        return -1;
    }

    public final Variable getResolvedVariable(int column) {
        Table parent_table = this.reference_list[this.column_table[column]];
        return parent_table.getResolvedVariable(this.column_filter[column]);
    }

    protected final Table[] getReferenceTables() {
        return this.reference_list;
    }

    void optimisedPostSet(int column) {
        this.sorted_against_column = column;
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        SelectableScheme ss;
        SelectableScheme scheme = this.column_scheme[column];
        if (scheme != null) {
            if (table == this) {
                return scheme;
            }
            return scheme.getSubsetScheme(table, original_column);
        }
        if (this.sorted_against_column != -1 && this.sorted_against_column == column) {
            InsertSearch isop = new InsertSearch((TableDataSource)this, column, this.calculateRowReferenceList());
            isop.RECORD_UID = false;
            this.column_scheme[column] = ss = isop;
            if (table != this) {
                ss = ss.getSubsetScheme(table, original_column);
            }
        } else {
            Table parent_table = this.reference_list[this.column_table[column]];
            ss = parent_table.getSelectableSchemeFor(this.column_filter[column], original_column, table);
            if (table == this) {
                this.column_scheme[column] = ss;
            }
        }
        return ss;
    }

    void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        if (ancestor == this) {
            return;
        }
        int table_num = this.column_table[column];
        Table parent_table = this.reference_list[table_num];
        this.resolveAllRowsForTableAt(row_set, table_num);
        parent_table.setToRowTableDomain(this.column_filter[column], row_set, ancestor);
    }

    RawTableInformation resolveToRawTable(RawTableInformation info, IntegerVector row_set) {
        if (this instanceof RootTable) {
            info.add((RootTable)((Object)this), this.calculateRowReferenceList());
        } else {
            for (int i = 0; i < this.reference_list.length; ++i) {
                IntegerVector new_row_set = new IntegerVector(row_set);
                this.resolveAllRowsForTableAt(new_row_set, i);
                Table table = this.reference_list[i];
                if (table instanceof RootTable) {
                    info.add((RootTable)((Object)table), new_row_set);
                    continue;
                }
                ((JoinedTable)table).resolveToRawTable(info, new_row_set);
            }
        }
        return info;
    }

    RawTableInformation resolveToRawTable(RawTableInformation info) {
        IntegerVector all_list = new IntegerVector();
        int size = this.getRowCount();
        for (int i = 0; i < size; ++i) {
            all_list.addInt(i);
        }
        return this.resolveToRawTable(info, all_list);
    }

    public DataTableDef getDataTableDef() {
        return this.vt_table_def;
    }

    public TObject getCellContents(int column, int row) {
        int table_num = this.column_table[column];
        Table parent_table = this.reference_list[table_num];
        row = this.resolveRowForTableAt(row, table_num);
        return parent_table.getCellContents(this.column_filter[column], row);
    }

    public RowEnumeration rowEnumeration() {
        return new SimpleRowEnumeration(this.getRowCount());
    }

    void addDataTableListener(DataTableListener listener) {
        for (int i = 0; i < this.reference_list.length; ++i) {
            this.reference_list[i].addDataTableListener(listener);
        }
    }

    void removeDataTableListener(DataTableListener listener) {
        for (int i = 0; i < this.reference_list.length; ++i) {
            this.reference_list[i].removeDataTableListener(listener);
        }
    }

    public void lockRoot(int lock_key) {
        this.roots_locked = (byte)(this.roots_locked + 1);
        for (int i = 0; i < this.reference_list.length; ++i) {
            this.reference_list[i].lockRoot(lock_key);
        }
    }

    public void unlockRoot(int lock_key) {
        this.roots_locked = (byte)(this.roots_locked - 1);
        for (int i = 0; i < this.reference_list.length; ++i) {
            this.reference_list[i].unlockRoot(lock_key);
        }
    }

    public boolean hasRootsLocked() {
        return this.roots_locked != 0;
    }

    public void printGraph(PrintStream out, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println("JT[" + this.getClass());
        for (i = 0; i < this.reference_list.length; ++i) {
            this.reference_list[i].printGraph(out, indent + 2);
        }
        for (i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println("]");
    }

    protected abstract int resolveRowForTableAt(int var1, int var2);

    protected abstract void resolveAllRowsForTableAt(IntegerVector var1, int var2);
}

