/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlindSearch;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.MasterTableJournal;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TransactionSystem;

abstract class GTDataSource
implements MutableTableDataSource {
    private TransactionSystem system;

    public GTDataSource(TransactionSystem system) {
        this.system = system;
    }

    protected TObject columnValue(int column, Object ob) {
        TType type = this.getDataTableDef().columnAt(column).getTType();
        return new TObject(type, ob);
    }

    public TransactionSystem getSystem() {
        return this.system;
    }

    public abstract DataTableDef getDataTableDef();

    public abstract int getRowCount();

    public RowEnumeration rowEnumeration() {
        return new SimpleRowEnumeration(this.getRowCount());
    }

    public SelectableScheme getColumnScheme(int column) {
        return new BlindSearch(this, column);
    }

    public abstract TObject getCellContents(int var1, int var2);

    public int addRow(RowData row_data) {
        throw new RuntimeException("Functionality not available.");
    }

    public void removeRow(int row_index) {
        throw new RuntimeException("Functionality not available.");
    }

    public int updateRow(int row_index, RowData row_data) {
        throw new RuntimeException("Functionality not available.");
    }

    public MasterTableJournal getJournal() {
        throw new RuntimeException("Functionality not available.");
    }

    public void flushIndexChanges() {
        throw new RuntimeException("Functionality not available.");
    }

    public void constraintIntegrityCheck() {
        throw new RuntimeException("Functionality not available.");
    }

    public void dispose() {
    }

    public void addRootLock() {
    }

    public void removeRootLock() {
    }

    protected static DataTableColumnDef stringColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setNotNull(true);
        column.setSQLType(12);
        column.setSize(Integer.MAX_VALUE);
        column.setScale(-1);
        column.setIndexScheme("BlindSearch");
        column.initTTypeInfo();
        return column;
    }

    protected static DataTableColumnDef booleanColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setNotNull(true);
        column.setSQLType(-7);
        column.setSize(-1);
        column.setScale(-1);
        column.setIndexScheme("BlindSearch");
        column.initTTypeInfo();
        return column;
    }

    protected static DataTableColumnDef numericColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setNotNull(true);
        column.setSQLType(2);
        column.setSize(-1);
        column.setScale(-1);
        column.setIndexScheme("BlindSearch");
        column.initTTypeInfo();
        return column;
    }

    protected static DataTableColumnDef dateColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setNotNull(true);
        column.setSQLType(93);
        column.setSize(-1);
        column.setScale(-1);
        column.setIndexScheme("BlindSearch");
        column.initTTypeInfo();
        return column;
    }
}

