/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Expression;
import com.mckoi.database.Function;
import com.mckoi.database.FunctionDef;
import com.mckoi.database.FunctionInfo;
import com.mckoi.database.FunctionLookup;
import com.mckoi.database.TObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class FunctionFactory
implements FunctionLookup {
    private static final Expression GLOB_EXPRESSION = new Expression();
    public static final Expression[] GLOB_LIST;
    private HashMap fun_class_mapping = new HashMap();
    private Class[] construct_proto = new Class[1];

    public FunctionFactory() {
        Object exp_arr_ob = Array.newInstance(new Expression().getClass(), 0);
        this.construct_proto[0] = exp_arr_ob.getClass();
    }

    protected void addFunction(String fun_name, Class fun_class, int fun_type) {
        try {
            String lf_name = fun_name.toLowerCase();
            if (this.fun_class_mapping.get(lf_name) != null) {
                throw new Error("Function '" + fun_name + "' already defined in factory.");
            }
            FF_FunctionInfo ff_info = new FF_FunctionInfo(fun_name, fun_type, fun_class.getConstructor(this.construct_proto));
            this.fun_class_mapping.put(lf_name, ff_info);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void addFunction(String fun_name, Class fun_class) {
        this.addFunction(fun_name, fun_class, 1);
    }

    protected void removeFunction(String fun_name) {
        String lf_name = fun_name.toLowerCase();
        if (this.fun_class_mapping.get(lf_name) == null) {
            throw new Error("Function '" + lf_name + "' is not defined in this factory.");
        }
        this.fun_class_mapping.remove(fun_name.toLowerCase());
    }

    protected boolean functionDefined(String fun_name) {
        String lf_name = fun_name.toLowerCase();
        return this.fun_class_mapping.get(lf_name) != null;
    }

    public abstract void init();

    public Function generateFunction(FunctionDef function_def) {
        String func_name = function_def.getName();
        Expression[] params = function_def.getParameters();
        FF_FunctionInfo ff_info = (FF_FunctionInfo)this.fun_class_mapping.get(func_name.toLowerCase());
        if (ff_info == null) {
            return null;
        }
        Constructor fun_constructor = ff_info.getConstructor();
        Object[] args = new Object[]{params};
        try {
            return (Function)fun_constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isAggregate(FunctionDef function_def) {
        FunctionInfo f_info = this.getFunctionInfo(function_def.getName());
        if (f_info == null) {
            return false;
        }
        return f_info.getType() == 2;
    }

    public FunctionInfo getFunctionInfo(String fun_name) {
        FF_FunctionInfo ff_info = (FF_FunctionInfo)this.fun_class_mapping.get(fun_name.toLowerCase());
        return ff_info;
    }

    public FunctionInfo[] getAllFunctionInfo() {
        Set keys = this.fun_class_mapping.keySet();
        int list_size = keys.size();
        FunctionInfo[] list = new FunctionInfo[list_size];
        Iterator i = keys.iterator();
        int n = 0;
        while (i.hasNext()) {
            String fun_name = (String)i.next();
            list[n] = this.getFunctionInfo(fun_name);
            ++n;
        }
        return list;
    }

    static {
        GLOB_EXPRESSION.addElement(TObject.stringVal("*"));
        GLOB_EXPRESSION.text().append("*");
        GLOB_LIST = new Expression[]{GLOB_EXPRESSION};
    }

    protected class FF_FunctionInfo
    implements FunctionInfo {
        private String name;
        private int type;
        private Constructor constructor;

        public FF_FunctionInfo(String name, int type, Constructor constructor) {
            this.name = name;
            this.type = type;
            this.constructor = constructor;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public String getFunctionFactoryName() {
            return FunctionFactory.this.getClass().toString();
        }
    }
}

