/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Expression;
import com.mckoi.database.Function;
import com.mckoi.database.FunctionLookup;
import com.mckoi.database.QueryContext;
import com.mckoi.database.StatementException;
import java.io.Serializable;

public final class FunctionDef
implements Serializable,
Cloneable {
    static final long serialVersionUID = 3339781003247956829L;
    private String name;
    private Expression[] params;
    private transient Function cached_function;

    public FunctionDef(String name, Expression[] params) {
        this.name = name;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Expression[] getParameters() {
        return this.params;
    }

    public boolean isAggregate(QueryContext context) {
        FunctionLookup fun_lookup = context.getFunctionLookup();
        boolean is_aggregate = fun_lookup.isAggregate(this);
        if (is_aggregate) {
            return true;
        }
        Expression[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            is_aggregate = params[i].hasAggregateFunction(context);
            if (!is_aggregate) continue;
            return true;
        }
        return false;
    }

    public Function getFunction(QueryContext context) {
        if (this.cached_function != null) {
            return this.cached_function;
        }
        FunctionLookup lookup = context.getFunctionLookup();
        this.cached_function = lookup.generateFunction(this);
        if (this.cached_function == null) {
            throw new StatementException("Function '" + this.getName() + "' doesn't exist.");
        }
        return this.cached_function;
    }

    public Object clone() throws CloneNotSupportedException {
        FunctionDef v = (FunctionDef)super.clone();
        Expression[] exps = (Expression[])v.params.clone();
        for (int n = 0; n < exps.length; ++n) {
            exps[n] = (Expression)exps[n].clone();
        }
        v.params = exps;
        v.cached_function = null;
        return v;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append('(');
        for (int i = 0; i < this.params.length; ++i) {
            buf.append(this.params[i].text().toString());
            if (i >= this.params.length - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        return new String(buf);
    }
}

