/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TransactionSystem;
import java.util.ArrayList;
import java.util.Collections;

class DatabaseDispatcher
extends Thread {
    private ArrayList event_queue = new ArrayList();
    private TransactionSystem system;
    private boolean finished;

    DatabaseDispatcher(TransactionSystem system) {
        this.system = system;
        this.setDaemon(true);
        this.setName("Mckoi - Database Dispatcher");
        this.finished = false;
        this.start();
    }

    Object createEvent(Runnable runnable) {
        return new DatabaseEvent(runnable);
    }

    synchronized void postEvent(int time_to_wait, Object event) {
        DatabaseEvent evt = (DatabaseEvent)event;
        this.event_queue.remove(event);
        evt.time_to_run_event = System.currentTimeMillis() + (long)time_to_wait;
        int index = Collections.binarySearch(this.event_queue, event);
        if (index < 0) {
            index = -(index + 1);
        }
        this.event_queue.add(index, event);
        this.notifyAll();
    }

    synchronized void finish() {
        this.finished = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    DatabaseEvent evt = null;
                    DatabaseDispatcher databaseDispatcher = this;
                    synchronized (databaseDispatcher) {
                        while (evt == null) {
                            if (this.finished) {
                                return;
                            }
                            if (this.event_queue.size() > 0) {
                                evt = (DatabaseEvent)this.event_queue.get(0);
                                long diff = evt.time_to_run_event - System.currentTimeMillis();
                                if (diff < 0L) continue;
                                evt = null;
                                this.wait((int)diff);
                                continue;
                            }
                            this.wait();
                        }
                        this.event_queue.remove(0);
                    }
                    evt.runnable.run();
                }
            }
            catch (Throwable e) {
                this.system.Debug().write(40, this, "SystemDispatchThread error");
                this.system.Debug().writeException(e);
                continue;
            }
            break;
        }
    }

    class DatabaseEvent
    implements Comparable {
        private long time_to_run_event;
        private Runnable runnable;

        DatabaseEvent(Runnable runnable) {
            this.runnable = runnable;
        }

        public int compareTo(Object ob) {
            DatabaseEvent evt2 = (DatabaseEvent)ob;
            long dif = this.time_to_run_event - evt2.time_to_run_event;
            if (dif > 0L) {
                return 1;
            }
            if (dif < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

