/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Assignment;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DefaultDataTable;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.ReferenceTable;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableModificationEvent;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.IntegerVector;

public final class DataTable
extends DefaultDataTable {
    private DatabaseConnection connection;
    private MutableTableDataSource data_source;
    static final boolean LOCK_DEBUG = true;
    private int debug_read_lock_count = 0;
    private int debug_write_lock_count = 0;

    DataTable(DatabaseConnection connection, MutableTableDataSource data_source) throws DatabaseException {
        super(connection.getDatabase());
        this.connection = connection;
        this.data_source = data_source;
    }

    public final DebugLogger Debug() {
        return this.connection.getSystem().Debug();
    }

    protected void blankSelectableSchemes(int type) {
    }

    protected SelectableScheme getRootColumnScheme(int column) {
        this.checkReadLock();
        return this.data_source.getColumnScheme(column);
    }

    public ReferenceTable declareAs(TableName new_name) {
        return new ReferenceTable((Table)this, new_name);
    }

    public final RowData createRowDataObject(QueryContext context) {
        this.checkSafeOperation();
        return new RowData(this);
    }

    public int getRowCount() {
        this.checkReadLock();
        return this.data_source.getRowCount();
    }

    public final void add(RowData row_data) throws DatabaseException {
        this.checkReadWriteLock();
        if (!row_data.isSameTable(this)) {
            throw new DatabaseException("Internal Error: Using RowData from different table");
        }
        this.addRow(row_data);
        this.data_source.constraintIntegrityCheck();
    }

    public final void add(RowData[] row_data_arr) throws DatabaseException {
        this.checkReadWriteLock();
        for (int i = 0; i < row_data_arr.length; ++i) {
            RowData row_data = row_data_arr[i];
            if (!row_data.isSameTable(this)) {
                throw new DatabaseException("Internal Error: Using RowData from different table");
            }
            this.addRow(row_data);
        }
        this.data_source.constraintIntegrityCheck();
    }

    private void addRow(RowData row) throws DatabaseException {
        TableName table_name = this.getTableName();
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row, true));
        int row_number = this.data_source.addRow(row);
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row, false));
    }

    private void removeRow(int row_number) throws DatabaseException {
        TableName table_name = this.getTableName();
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row_number, true));
        this.data_source.removeRow(row_number);
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row_number, false));
    }

    private void updateRow(int row_number, RowData row) throws DatabaseException {
        TableName table_name = this.getTableName();
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row_number, row, true));
        this.data_source.updateRow(row_number, row);
        this.connection.fireTableEvent(new TableModificationEvent(this.connection, table_name, row_number, row, false));
    }

    public int delete(Table table, int limit) throws DatabaseException {
        this.checkReadWriteLock();
        IntegerVector row_set = new IntegerVector(table.getRowCount());
        RowEnumeration e = table.rowEnumeration();
        while (e.hasMoreRows()) {
            row_set.addInt(e.nextRowIndex());
        }
        e = null;
        int first_column = table.findFieldName(this.getResolvedVariable(0));
        if (first_column == -1) {
            throw new DatabaseException("Search table does not contain any reference to table being deleted from");
        }
        table.setToRowTableDomain(first_column, row_set, this);
        row_set.quickSort();
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        int len = Math.min(row_set.size(), limit);
        int last_removed = -1;
        int remove_count = 0;
        for (int i = 0; i < len; ++i) {
            int to_remove = row_set.intAt(i);
            if (to_remove < last_removed) {
                throw new DatabaseException("Internal error: row sorting error or row_set not in the range > 0");
            }
            if (to_remove == last_removed) continue;
            this.removeRow(to_remove);
            last_removed = to_remove;
            ++remove_count;
        }
        if (remove_count > 0) {
            this.data_source.constraintIntegrityCheck();
        }
        return remove_count;
    }

    public int delete(Table table) throws DatabaseException {
        return this.delete(table, -1);
    }

    public final int update(QueryContext context, Table table, Assignment[] assign_list, int limit) throws DatabaseException {
        this.checkReadWriteLock();
        IntegerVector row_set = new IntegerVector();
        RowEnumeration e = table.rowEnumeration();
        while (e.hasMoreRows()) {
            row_set.addInt(e.nextRowIndex());
        }
        e = null;
        int first_column = table.findFieldName(this.getResolvedVariable(0));
        if (first_column == -1) {
            throw new DatabaseException("Search table does not contain any reference to table being updated from");
        }
        table.setToRowTableDomain(first_column, row_set, this);
        RowData original_data = this.createRowDataObject(context);
        RowData row_data = this.createRowDataObject(context);
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        int len = Math.min(row_set.size(), limit);
        int update_count = 0;
        for (int i = 0; i < len; ++i) {
            int to_update = row_set.intAt(i);
            original_data.setFromRow(to_update);
            row_data.setFromRow(to_update);
            for (int n = 0; n < assign_list.length; ++n) {
                Assignment assignment = assign_list[n];
                row_data.evaluate(assignment, context);
            }
            this.updateRow(to_update, row_data);
            ++update_count;
        }
        if (update_count > 0) {
            this.data_source.constraintIntegrityCheck();
        }
        return update_count;
    }

    public DataTableDef getDataTableDef() {
        this.checkSafeOperation();
        return this.data_source.getDataTableDef();
    }

    public String getSchema() {
        this.checkSafeOperation();
        return this.getDataTableDef().getSchema();
    }

    public void addDataTableListener(DataTableListener listener) {
    }

    public void removeDataTableListener(DataTableListener listener) {
    }

    void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        this.checkReadLock();
        if (ancestor != this && ancestor != this.data_source) {
            throw new RuntimeException("Method routed to incorrect table ancestor.");
        }
    }

    public TObject getCellContents(int column, int row) {
        this.checkSafeOperation();
        return this.data_source.getCellContents(column, row);
    }

    public RowEnumeration rowEnumeration() {
        this.checkReadLock();
        return this.data_source.rowEnumeration();
    }

    public void lockRoot(int lock_key) {
        this.checkSafeOperation();
        this.data_source.addRootLock();
    }

    public void unlockRoot(int lock_key) {
        this.checkSafeOperation();
        this.data_source.removeRootLock();
    }

    public boolean hasRootsLocked() {
        throw new Error("hasRootsLocked is deprecated.");
    }

    final void notifyAddRWLock(int lock_type) {
        if (lock_type == 0) {
            ++this.debug_read_lock_count;
        } else if (lock_type == 1) {
            ++this.debug_write_lock_count;
            if (this.debug_write_lock_count > 1) {
                throw new Error(">1 write lock on table " + this.getTableName());
            }
        } else {
            throw new Error("Unknown lock type: " + lock_type);
        }
    }

    final void notifyReleaseRWLock(int lock_type) {
        if (lock_type == 0) {
            --this.debug_read_lock_count;
        } else if (lock_type == 1) {
            --this.debug_write_lock_count;
        } else {
            this.Debug().writeException(new RuntimeException("Unknown lock type: " + lock_type));
        }
    }

    private boolean isInExclusiveMode() {
        return this.connection.getLockingMechanism().isInExclusiveMode();
    }

    private void checkInExclusiveMode() {
        if (!this.isInExclusiveMode()) {
            this.Debug().writeException(new RuntimeException("Performed exclusive operation on table and not in exclusive mode!"));
        }
    }

    private void checkReadLock() {
        boolean is_internal_table = this.getTableName().getSchema().equals("SYS_INFO");
        if (!is_internal_table && this.debug_read_lock_count <= 0 && this.debug_write_lock_count <= 0 && !this.isInExclusiveMode()) {
            System.err.println();
            System.err.print(" is_internal_table = " + is_internal_table);
            System.err.print(" debug_read_lock_count = " + this.debug_read_lock_count);
            System.err.print(" debug_write_lock_count = " + this.debug_write_lock_count);
            System.err.println(" isInExclusiveMode = " + this.isInExclusiveMode());
            this.Debug().writeException(new Error("Invalid read access on table '" + this.getTableName() + "'"));
        }
    }

    private void checkReadWriteLock() {
        if (this.debug_write_lock_count != 1 && !this.isInExclusiveMode()) {
            this.Debug().writeException(new Error("Invalid read/write access on table '" + this.getTableName() + "'"));
        }
    }

    private void checkSafeOperation() {
    }

    public int getColumnCount() {
        this.checkSafeOperation();
        return super.getColumnCount();
    }

    public Variable getResolvedVariable(int column) {
        this.checkSafeOperation();
        return super.getResolvedVariable(column);
    }

    public int findFieldName(Variable v) {
        this.checkSafeOperation();
        return super.findFieldName(v);
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        this.checkReadLock();
        return super.getSelectableSchemeFor(column, original_column, table);
    }

    RawTableInformation resolveToRawTable(RawTableInformation info) {
        this.checkReadLock();
        return super.resolveToRawTable(info);
    }
}

