/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CellInput;
import com.mckoi.database.TBinaryType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TDateType;
import com.mckoi.database.TJavaObjectType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TObject;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.util.BigNumber;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class DataCellSerialization
extends ByteArrayOutputStream
implements CellInput {
    private Deflater deflater;
    private Inflater inflater;
    private byte[] compress_buf;
    private int compress_length;
    private boolean use_compressed;
    private short type;
    private boolean is_null;
    private char[] char_buffer;
    private static final ByteLongObject EMPTY_BYTE_LONG_OBJECT = new ByteLongObject(new byte[0]);

    DataCellSerialization() {
        super(1024);
    }

    int skipSerialization(CellInput din) throws IOException {
        int len = din.readInt();
        return len - 4;
    }

    Object readSerialization(CellInput din) throws IOException {
        this.count = 0;
        int len = din.readInt();
        short s = din.readShort();
        this.type = (short)(s & 0xFFF);
        this.is_null = (s & 0x2000) != 0;
        boolean bl = this.use_compressed = (s & 0x4000) != 0;
        if (this.use_compressed) {
            int uncompressed_len = din.readInt();
            if (this.buf.length < uncompressed_len) {
                this.buf = new byte[uncompressed_len];
            }
            this.compress_length = len - 4 - 2 - 4;
            if (this.compress_buf == null || this.compress_buf.length < this.compress_length) {
                this.compress_buf = new byte[this.compress_length];
            }
            din.readFully(this.compress_buf, 0, this.compress_length);
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
            this.inflater.reset();
            this.inflater.setInput(this.compress_buf, 0, this.compress_length);
            try {
                int inflate_count = this.inflater.inflate(this.buf, 0, uncompressed_len);
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e.getMessage());
            }
            din = this;
        }
        return this.readFromCellInput(din);
    }

    private BigNumber createBigNumber(byte[] buf, int scale, byte state) {
        return BigNumber.fromData(buf, scale, state);
    }

    private Object readFromCellInput(CellInput din) throws IOException {
        if (this.is_null) {
            return null;
        }
        if (this.type == 2) {
            short scale = din.readShort();
            int num_len = din.readInt();
            byte[] buf = new byte[num_len];
            din.readFully(buf, 0, num_len);
            return this.createBigNumber(buf, scale, (byte)0);
        }
        if (this.type == 8) {
            byte state = din.readByte();
            short scale = din.readShort();
            int num_len = din.readInt();
            byte[] buf = new byte[num_len];
            din.readFully(buf, 0, num_len);
            return this.createBigNumber(buf, scale, state);
        }
        if (this.type == 1) {
            int str_length = din.readInt();
            if (str_length == 0) {
                return "";
            }
            String dastr = din.readChars(str_length);
            return dastr.intern();
        }
        if (this.type == 5) {
            if (din.readByte() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (this.type == 3) {
            return new Date(din.readLong());
        }
        if (this.type == 6) {
            int blob_length = din.readInt();
            if (blob_length == 0) {
                return EMPTY_BYTE_LONG_OBJECT;
            }
            byte[] buf = new byte[blob_length];
            din.readFully(buf, 0, blob_length);
            return new ByteLongObject(buf);
        }
        if (this.type == 7) {
            int blob_length = din.readInt();
            byte[] buf = new byte[blob_length];
            din.readFully(buf, 0, blob_length);
            return new ByteLongObject(buf);
        }
        throw new Error("Don't understand type: " + this.type);
    }

    void writeSerialization(DataOutputStream out) throws IOException {
        int len = this.use_compressed ? this.compress_length + 4 : this.count;
        out.writeInt(len += 6);
        short s = this.type;
        if (this.is_null) {
            s = (short)(s | 0x2000);
        }
        if (this.use_compressed) {
            s = (short)(s | 0x4000);
        }
        out.writeShort(s);
        if (this.use_compressed) {
            out.writeInt(this.count);
            out.write(this.compress_buf, 0, this.compress_length);
        } else {
            out.write(this.buf, 0, this.count);
        }
    }

    void setToSerialize(TObject cell) throws IOException {
        int length;
        this.is_null = false;
        this.count = 0;
        this.use_compressed = false;
        TType ttype = cell.getTType();
        if (ttype instanceof TStringType) {
            this.type = 1;
        } else if (ttype instanceof TNumericType) {
            this.type = (short)8;
        } else if (ttype instanceof TBooleanType) {
            this.type = (short)5;
        } else if (ttype instanceof TDateType) {
            this.type = (short)3;
        } else if (ttype instanceof TBinaryType) {
            this.type = (short)6;
        } else if (ttype instanceof TJavaObjectType) {
            this.type = (short)7;
        } else {
            throw new Error("Couldn't handle type: " + ttype.getClass());
        }
        if (cell.isNull()) {
            this.is_null = true;
            return;
        }
        Object ob = cell.getObject();
        this.writeToBuffer(cell);
        TType type = cell.getTType();
        if ((type instanceof TStringType || type instanceof TBinaryType || type instanceof TJavaObjectType) && (length = this.count) > 150) {
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
            this.deflater.setInput(this.buf, 0, length);
            this.deflater.finish();
            if (this.compress_buf == null || this.compress_buf.length < length) {
                this.compress_buf = new byte[length];
            }
            this.compress_length = this.deflater.deflate(this.compress_buf);
            this.deflater.reset();
            if (this.compress_length < length) {
                this.use_compressed = true;
            }
        }
    }

    private void writeToBuffer(TObject cell) throws IOException {
        Object ob = cell.getObject();
        if (ob instanceof BigNumber) {
            BigNumber ddc = (BigNumber)ob;
            byte[] buf = ddc.toByteArray();
            this.writeByte(ddc.getState());
            this.writeShort((short)ddc.getScale());
            this.writeInt(buf.length);
            this.write(buf);
        } else if (ob instanceof String) {
            String str = (String)ob;
            this.writeInt(str.length());
            this.writeChars(str);
        } else if (ob instanceof Boolean) {
            Boolean bool = (Boolean)ob;
            this.writeByte((byte)(bool != false ? 1 : 0));
        } else if (ob instanceof Date) {
            Date date = (Date)ob;
            this.writeLong(date.getTime());
        } else if (ob instanceof ByteLongObject) {
            ByteLongObject blob = (ByteLongObject)ob;
            this.writeInt(blob.length());
            this.write(blob.getByteArray());
        } else {
            throw new Error("Don't know how to serialize class " + ob.getClass());
        }
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public int read() throws IOException {
        return this.buf[this.count++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.count, b, off, len);
        this.count += len;
        return len;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        this.count = (int)((long)this.count + n);
        return n;
    }

    public int available() throws IOException {
        throw new Error("Not supported");
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new Error("Not supported");
    }

    public void close() throws IOException {
        throw new Error("Not supported");
    }

    public void readFully(byte[] b) throws IOException {
        this.read(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public String readChars(int length) throws IOException {
        if (length <= 8192) {
            if (this.char_buffer == null) {
                this.char_buffer = new char[8192];
            }
            for (int i = 0; i < length; ++i) {
                this.char_buffer[i] = this.readChar();
            }
            return new String(this.char_buffer, 0, length);
        }
        StringBuffer chrs = new StringBuffer(length);
        for (int i = length; i > 0; --i) {
            chrs.append(this.readChar());
        }
        return new String(chrs);
    }

    public int readInt() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new Error("Not implemented.");
    }

    public String readUTF() throws IOException {
        throw new Error("Not implemented.");
    }
}

