/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.FixedSizeDataStore;
import com.mckoi.database.IndexSet;
import com.mckoi.database.IndexStore;
import com.mckoi.database.MasterTableJournal;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.ByteArrayUtil;
import com.mckoi.util.IntegerListInterface;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class ConvertUtils {
    ConvertUtils() {
    }

    static ArrayList convertIndexFiles1(File original_ijf, IndexStore new_store, DataTableDef table_def, DebugLogger logger) throws IOException {
        int column_count = table_def.columnCount();
        FixedSizeDataStore ijf = new FixedSizeDataStore(original_ijf, -1, false, logger);
        ijf.open(false);
        int block_size = 1024;
        if (table_def.getTableName().getSchema().equals("SYS_INFO")) {
            block_size = 128;
        }
        new_store.create(block_size);
        new_store.init();
        new_store.addIndexLists(column_count + 1, (byte)1);
        new_store.flush();
        IndexSet index_set = new_store.getSnapshotIndexSet();
        int header_size = 16 + column_count * 4;
        byte[] index_header_data = new byte[header_size];
        byte[] reserved_header = new byte[64];
        ijf.readReservedBuffer(reserved_header, 0, 64);
        long unique_id = ByteArrayUtil.getLong(reserved_header, 8);
        int cur_header_sector = ByteArrayUtil.getInt(reserved_header, 0);
        ijf.readAcross(cur_header_sector, index_header_data, 0, index_header_data.length);
        int mast_index_sector = ByteArrayUtil.getInt(index_header_data, 8);
        InputStream sin = ijf.getSectorInputStream(mast_index_sector);
        DataInputStream din = new DataInputStream(sin);
        int ver = din.readInt();
        if (ver != 1) {
            throw new IOException("Unrecognised master index list version.");
        }
        IntegerListInterface master_index = index_set.getIndex(0);
        int entries_count = din.readInt();
        int previous = -1;
        for (int i = 0; i < entries_count; ++i) {
            int entry = din.readInt();
            if (entry == previous) {
                throw new IOException("Master index format corrupt - double entry.");
            }
            if (entry < previous) {
                throw new IOException("Master index format corrupt - not sorted.");
            }
            master_index.add(entry);
        }
        din.close();
        int journal_sector = ByteArrayUtil.getInt(index_header_data, 12);
        sin = ijf.getSectorInputStream(journal_sector);
        din = new DataInputStream(sin);
        ver = din.readInt();
        if (ver != 1) {
            throw new Error("Unrecognised journals list version.");
        }
        ArrayList<MasterTableJournal> transaction_mod_list = new ArrayList<MasterTableJournal>();
        int num_journals = din.readInt();
        for (int i = 0; i < num_journals; ++i) {
            MasterTableJournal journal = new MasterTableJournal();
            journal.readFrom(din);
            transaction_mod_list.add(journal);
        }
        din.close();
        IntegerListInterface[] column_indices = new IntegerListInterface[column_count];
        for (int column = 0; column < column_count; ++column) {
            if (!table_def.columnAt(column).isIndexableType()) continue;
            int scheme_sector = ByteArrayUtil.getInt(index_header_data, 16 + column * 4);
            sin = ijf.getSectorInputStream(scheme_sector);
            din = new DataInputStream(sin);
            byte t = (byte)din.read();
            if (t == 1) {
                IntegerListInterface col_index;
                column_indices[column] = col_index = index_set.getIndex(column + 1);
                int vec_size = din.readInt();
                for (int i = 0; i < vec_size; ++i) {
                    int row = din.readInt();
                    col_index.add(row);
                }
            }
            din.close();
        }
        new_store.commitIndexSet(index_set);
        index_set.dispose();
        new_store.setUniqueID(unique_id);
        new_store.flush();
        new_store.hardSynch();
        ijf.close();
        ijf.delete();
        return transaction_mod_list;
    }
}

