/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlindSearch;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.Database;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RootTable;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;

public class CompositeTable
extends Table
implements RootTable {
    public static int UNION = 1;
    public static int INTERSECT = 2;
    public static int EXCEPT = 3;
    private Table master_table;
    private Table[] composite_tables;
    private IntegerVector[] table_indexes;
    private SelectableScheme[] column_scheme;
    private int roots_locked;

    public CompositeTable(Table master_table, Table[] composite_list) {
        this.master_table = master_table;
        this.composite_tables = composite_list;
        this.column_scheme = new SelectableScheme[master_table.getColumnCount()];
    }

    public CompositeTable(Table[] composite_list) {
        this(composite_list[0], composite_list);
    }

    private void removeDuplicates(boolean pre_sorted) {
        throw new Error("PENDING");
    }

    public void setupIndexesForCompositeFunction(int function, boolean all) {
        int size = this.composite_tables.length;
        this.table_indexes = new IntegerVector[size];
        if (function == UNION) {
            for (int i = 0; i < size; ++i) {
                this.table_indexes[i] = this.composite_tables[i].selectAll();
            }
            if (!all) {
                this.removeDuplicates(false);
            }
        } else {
            throw new Error("Unrecognised composite function");
        }
    }

    public Database getDatabase() {
        return this.master_table.getDatabase();
    }

    public int getColumnCount() {
        return this.master_table.getColumnCount();
    }

    public int getRowCount() {
        int row_count = 0;
        for (int i = 0; i < this.table_indexes.length; ++i) {
            row_count += this.table_indexes[i].size();
        }
        return row_count;
    }

    public int findFieldName(Variable v) {
        return this.master_table.findFieldName(v);
    }

    public DataTableDef getDataTableDef() {
        return this.master_table.getDataTableDef();
    }

    public Variable getResolvedVariable(int column) {
        return this.master_table.getResolvedVariable(column);
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        SelectableScheme scheme = this.column_scheme[column];
        if (scheme == null) {
            this.column_scheme[column] = scheme = new BlindSearch(this, column);
        }
        if (table == this) {
            return scheme;
        }
        return scheme.getSubsetScheme(table, original_column);
    }

    void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        if (ancestor != this) {
            throw new RuntimeException("Method routed to incorrect table ancestor.");
        }
    }

    RawTableInformation resolveToRawTable(RawTableInformation info) {
        System.err.println("Efficiency Warning in DataTable.resolveToRawTable.");
        IntegerVector row_set = new IntegerVector();
        RowEnumeration e = this.rowEnumeration();
        while (e.hasMoreRows()) {
            row_set.addInt(e.nextRowIndex());
        }
        info.add(this, row_set);
        return info;
    }

    public TObject getCellContents(int column, int row) {
        for (int i = 0; i < this.table_indexes.length; ++i) {
            IntegerVector ivec = this.table_indexes[i];
            int sz = ivec.size();
            if (row < sz) {
                return this.composite_tables[i].getCellContents(column, ivec.intAt(row));
            }
            row -= sz;
        }
        throw new Error("Row '" + row + "' out of bounds.");
    }

    public RowEnumeration rowEnumeration() {
        return new SimpleRowEnumeration(this.getRowCount());
    }

    void addDataTableListener(DataTableListener listener) {
        for (int i = 0; i < this.composite_tables.length; ++i) {
            this.composite_tables[i].addDataTableListener(listener);
        }
    }

    void removeDataTableListener(DataTableListener listener) {
        for (int i = 0; i < this.composite_tables.length; ++i) {
            this.composite_tables[i].removeDataTableListener(listener);
        }
    }

    public void lockRoot(int lock_key) {
        ++this.roots_locked;
        for (int i = 0; i < this.composite_tables.length; ++i) {
            this.composite_tables[i].lockRoot(lock_key);
        }
    }

    public void unlockRoot(int lock_key) {
        --this.roots_locked;
        for (int i = 0; i < this.composite_tables.length; ++i) {
            this.composite_tables[i].unlockRoot(lock_key);
        }
    }

    public boolean hasRootsLocked() {
        return this.roots_locked != 0;
    }

    public boolean typeEquals(RootTable table) {
        return this == table;
    }
}

