/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.SelectableRange;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataSource;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CollatedBaseSearch
extends SelectableScheme {
    public CollatedBaseSearch(TableDataSource table, int column) {
        super(table, column);
    }

    public void insert(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
    }

    public void remove(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
    }

    public void readFrom(InputStream in) throws IOException {
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    public void dispose() {
    }

    protected abstract int searchFirst(TObject var1);

    protected abstract int searchLast(TObject var1);

    protected int setSize() {
        return this.getTable().getRowCount();
    }

    protected TObject firstInCollationOrder() {
        return this.getCellContents(0);
    }

    protected TObject lastInCollationOrder() {
        return this.getCellContents(this.setSize() - 1);
    }

    protected IntegerVector addRangeToSet(int start, int end, IntegerVector ivec) {
        if (ivec == null) {
            ivec = new IntegerVector(end - start + 2);
        }
        for (int i = start; i <= end; ++i) {
            ivec.addInt(i);
        }
        return ivec;
    }

    public IntegerVector selectAll() {
        return this.addRangeToSet(0, this.setSize() - 1, null);
    }

    private int positionOfRangePoint(byte flag, TObject val) {
        switch (flag) {
            case 1: {
                if (val == SelectableRange.FIRST_IN_SET) {
                    return 0;
                }
                TObject cell = val == SelectableRange.LAST_IN_SET ? this.lastInCollationOrder() : val;
                int p = this.searchFirst(cell);
                if (p < 0) {
                    return -(p + 1);
                }
                return p;
            }
            case 2: {
                if (val == SelectableRange.LAST_IN_SET) {
                    return this.setSize() - 1;
                }
                TObject cell = val == SelectableRange.FIRST_IN_SET ? this.firstInCollationOrder() : val;
                int p = this.searchLast(cell);
                if (p < 0) {
                    return -(p + 1) - 1;
                }
                return p;
            }
            case 3: {
                if (val == SelectableRange.FIRST_IN_SET) {
                    return -1;
                }
                TObject cell = val == SelectableRange.LAST_IN_SET ? this.lastInCollationOrder() : val;
                int p = this.searchFirst(cell);
                if (p < 0) {
                    return -(p + 1) - 1;
                }
                return p - 1;
            }
            case 4: {
                if (val == SelectableRange.LAST_IN_SET) {
                    return this.setSize();
                }
                TObject cell = val == SelectableRange.FIRST_IN_SET ? this.firstInCollationOrder() : val;
                int p = this.searchLast(cell);
                if (p < 0) {
                    return -(p + 1);
                }
                return p + 1;
            }
        }
        throw new Error("Unrecognised flag.");
    }

    private IntegerVector addRange(SelectableRange range, IntegerVector ivec) {
        byte start_flag = range.getStartFlag();
        TObject start = range.getStart();
        byte end_flag = range.getEndFlag();
        TObject end = range.getEnd();
        int r1 = this.positionOfRangePoint(start_flag, start);
        int r2 = this.positionOfRangePoint(end_flag, end);
        if (r2 < r1) {
            return ivec;
        }
        return this.addRangeToSet(r1, r2, ivec);
    }

    public IntegerVector selectRange(SelectableRange range) {
        if (this.setSize() == 0) {
            return new IntegerVector(0);
        }
        IntegerVector ivec = this.addRange(range, null);
        if (ivec == null) {
            return new IntegerVector(0);
        }
        return ivec;
    }

    public IntegerVector selectRange(SelectableRange[] ranges) {
        if (this.setSize() == 0) {
            return new IntegerVector(0);
        }
        IntegerVector ivec = null;
        for (int i = 0; i < ranges.length; ++i) {
            SelectableRange range = ranges[i];
            ivec = this.addRange(range, ivec);
        }
        if (ivec == null) {
            return new IntegerVector(0);
        }
        return ivec;
    }
}

