/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CellInput;
import java.io.IOException;
import java.io.InputStream;

final class CellInputStream
implements CellInput {
    private InputStream parent_stream;
    private char[] char_buffer;

    CellInputStream(InputStream parent_stream) {
        this.setParentStream(parent_stream);
    }

    public void setParentStream(InputStream parent_stream) {
        this.parent_stream = parent_stream;
    }

    public int read() throws IOException {
        return this.parent_stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.parent_stream.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.parent_stream.skip(n);
    }

    public int available() throws IOException {
        return this.parent_stream.available();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.parent_stream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.parent_stream.reset();
    }

    public void close() throws IOException {
        this.parent_stream.close();
    }

    public void readFully(byte[] b) throws IOException {
        this.read(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public String readChars(int length) throws IOException {
        if (length <= 8192) {
            if (this.char_buffer == null) {
                this.char_buffer = new char[8192];
            }
            for (int i = 0; i < length; ++i) {
                this.char_buffer[i] = this.readChar();
            }
            return new String(this.char_buffer, 0, length);
        }
        StringBuffer chrs = new StringBuffer(length);
        for (int i = length; i > 0; --i) {
            chrs.append(this.readChar());
        }
        return new String(chrs);
    }

    public int readInt() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new Error("Not implemented.");
    }

    public String readUTF() throws IOException {
        throw new Error("Not implemented.");
    }
}

