/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableRange;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataSource;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BlindSearch
extends SelectableScheme {
    public BlindSearch(TableDataSource table, int column) {
        super(table, column);
    }

    public void insert(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
    }

    public void remove(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
    }

    public void readFrom(InputStream in) throws IOException {
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    public SelectableScheme copy(TableDataSource table, boolean immutable) {
        return new BlindSearch(table, this.getColumn());
    }

    public void dispose() {
    }

    private int search(TObject ob, IntegerVector vec, int lower, int higher) {
        if (lower >= higher) {
            if (ob.compareTo(this.getCellContents(vec.intAt(lower))) > 0) {
                return lower + 1;
            }
            return lower;
        }
        int mid = lower + (higher - lower) / 2;
        int comp_result = ob.compareTo(this.getCellContents(vec.intAt(mid)));
        if (comp_result == 0) {
            return mid;
        }
        if (comp_result < 0) {
            return this.search(ob, vec, lower, mid - 1);
        }
        return this.search(ob, vec, mid + 1, higher);
    }

    private int highestSearch(TObject ob, IntegerVector vec, int lower, int higher) {
        if (higher - lower <= 5) {
            for (int i = higher; i >= lower; --i) {
                int res = ob.compareTo(this.getCellContents(vec.intAt(i)));
                if (res < 0) continue;
                return i + 1;
            }
            return lower;
        }
        int mid = (lower + higher) / 2;
        int comp_result = ob.compareTo(this.getCellContents(vec.intAt(mid)));
        if (comp_result == 0) {
            return this.highestSearch(ob, vec, mid, higher);
        }
        if (comp_result < 0) {
            return this.highestSearch(ob, vec, lower, mid - 1);
        }
        return this.highestSearch(ob, vec, mid + 1, higher);
    }

    private void doInsertSort(IntegerVector vec, int row) {
        int list_size = vec.size();
        if (list_size == 0) {
            vec.addInt(row);
        } else {
            int point = this.highestSearch(this.getCellContents(row), vec, 0, list_size - 1);
            if (point == list_size) {
                vec.addInt(row);
            } else {
                vec.insertIntAt(row, point);
            }
        }
    }

    public IntegerVector selectAll() {
        IntegerVector row_list = new IntegerVector(this.getTable().getRowCount());
        RowEnumeration e = this.getTable().rowEnumeration();
        while (e.hasMoreRows()) {
            this.doInsertSort(row_list, e.nextRowIndex());
        }
        return row_list;
    }

    public IntegerVector selectRange(SelectableRange range) {
        int set_size = this.getTable().getRowCount();
        if (set_size == 0) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange[]{range});
    }

    public IntegerVector selectRange(SelectableRange[] ranges) {
        int set_size = this.getTable().getRowCount();
        if (set_size == 0) {
            return new IntegerVector(0);
        }
        RangeChecker checker = new RangeChecker(ranges);
        return checker.resolve();
    }

    final class RangeChecker {
        private IntegerVector sorted_set = null;
        private byte[] lower_flags;
        private byte[] upper_flags;
        private TObject[] lower_cells;
        private TObject[] upper_cells;

        public RangeChecker(SelectableRange[] ranges) {
            int size = ranges.length;
            this.lower_flags = new byte[size];
            this.upper_flags = new byte[size];
            this.lower_cells = new TObject[size];
            this.upper_cells = new TObject[size];
            for (int i = 0; i < ranges.length; ++i) {
                this.setupRange(i, ranges[i]);
            }
        }

        private void resolveSortedSet() {
            if (this.sorted_set == null) {
                this.sorted_set = BlindSearch.this.selectAll();
            }
        }

        private TObject resolveCell(TObject ob) {
            if (ob == SelectableRange.FIRST_IN_SET) {
                this.resolveSortedSet();
                return BlindSearch.this.getCellContents(this.sorted_set.intAt(0));
            }
            if (ob == SelectableRange.LAST_IN_SET) {
                this.resolveSortedSet();
                return BlindSearch.this.getCellContents(this.sorted_set.intAt(this.sorted_set.size() - 1));
            }
            return ob;
        }

        public void setupRange(int i, SelectableRange range) {
            TObject l = range.getStart();
            byte lf = range.getStartFlag();
            TObject u = range.getEnd();
            byte uf = range.getEndFlag();
            if (l == SelectableRange.FIRST_IN_SET && lf == 1) {
                this.lower_flags[i] = 0;
            } else {
                if (lf == 1) {
                    this.lower_flags[i] = 2;
                } else if (lf == 4) {
                    this.lower_flags[i] = 1;
                } else {
                    throw new Error("Incorrect lower flag.");
                }
                this.lower_cells[i] = this.resolveCell(l);
            }
            if (u == SelectableRange.LAST_IN_SET && uf == 2) {
                this.upper_flags[i] = 0;
            } else {
                if (uf == 2) {
                    this.upper_flags[i] = 2;
                } else if (uf == 3) {
                    this.upper_flags[i] = 1;
                } else {
                    throw new Error("Incorrect upper flag.");
                }
                this.upper_cells[i] = this.resolveCell(u);
            }
        }

        public IntegerVector resolve() {
            IntegerVector ivec = new IntegerVector();
            RowEnumeration e = BlindSearch.this.getTable().rowEnumeration();
            int compare_tally = 0;
            int size = this.lower_flags.length;
            block0: while (e.hasMoreRows()) {
                int row = e.nextRowIndex();
                for (int i = 0; i < size; ++i) {
                    boolean result = true;
                    byte lf = this.lower_flags[i];
                    if (lf != 0) {
                        ++compare_tally;
                        TObject v = BlindSearch.this.getCellContents(row);
                        int compare = this.lower_cells[i].compareTo(v);
                        if (lf == 1) {
                            result = compare < 0;
                        } else if (lf == 2) {
                            result = compare <= 0;
                        } else {
                            throw new Error("Incorrect flag.");
                        }
                    }
                    if (!result) continue;
                    byte uf = this.upper_flags[i];
                    if (uf != 0) {
                        ++compare_tally;
                        TObject v = BlindSearch.this.getCellContents(row);
                        int compare = this.upper_cells[i].compareTo(v);
                        if (uf == 1) {
                            result = compare > 0;
                        } else if (uf == 2) {
                            result = compare >= 0;
                        } else {
                            throw new Error("Incorrect flag.");
                        }
                    }
                    if (!result) continue;
                    BlindSearch.this.doInsertSort(ivec, row);
                    continue block0;
                }
            }
            return ivec;
        }
    }
}

