/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.Function;
import com.mckoi.database.FunctionFactory;
import com.mckoi.database.QueryContext;
import com.mckoi.database.TType;
import com.mckoi.database.VariableResolver;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFunction
implements Function {
    private String name;
    private Expression[] params;
    private boolean is_aggregate;

    public AbstractFunction(String name, Expression[] params) {
        this.name = name;
        this.params = params;
        this.is_aggregate = false;
    }

    protected void setAggregate(boolean status) {
        this.is_aggregate = status;
    }

    public int parameterCount() {
        return this.params.length;
    }

    public Expression getParameter(int n) {
        return this.params[n];
    }

    public boolean isGlob() {
        if (this.params == FunctionFactory.GLOB_LIST) {
            return true;
        }
        if (this.params.length == 1) {
            Expression exp = this.params[0];
            return exp.size() == 1 && new String(exp.text()).equals("*");
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public List allVariables() {
        ArrayList result_list = new ArrayList();
        for (int i = 0; i < this.params.length; ++i) {
            List l = this.params[i].allVariables();
            result_list.addAll(l);
        }
        return result_list;
    }

    public List allElements() {
        ArrayList result_list = new ArrayList();
        for (int i = 0; i < this.params.length; ++i) {
            List l = this.params[i].allElements();
            result_list.addAll(l);
        }
        return result_list;
    }

    public final boolean isAggregate(QueryContext context) {
        if (this.is_aggregate) {
            return true;
        }
        for (int i = 0; i < this.params.length; ++i) {
            Expression exp = this.params[i];
            if (!exp.hasAggregateFunction(context)) continue;
            return true;
        }
        return false;
    }

    public void prepareParameters(ExpressionPreparer preparer) throws DatabaseException {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].prepare(preparer);
        }
    }

    public void init(VariableResolver resolver) {
    }

    public TType returnTType(VariableResolver resolver, QueryContext context) {
        return this.returnTType();
    }

    public TType returnTType() {
        return TType.NUMERIC_TYPE;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append('(');
        for (int i = 0; i < this.params.length; ++i) {
            buf.append(this.params[i].text().toString());
            if (i >= this.params.length - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        return new String(buf);
    }
}

