/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractFunction;
import com.mckoi.database.Expression;
import com.mckoi.database.GroupResolver;
import com.mckoi.database.QueryContext;
import com.mckoi.database.TObject;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;

public abstract class AbstractAggregateFunction
extends AbstractFunction {
    public AbstractAggregateFunction(String name, Expression[] params) {
        super(name, params);
        this.setAggregate(true);
        if (this.parameterCount() != 1) {
            throw new RuntimeException("'" + name + "' function must have one argument.");
        }
    }

    public abstract TObject evalAggregate(GroupResolver var1, QueryContext var2, TObject var3, TObject var4);

    public TObject postEvalAggregate(GroupResolver group, QueryContext context, TObject result) {
        return result;
    }

    public final TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
        if (group == null) {
            throw new RuntimeException("'" + this.getName() + "' can only be used as an aggregate function.");
        }
        TObject result = null;
        int size = group.size();
        if (size == 0) {
            return new TObject(this.returnTType(resolver, context), null);
        }
        Variable v = this.getParameter(0).getVariable();
        if (v != null) {
            for (int i = 0; i < size; ++i) {
                TObject val = group.resolve(v, i);
                result = this.evalAggregate(group, context, result, val);
            }
        } else {
            Expression exp = this.getParameter(0);
            for (int i = 0; i < size; ++i) {
                TObject val = exp.evaluate(null, group.getVariableResolver(i), context);
                result = this.evalAggregate(group, context, result, val);
            }
        }
        result = this.postEvalAggregate(group, context, result);
        return result;
    }
}

