/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.util;

import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DateUtil {
    public static volatile DateFormat DEFAULT_FORMAT;
    private static volatile DateTimeFormatter defaultFormatter;
    public static volatile DateFormat SHORT_FORMAT;
    private static volatile DateTimeFormatter shortFormatter;

    private static void initializeLocale(Locale locale, String defaultDatePattern, String shortDatePattern) {
        if (locale == null) {
            try {
                locale = Application.getConfig().getLocale();
            }
            catch (NullPointerException e) {
                locale = Locale.GERMANY;
            }
        }
        if (defaultDatePattern == null) {
            try {
                defaultDatePattern = Application.getI18n().tr("dd.MM.uuuu");
            }
            catch (NullPointerException e) {
                defaultDatePattern = "dd.MM.uuuu";
            }
        }
        if (shortDatePattern == null) {
            try {
                shortDatePattern = Application.getI18n().tr("dd.MM.uu");
            }
            catch (NullPointerException e) {
                shortDatePattern = "dd.MM.uu";
            }
        }
        DEFAULT_FORMAT = new SimpleDateFormat(DateUtil.createSimpleDateFormatPattern(defaultDatePattern), locale);
        defaultFormatter = DateTimeFormatter.ofPattern(defaultDatePattern, locale);
        SHORT_FORMAT = SimpleDateFormat.getDateInstance(3, locale);
        shortFormatter = DateTimeFormatter.ofPattern(shortDatePattern, locale);
    }

    public static void setLocaleForTesting(Locale locale, String defaultDatePattern, String shortDatePattern) {
        DateUtil.initializeLocale(locale, defaultDatePattern, shortDatePattern);
    }

    public static String convert2Date(String text) {
        Optional<LocalDate> date = DateUtil.parseUserInput(text, defaultFormatter);
        return date.map(d -> d.format(defaultFormatter)).orElse(text);
    }

    public static Optional<LocalDate> parseUserInput(String userInput, DateTimeFormatter customFormatter) {
        if (userInput == null || userInput.isBlank()) {
            return Optional.empty();
        }
        String strippedUserInput = userInput.strip();
        return Stream.of(() -> DateUtil.parseDateUsingFormatter(strippedUserInput, customFormatter), () -> DateUtil.parseDateUsingPatterns(strippedUserInput, "dd", "MM"), () -> DateUtil.parseDateUsingPatterns(strippedUserInput, "d.", "M."), () -> DateUtil.parseDateUsingPatterns(strippedUserInput, "d/", "M/"), () -> DateUtil.parseDateOffsets(strippedUserInput)).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static Optional<LocalDate> parseDateUsingFormatter(String userInput, DateTimeFormatter formatter) {
        if (formatter == null) {
            return Optional.empty();
        }
        try {
            LocalDate parsedDate = LocalDate.parse(userInput, formatter);
            return Optional.of(parsedDate);
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    private static Optional<LocalDate> parseDateUsingPatterns(String userInput, String dayPattern, String monthPattern) {
        if (userInput == null || ((String)userInput).isEmpty()) {
            return Optional.empty();
        }
        if (((String)userInput).length() == 1) {
            userInput = "0" + (String)userInput;
        }
        LocalDate now = LocalDate.now();
        DateTimeFormatter inputFormatter = new DateTimeFormatterBuilder().appendPattern(dayPattern).optionalStart().appendPattern(monthPattern).optionalStart().appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, now.getYear() - 80).optionalEnd().optionalEnd().parseDefaulting(ChronoField.MONTH_OF_YEAR, now.getMonthValue()).parseDefaulting(ChronoField.YEAR, now.getYear()).toFormatter();
        return DateUtil.parseDateUsingFormatter((String)userInput, inputFormatter);
    }

    private static Optional<LocalDate> parseDateOffsets(String userInput) {
        int offset;
        String regex;
        Pattern pattern;
        Matcher matcher;
        if (userInput == null || userInput.isEmpty()) {
            return Optional.empty();
        }
        if (userInput.equalsIgnoreCase("h") || userInput.equalsIgnoreCase("t")) {
            userInput = "+0";
        }
        if (!(matcher = (pattern = Pattern.compile(regex = "^((\\+{1,2}|-{1,2}))(\\d+)$")).matcher(userInput)).matches()) {
            return Optional.empty();
        }
        String prefix = matcher.group(1);
        String digits = matcher.group(3);
        try {
            offset = Integer.parseInt(digits);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        Map<String, Function<Integer, LocalDate>> offsetFunctions = Map.of("+", LocalDate.now()::plusDays, "++", LocalDate.now()::plusMonths, "-", LocalDate.now()::minusDays, "--", LocalDate.now()::minusMonths);
        return Optional.ofNullable(offsetFunctions.get(prefix)).map(func -> (LocalDate)func.apply(offset));
    }

    private static String createSimpleDateFormatPattern(String dateTimeFormatterPattern) {
        return dateTimeFormatterPattern.replace("u", "y");
    }

    public static DateTimeFormatter createDateTimeFormatter(DateFormat dFormat) {
        if (dFormat.equals(DEFAULT_FORMAT)) {
            return defaultFormatter;
        }
        if (dFormat.equals(SHORT_FORMAT)) {
            return shortFormatter;
        }
        if (!(dFormat instanceof SimpleDateFormat)) {
            Logger.warn((String)"Unable to create DateTimeFormatter from custom DateFormat. Using default Formatter");
            return defaultFormatter;
        }
        String sdPattern = ((SimpleDateFormat)dFormat).toPattern();
        String dateTimeFormatterPattern = sdPattern.replace("y", "u");
        return DateTimeFormatter.ofPattern(dateTimeFormatterPattern);
    }

    public static Date localDate2Date(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate addMonthsMaintainingEndOfMonth(LocalDate date, long months) {
        if (date == null) {
            return null;
        }
        boolean isEndOfMonth = date.equals(date.with(TemporalAdjusters.lastDayOfMonth()));
        LocalDate adjustedDate = date.plusMonths(months);
        if (isEndOfMonth) {
            adjustedDate = adjustedDate.with(TemporalAdjusters.lastDayOfMonth());
        }
        return adjustedDate;
    }

    public static DatePositions getDatePositions(DateTimeFormatter dtFormatter) {
        LocalDate testDate = LocalDate.of(3333, 11, 22);
        String formattedTestDate = dtFormatter.format(testDate);
        String dayString = "22";
        int dayIndex = formattedTestDate.indexOf(dayString);
        String monthString = "11";
        int monthIndex = formattedTestDate.indexOf(monthString);
        return new DatePositions(dayIndex, 2, monthIndex, 2);
    }

    public static Date startOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date endOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    static {
        DateUtil.initializeLocale(null, null, null);
    }

    public static class DatePositions {
        private final int dayIndex;
        private final int dayWidth;
        private final int monthIndex;
        private final int monthWidth;

        public DatePositions(int dayIndex, int dayWidth, int monthIndex, int monthWidth) {
            this.dayIndex = dayIndex;
            this.dayWidth = dayWidth;
            this.monthIndex = monthIndex;
            this.monthWidth = monthWidth;
        }

        public int dayIndex() {
            return this.dayIndex;
        }

        public int dayWidth() {
            return this.dayWidth;
        }

        public int monthIndex() {
            return this.monthIndex;
        }

        public int monthWidth() {
            return this.monthWidth;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DatePositions)) {
                return false;
            }
            DatePositions other = (DatePositions)obj;
            return this.dayIndex == other.dayIndex() && this.dayWidth == other.dayWidth() && this.monthIndex == other.monthIndex() && this.monthWidth == other.monthWidth();
        }

        public int hashCode() {
            int result = Integer.hashCode(this.dayIndex);
            result = 31 * result + Integer.hashCode(this.dayWidth);
            result = 31 * result + Integer.hashCode(this.monthIndex);
            result = 31 * result + Integer.hashCode(this.monthWidth);
            return result;
        }
    }
}

