/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.update;

import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.jameica.update.Repository;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class RepositorySearchResult {
    private Repository repo;
    private Map<PluginGroup, TreeMap<String, List<PluginData>>> result = new HashMap<PluginGroup, TreeMap<String, List<PluginData>>>();

    public RepositorySearchResult(Repository r, String query) {
        this.repo = r;
        query = StringUtils.trimToNull((String)query);
        if (query != null) {
            query = query.toLowerCase();
        }
        for (PluginGroup group : r.getPluginGroups()) {
            TreeMap groupMap = new TreeMap();
            for (PluginData d : group.getPlugins()) {
                ArrayList<PluginData> matches;
                String name = d.getName();
                String desc = d.getDescription();
                if (query != null) {
                    boolean m2;
                    boolean m1 = name != null && name.toLowerCase().contains(query);
                    boolean bl = m2 = desc != null && desc.toLowerCase().contains(query);
                    if (!m1 && !m2) continue;
                }
                if ((matches = (ArrayList<PluginData>)groupMap.get(name)) == null) {
                    matches = new ArrayList<PluginData>();
                    groupMap.put(name, matches);
                }
                try {
                    d.getManifest().canDeploy(false);
                    matches.add(d);
                }
                catch (ApplicationException ae) {
                    Logger.debug((String)("skipping plugin " + name + " " + d.getAvailableVersion() + ": " + ae.getMessage()));
                }
            }
            for (List values : groupMap.values()) {
                Collections.sort(values, new Comparator<PluginData>(){

                    @Override
                    public int compare(PluginData o1, PluginData o2) {
                        return o2.getAvailableVersion().compareTo(o1.getAvailableVersion());
                    }
                });
            }
            if (groupMap.size() <= 0) continue;
            this.result.put(group, groupMap);
        }
    }

    public List<PluginGroup> getGroups() {
        ArrayList<PluginGroup> groups = new ArrayList<PluginGroup>(this.result.keySet());
        Collections.sort(groups, new Comparator<PluginGroup>(){

            @Override
            public int compare(PluginGroup o1, PluginGroup o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return groups;
    }

    public TreeMap<String, List<PluginData>> getResult(PluginGroup group) {
        return this.result.get(group);
    }

    public int size() {
        int count = 0;
        for (TreeMap<String, List<PluginData>> t : this.result.values()) {
            count += t.size();
        }
        return count;
    }

    public Repository getRepository() {
        return this.repo;
    }
}

