/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.update;

import de.willuhn.jameica.security.SSLFactory;
import de.willuhn.jameica.services.TransportService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.Repository;
import de.willuhn.jameica.util.XPathEmu;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.n3.nanoxml.IXMLElement;

public class PluginGroup {
    private Repository repository = null;
    private X509Certificate cert = null;
    private String name = null;
    private List<PluginData> plugins = new ArrayList<PluginData>();

    protected PluginGroup(Repository repository, IXMLElement root) throws Exception {
        this.repository = repository;
        this.name = root.getAttribute("name", null);
        this.initCertificate(root.getAttribute("certificate", null));
        XPathEmu xpath = new XPathEmu(root);
        IXMLElement[] list = xpath.getElements("plugin");
        if (list == null || list.length == 0) {
            Logger.warn((String)("plugingroup \"" + this.name + "\" contains no plugins"));
            return;
        }
        for (IXMLElement e : list) {
            String pu = e.getAttribute("url", null);
            if (pu == null || pu.length() == 0) continue;
            try {
                this.plugins.add(new PluginData(this, new URL(pu)));
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)(oce.getMessage() + ", skipping"));
            }
            catch (Exception ex) {
                Logger.error((String)("unable to load plugin data for url: " + pu + ", skipping"), (Throwable)ex);
            }
        }
    }

    private void initCertificate(String certUrl) throws Exception {
        if (certUrl == null || certUrl.length() == 0) {
            Logger.warn((String)"no certificate given");
            return;
        }
        SSLFactory factory = Application.getSSLFactory();
        TransportService ts = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
        Transport t = ts.getTransport(new URL(certUrl));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        t.get(bos, null);
        Collection<X509Certificate> chain = factory.loadCertificates(new ByteArrayInputStream(bos.toByteArray()));
        if (chain == null || chain.size() == 0) {
            throw new ApplicationException(Application.getI18n().tr("Zertifikat des Repositories nicht lesbar"));
        }
        X509Certificate[] list = chain.toArray(new X509Certificate[chain.size()]);
        factory.getTrustManager().checkServerTrusted(list, "RSA");
        CertPath certPath = factory.getCertificateFactory().generateCertPath(Arrays.asList(list));
        this.cert = (X509Certificate)certPath.getCertificates().get(0);
    }

    public String getName() {
        return this.name;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<PluginData> getPlugins() {
        return this.plugins;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

